/*
 * config.h for tiny-login - This file is part of the tiny-utils package for
 * Linux and ELKS, Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/* Define SUPPORT_REMOTE to support remote logins */
#undef SUPPORT_REMOTE

/* Define SUPPORT_UTMP to include support for updating of the
   UTMP and WTMP files */
#define SUPPORT_UTMP

/* The name to print for error reporting */
#define PROGRAM_NAME "tiny-login"

/* The number of login failures before login terminates */
#define MAX_FAILURES 4

/* The buffer size to use when reading the motd and issue files */
#define BUFFER_SIZE 1024

/* The location of the motd file */
#define MOTD_FILE "/etc/motd"

/* The permissions to which the user's tty should be set on login */
#define TTY_MODE 0620

/* The string printed to prompt the user for his username */
#define LOGIN_PROMPT "login: "

/* The string printed to prompt the user for his password */
#define PW_PROMPT "Password: "

/* The strin printed when the user enters an incorrect login/passwd */
#define FAIL_MESSAGE "Login incorrect\n"

/* The maximum length of the password buffer */
#define MAX_PW_LENGTH 15

/* The maximum length of the username buffer */
#define MAX_USERNAME_LENGTH 10

/* If we support remote logins ... */
#ifdef SUPPORT_REMOTE

/* The maximum length for the hostname of the incoming connection */
#define MAX_HOSTNAME_LENGTH 1024
#endif /* SUPPORT_REMOTE */

#endif /* __CONFIG_H */
