/****************************************************************************/
/*                                                                          */
/* Program:   i_histogram.c                                                 */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Wed Feb 26 11:51:42 1992                                      */
/* Function:  Histogram Routines                                            */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "lib.h"

/*#define debug(m) DEBUG("<histogram> " m)*/
#define debug(m)

#define colour_hash(p) ((((p)->r+(p)->g+(p)->b)&0x7fff)%IM_HIST_HASHSIZE)

/****************************************************************************/

it_hist *i_create_histogram(int maxcolours)
{
  it_hist *hist;

  if(maxcolours<1)
    return(NULL);
  if((hist=(it_hist *) calloc(1,sizeof(it_hist)))==NULL)
    return(NULL);
  hist->maxcolours=maxcolours;
  hist->hist_list=(it_hist_entry *) calloc(maxcolours,sizeof(it_hist_entry));
  if(hist->hist_list==NULL)
    {
      free((char *) hist);
      return(NULL);
    }
  return(hist);
}

void i_destroy_histogram(it_hist *hist)
{
  if(hist!=NULL)
    {
      if(hist->hist_list!=NULL) free((char *) (hist->hist_list));
      free((char *) hist);
    }
}

it_hist_entry *i_add_histogram_entry(it_hist *hist,it_rgb *colour)
{
  it_hist_entry *entry;
  int colour_hash_value;

  if((entry=i_lookup_histogram_colour(hist,colour))==NULL)
    {
      if(hist->numcolours>=hist->maxcolours)
	return(NULL);
      entry= &(hist->hist_list[hist->numcolours]);
      entry->index=(hist->numcolours)++;
      (entry->colour).r=colour->r;
      (entry->colour).g=colour->g;
      (entry->colour).b=colour->b;
      colour_hash_value=colour_hash(colour);
      entry->next_col=hist->hash_col[colour_hash_value];
      hist->hash_col[colour_hash_value]=entry;
    }
  entry->count++;
  return(entry);
}

it_hist_entry *i_lookup_histogram_index(it_hist *hist,int index)
{
  if(index<0 || index>=hist->maxcolours) return(NULL);
  return(&(hist->hist_list[index]));
}

it_hist_entry *i_lookup_histogram_colour(it_hist *hist,it_rgb *colour)
{
  it_hist_entry *ptr;

  for(ptr=hist->hash_col[colour_hash(colour)];ptr!=NULL;ptr=ptr->next_col)
    if(im_rgb_equal(colour,&(ptr->colour))) break;
  return(ptr);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
