/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgForwardFFT.c                                               */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:42 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "ForwardFFT"
#define ERROR(e) imgError(e,PRGNAME)

void test_size(int);

int main(int argc,char **argv)
{
  it_image *image,*cpx_image;
  int width,height;
  it_float *flt_ptr;
  it_complex *cpx_ptr;
  long size,count;
  double factor;

  IFHELP
    {
      fprintf(stderr,"img%s - Forward fast Fourier transform\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Complex\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    image=i_read_image_file(stdin,IT_FLOAT,IM_CONTIG);
    if(image==NULL)
      ERROR("can't import image file");
    width=image->width;
    height=image->height;
    test_size(width);
    test_size(height);

    cpx_image=i_create_image(width,height,IT_COMPLEX,IM_CONTIG);
    if(cpx_image==NULL)
      ERROR("out of memory");
    cpx_image->valid_x=image->valid_x;
    cpx_image->valid_y=image->valid_y;
    cpx_image->valid_width=image->valid_width;
    cpx_image->valid_height=image->valid_height;

    /* Copy input image to real part of complex image */
    flt_ptr=im_float_row(image,0);
    cpx_ptr=im_complex_row(cpx_image,0);
    size=(long) width *(long) height;
    for(count=size;count--;)
      {
	cpx_ptr->Re= *flt_ptr++;
	cpx_ptr->Im=0.0;
	cpx_ptr++;
      }
    i_destroy_image(image);

    /* Carry out FFT of cpx_image */
    i_fourier_transform_2d(cpx_image,FFFT);

    /* Normalise */
    factor=1.0/(double) size;
    cpx_ptr=im_complex_row(cpx_image,0);
    for(count=size;count--;)
      {
	cpx_ptr->Re*=factor;
	cpx_ptr->Im*=factor;
	cpx_ptr++;
      }

    i_write_image_file(stdout,cpx_image,IF_BINARY);
    i_destroy_image(cpx_image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}

void test_size(int size)
{    
  int temp=size;
  
  while(size>>=1)
    if(size&temp)
      ERROR("image dimensions must be a power of two");
}

/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
