/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgNoise.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:50 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Noise"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

#define DEFAULTSIGMA 1.0

extern void srand48(long);
extern double drand48(void);

double gauss_rand(void);

int main(int argc,char **argv)
{
  it_image *im1;
  int width,height,x,y;
  double sigma;
  double pix,min,max;
  long seed;
  time_t clock;

  IFHELP
    {
      fprintf(stderr,"img%s - Add Gaussian random noise\n",
	      PRGNAME);
      fprintf(stderr,"img%s [std_dev]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  std_dev is the noise standard deviation\n");
      exit(0);
    }

  imgStart(PRGNAME);

  sigma=DEFAULTSIGMA;
  
  time(&clock);
  seed=clock;
  srand48(seed);

  if(argc>2)
    ERROR("invalid arguments");
  if(argc==2)
    sigma=atof(argv[1]);

  /* Loop for all images */
  do {
    im1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(im1==NULL)
      ERROR("can't import image file");
    width=im1->width;
    height=im1->height;

    /* adjust each pixel by a gaussian distributed random amount */
    imgInitMinMax(min,max);
    for(y=0;y<height;y++)
      for(x=0;x<width;x++)
	{
	  pix=im_float_value(im1,x,y)+sigma*gauss_rand();
	  im_float_value(im1,x,y)=pix;
	  if(pix>max)
	    max=pix;
	  if(pix<min)
	    min=pix;
	}

    im1->min_value=min;
    im1->max_value=max;
    i_write_image_file(stdout,im1,IF_BINARY);
    i_destroy_image(im1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}

/* Random number generator from Numerical Recepies */
double gauss_rand(void)
{
  static int generate_deviate=1;
  static double next_gaussian_deviate;
  double radius,factor,v1,v2,rad;

 /* Initialise or generate two new gaussian deviates */
  if(generate_deviate)
    {
      generate_deviate=0;
      
      /* Generate two uniform numbers in the square extending */
      /* from -1 to 1 in each direction within a unit circle. */
      do
	{
	  v1=drand48()*2.0-1.0;
	  v2=drand48()*2.0-1.0;
	  rad=v1*v1 + v2*v2;
        }
      while(rad>=1.0);
      radius=rad;

      /* Box-Muller Transformation to get two normal deviates */
      factor=sqrt(-2.0*log(radius)/radius);

      /* Retain one gaussian normal deviate for next call to function */
      next_gaussian_deviate=v1*factor;

      /* Return one gaussian normal deviate */
      return(v2*factor);
    }

  /* Otherwise use next precomputed gaussian normal deviate */
  generate_deviate=1;
  return(next_gaussian_deviate);
}

/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
