/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgSelect.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:56 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Select"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int select_start,select_incr,select_count,finished,count;

  IFHELP
    {
      fprintf(stderr,"img%s - Pick out a set of images from the stream\n",
	      PRGNAME);
      fprintf(stderr,"img%s [start [incr [count]]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      exit(0);
    }

  imgStart(PRGNAME);

  select_start=0;
  select_incr=2;
  select_count=999;
  
  if(argc>4)
    ERROR("illegal arguments");
  if(argc>1)
    select_start=atoi(argv[1]);
  if(argc>2)
    select_incr=atoi(argv[2]);
  if(argc>3)
    select_count=atoi(argv[3]);

  count=0;
  finished=0;
  while(!finished)
    {
      if((image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT))==NULL)
	ERROR("can't import image file");
      if(count==select_start)
	{
	  i_write_image_file(stdout,image,IF_BINARY);
	  if(--select_count<=0)
	    finished=1;
	  select_start+=select_incr;
	}
      i_destroy_image(image);
      count++;
      if(feof(stdin))
	finished=1;
    }

  /* Junk further input */
  while(fgetc(stdin)!=EOF);

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
