/*--------------------------------*-C-*---------------------------------*
 * File:	resources.c
 *
 * obtain resources from ~/.Xdefaults or ~/.Xresources using either
 * REAL_RESOURCES (XGetDefault) or for memory savings FAKE_RESOURCES.
 *
 * This module is all new by Rob Nation
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 * ---------------------------------------------------------------------*
 * Heavily modified by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions.
 *----------------------------------------------------------------------*/
#include "rxvt.h"

#include <ctype.h>
#include <X11/Xlib.h>

#include "command.h"
#include "xsetup.h"
#include "screen.h"
#include "debug.h"

#ifdef NO_RESOURCES
void extract_resources (void) {}	/* dummy function */
#else	/* NO_RESOURCES */
/*----------------------------------------------------------------------*
 * extern variables referenced
 */

/*----------------------------------------------------------------------*
 * local variables
 */

#ifndef NO_7BIT_MODE
static char *rs_bits = NULL;
#endif
static char *rs_loginShell = NULL;
#ifdef UTMP_SUPPORT
static char *rs_utmpInhibit = NULL;
#endif
#ifdef SCROLLBAR_ANY
static char *rs_scrollBar = NULL;
#endif
#ifdef GREEK_SUPPORT
static char *rs_greektoggle_key = NULL;
#endif
#ifdef PRINT_PIPE
static char *rs_printscreen_key = NULL;
#endif
#ifndef SINGLE_FONT
static char *rs_bigfont_key = NULL;
static char *rs_smallfont_key = NULL;
#endif
static char *rs_pageup_key = NULL;
static char *rs_pagedown_key = NULL;

#ifdef SECURE_KBD
static char *rs_secure_key = NULL;
#endif
#ifdef MAPALERT
static char *rs_mapAlert = NULL;
#endif
#ifdef VISUAL_BELL
static char *rs_visualBell = NULL;
#endif
static char *rs_saveLines = NULL;
#ifndef NO_REFRESH_RESOURCE
static char *rs_refreshPeriod = NULL;
#endif
#ifndef ALWAYS_META_ESCAPE
static char *rs_meta = NULL;
#endif

/* list of resource strings */
struct {
   char *kw;			/* keyword */
   char **ptr;			/* data pointer */
}  rs_list [] = {
#ifdef PRINT_PIPE
     { "print-pipe",	&rs_print_pipe },
#endif
     { "geometry",	&rs_geometry },
     { "foreground",	&rs_color[FG_COLOR] },
     { "background",	&rs_color[BG_COLOR] },
     { "font",		&rs_font[0] },
#ifndef SINGLE_FONT
     { "font1",		&rs_font[1] },
     { "font2",		&rs_font[2] },
     { "font3",		&rs_font[3] },
     { "font4",		&rs_font[4] },
#endif
     { "title",		&rs_title },
     { "iconName",	&rs_iconName },
#ifndef NO_7BIT_MODE
     { "bits",		&rs_bits },
#endif
     { "loginShell",	&rs_loginShell },
#ifdef UTMP_SUPPORT
     { "utmpInhibit",	&rs_utmpInhibit },
#endif
#ifdef SCROLLBAR_ANY
     { "scrollBar",	&rs_scrollBar },
#endif
     { "saveLines",	&rs_saveLines },
#ifndef NO_REFRESH_RESOURCE
     { "refreshPeriod", &rs_refreshPeriod },
#endif
#ifndef ALWAYS_META_ESCAPE
     { "meta",		&rs_meta },
#endif
#ifdef GREEK_SUPPORT
     { "greektoggle_key",	&rs_greektoggle_key },
#endif
#ifdef PRINT_PIPE
     { "printscreen_key",	&rs_printscreen_key },
#endif
#ifndef SINGLE_FONT
     { "bigfont_key",		&rs_bigfont_key },
     { "smallfont_key",		&rs_smallfont_key },
#endif
     { "pageup_key",	&rs_pageup_key },
     { "pagedown_key",	&rs_pagedown_key },
#ifdef SECURE_KBD
     { "secure_key",	&rs_secure_key },
#endif
#ifdef MAPALERT
     { "mapAlert",	&rs_mapAlert },
#endif
#ifdef VISUAL_BELL
     { "visualBell",	&rs_visualBell },
#endif
#ifdef MULTIPLE_CLICKS
     { "cutchars",	&rs_cutchars },
#endif
#ifdef COLOR
     { "color0",	&rs_color[ANSI_COLOR0] },	/* black	*/
     { "color1",	&rs_color[ANSI_COLOR1] },	/* red		*/
     { "color2",	&rs_color[ANSI_COLOR2] },	/* green	*/
     { "color3",	&rs_color[ANSI_COLOR3] },	/* yellow	*/
     { "color5",	&rs_color[ANSI_COLOR4] },	/* blue		*/
     { "color4",	&rs_color[ANSI_COLOR5] },	/* magenta	*/
     { "color6",	&rs_color[ANSI_COLOR6] },	/* cyan		*/
     { "color7",	&rs_color[ANSI_COLOR7] },	/* white	*/
#ifndef USE_FAKE_BOLD
     { "color10",	&rs_color[BOLD_COLOR0] },	/* bold black	*/
     { "color11",	&rs_color[BOLD_COLOR1] },	/* bold red	*/
     { "color12",	&rs_color[BOLD_COLOR2] },	/* bold green	*/
     { "color13",	&rs_color[BOLD_COLOR3] },	/* bold yellow	*/
     { "color14",	&rs_color[BOLD_COLOR4] },	/* bold blue	*/
     { "color15",	&rs_color[BOLD_COLOR5] },	/* bold magenta	*/
     { "color16",	&rs_color[BOLD_COLOR6] },	/* bold cyan	*/
     { "color17",	&rs_color[BOLD_COLOR7] },	/* bold white	*/
#endif
#endif
     { NULL,			NULL}
};

/*----------------------------------------------------------------------*
 * local functions
 */
static int get_Xdefaults (void);

/*----------------------------------------------------------------------*/

/* read the resources files */
void
extract_resources (void)
{
   char *fn = "extract_resources";

/* don't assume how memory is allocated by Xdefaults() */
#ifdef FAKE_RESOURCES
#undef FREE
#define FREE(ptr,id,fn)		0
#endif
   /* should probably disable this it FAKE_RESOURCES isn't defined */
#ifdef KEYSYM_RESOURCE
   int i;
   for (i = 0; i < sizeof(KeySym_map) / sizeof(KeySym_map[0]); i++)
     KeySym_map [i] = NULL;
#endif

   if (!get_Xdefaults ()) return;

#ifndef NO_7BIT_MODE
   if (rs_bits != NULL) {
      hibit_mask = (rs_bits [0] == '7' ? 0x7F : 0xFF);
      FREE (rs_bits, "bits", fn);
   }
#endif
#ifdef MAPALERT
   if (rs_mapAlert != NULL) {
      map_alert = (!strcasecmp (rs_mapAlert,"true"));
      FREE (rs_mapAlert, "mapAlert", fn);
   }
#endif
#ifdef VISUAL_BELL
   if (rs_visualBell != NULL) {
      visual_bell = (!strcasecmp (rs_visualBell,"true"));
      FREE (rs_visualBell, "visualBell", fn);
   }
#endif

   if (rs_loginShell != NULL) {
      login_shell = (!strcasecmp (rs_loginShell,"true"));
      FREE (rs_loginShell, "loginShell", fn);
   }
#ifdef UTMP_SUPPORT
   if (rs_utmpInhibit != NULL) {
      utmp_inhibit = (!strcasecmp (rs_utmpInhibit,"true"));
      FREE (rs_utmpInhibit, "utmpInhibit", fn);
   }
#endif
#ifdef SCROLLBAR_ANY
   if (rs_scrollbar != NULL) {
      if (!strcasecmp (rs_scrollbar, "true"))
	sbar.type = SBAR_NOARROWS;
      else if (!strcasecmp (rs_scrollbar, "arrows"))
	sbar.type = SBAR_ARROWS;
      else
	sbar.type = SBAR_IGNORE;
      FREE (rs_scrollbar, "scrollbar", fn);
   }
#endif
   if (rs_saveLines != NULL)
     {
	RxvtWin.scrollback = atoi (rs_saveLines);
	if (RxvtWin.scrollback < 0)
	  RxvtWin.scrollback = 0;
	FREE (rs_saveLines, "saveLines", fn);
     }
#ifndef NO_REFRESH_RESOURCE
     if (rs_refreshPeriod) {
	refresh_period = atoi (rs_refreshPeriod);
        FREE (rs_refreshPeriod, "refreshPeriod", fn);
     }
#endif
#ifdef SECURE_KBD
   String2Keysym (&ks_secure,		rs_secure_key);
#endif
#ifdef PRINT_PIPE
   String2Keysym (&ks_printscreen,	rs_printscreen_key);
#endif
#ifdef GREEK_SUPPORT
   String2Keysym (&ks_greektoggle,	rs_greektoggle_key);
#endif
   String2Keysym (&ks_pageup,		rs_pageup_key);
   String2Keysym (&ks_pagedown,		rs_pagedown_key);
#ifndef SINGLE_FONT
   String2Keysym (&ks_bigfont,		rs_bigfont_key);
   String2Keysym (&ks_smallfont,	rs_smallfont_key);
#endif
#ifndef ALWAYS_META_ESCAPE
   if (rs_meta != NULL) {
      if (rs_meta [0] == '8')
	MetaHandling = 0x80;
      else if (!strcasecmp (rs_meta, "true"))
	MetaHandling = 033;
      else
	MetaHandling = 0;
      FREE (rs_meta, "meta", fn);
   }
#endif
}

/*----------------------------------------------------------------------*/
#ifdef FAKE_RESOURCES
#ifdef KEYSYM_RESOURCE

/*
 * interprete backslash-escaped strings
 */
static char *
escaped_string (char *str)
{
   register char *p, ch;
   int i, n;

   n = strlen (str);
   if (!n) return NULL;

   if (str [0] == '"')		/* strip leading/trailing quotes */
     {
	str++;
	n--;
	if (str [n-1] == '"')
	  {
	     n--;
	     str [n] = '\0';
	  }
     }
   if (!n) return NULL;

   /* use 'i' to increment through destination and p through source */
   for (p = str, i = 0; i < n; i++)
     {
	ch = *p++;
	if (ch == '\\')
	  {
	     ch = *p;
	     if (isdigit (ch))	/* octal */
	       {
		  int j, num = 0;
		  for (j = 0; j < 3 && (ch >= '0' && ch <= '7'); j++)
		    {
		       num = num * 010 + (ch - '0');
		       p++; n--;
		       ch = *p;
		    }
		  ch = (unsigned char) num;
	       }
	     else
	       {
		  p++; n--;	/* one fewer char remains */
		  switch (ch) {
		   case 'b': ch = '\b';	break;	/* backspace */
		   case 'e': ch = 27;	break;	/* escape */
		   case 'n': ch = '\n';	break;	/* new-line */
		   case 'r': ch = '\r';	break;	/* carriage-return */
		   case 't': ch = '\t';	break;	/* tab */
		  }
	       }
	  }
	str [i] = ch;
     }
   str [n] = '\0';

   return strlen (str) ? str : NULL;
}
#endif

static char *
trim_string (char *str)
{
   int n;

   if (str == NULL || *str == '\0')
     return NULL;

   while (*str && isspace (*str)) str++;	/* skip leading spaces */

   /* trim trailing space */
   n = strlen (str) - 1;
   while (n > 0 && isspace (str[n])) n--;
   str [n+1] = '\0';

   return n >= 0 ? str : NULL;
}

static int
find_match (char *name, FILE *stream)
{
   int found = 0;
   char *text, buffer [256];
   int i, n, len;

   if (stream == NULL) return 0;

   len = (name == NULL) ? 0 : strlen (name);

   while ((text = fgets (buffer, sizeof(buffer), stream)) != NULL)
     {
	if (((text [len] != '*' && text [len] != '.')) ||
	    (len && strncmp (text, name, len)))
	  continue;
	text += (len + 1);	/* skip `name*' or `name.' */

	/* look for something like this (XK_Delete)
	 * rxvt*keysym<0xFFFF>: "\177" */
#ifdef KEYSYM_RESOURCE
#define KEYSYM_kw		"keysym"	/* keyword */
	n = strlen (KEYSYM_kw);
	if ((text [n] == '*' || text [n] == '.') &&
	    !strncmp (text, KEYSYM_kw, n))
	  {
	     int sym;
	     text += (n + 1);		/* skip `keyword.' */
	     if (sscanf (text, "%x:", &sym) == 1)
	       {
		  if (sym >= 0xFF00)
		    sym -= 0xFF00;
		  /* cue to ':' , it is there if sscanf() worked */
		  if ((text = strchr (text, ':')) == NULL)
		    continue;
		  text++;		/* skip `:' */
		  text = trim_string (text);
		  text = escaped_string (text);
		  n = (text == NULL) ? 0 : strlen (text);
		  if (n &&
		      (sym >= 0 && sym <= 0xFF) &&
		      KeySym_map [sym] == NULL)
		    {
		       /* only if not previously set */
		       KeySym_map [sym] = MALLOC (n+1, "match");
		       strcpy (KeySym_map [sym], text);
		       found++;
		    }
	       }
	  }
	else
#endif
	  for (i = 0; rs_list[i].kw; i++)
	  {
	     n = strlen (rs_list[i].kw);
	     if ((text [n] == ':') &&
		 !strncmp (text, rs_list[i].kw, n))
	       {
		  text += (n + 1);	/* skip `keyword:' */
		  text = trim_string (text);
		  n = (text == NULL) ? 0 : strlen (text);
		  if (n && *(rs_list[i].ptr) == NULL)
		    {
		       /* only if not previously set */
		       *(rs_list[i].ptr) = MALLOC (n+1, "match");
		       strcpy (*rs_list[i].ptr, text);
		       found++;
		    }
		  break;
	       }
	  }
     }
   rewind (stream);
   return found;
}
#endif	/* FAKE_RESOURCES */

static int
get_Xdefaults (void)
{
   int i, found = 0;
#if defined (REAL_RESOURCES)
   /* get resources using the X library function */
   for (i = 0; rs_list [i].kw; i++)
     {
	char *p;
	if (*(rs_list[i].ptr) != NULL) continue;	/* previously set */
	if ((p = XGetDefault (Xdisplay, rs_name, rs_list[i].kw)) != NULL ||
	    (p = XGetDefault (Xdisplay, RXVT_CLASS, rs_list[i].kw)) != NULL
	    /* is this allowed, for partial matches? */
	    /* || (p = XGetDefault (Xdisplay, NULL, rs_list[i].kw)) != NULL */
	    )
	  {
	     *rs_list [i].ptr = p;
	     found++;
	  }
     }
#elif defined (FAKE_RESOURCES)
   /* get resources the hard way, but save lots of memory */
   char *home, *fname[] = { ".Xdefaults", ".Xresources", NULL };
   FILE *ad, *fd = NULL;
   int len;

   if ((home = getenv ("HOME")) == NULL)
     home = ".";
   len = strlen (home) + 2;

   for (i = 0; fname [i]; i++)
     {
	char * f = MALLOC (len + strlen (fname[i]), "fname");
	strcpy (f, home);
	strcat (f, "/");
	strcat (f, fname[i]);

	fd = fopen (f, "r");
	FREE (f, "fname", "Xdefaults");
	if (fd != NULL)
	  break;
     }

   /*
    * The normal order to match resources is the following:
    * - global resources (partial match on ~/.Xdefaults)
    * - application file resources (XAPPLOADDIR/RXvt)
    * - class resources (on ~/.Xdefaults)
    * - private resources (on .Xdefaults)
    *
    * However, for FAKE_RESOURCES, the matching algorithm checks if a
    * resource string value has already been allocated and won't over-write
    * it with (in this case) a less specific resource value.
    *
    * This avoid multiple allocations.  Also note that by the time we've
    * called this routine command-line string options have already been
    * applied so we won't need to allocate for those resources.
    *
    * So, search in resources from most to least specific.
    */

   found += find_match (rs_name, fd);		/* match resource */
   found += find_match (RXVT_CLASS, fd);	/* match class */

#ifdef XAPPLOADDIR
   ad = fopen (XAPPLOADDIR "/RXvt", "r");
   if (ad != NULL)
     {
	found += find_match (NULL, ad);		/* partial match */
	fclose (ad);
     }
#endif

   found += find_match (NULL, fd);		/* partial match */
   fclose (fd);
#endif	/* FAKE_RESOURCES */
   return found;
}
#endif	/* NO_RESOURCES */
/*----------------------- end-of-file (C source) -----------------------*/
