/*--------------------------------*-C-*---------------------------------*
 * $Id: utmp.c,v 1.4 1993/08/09 11:54:15 lipka Exp lipka $
 *
 * Public:
 *    makeutent ();
 *    cleanutent ();
 *
 * Private:
 *	get_tslot ();
 *	write_utmp ();
 *	write_wtmp ();
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 * ---------------------------------------------------------------------*
 *
 * Revision 1.6  07DEC95:16	Piet W. Plomp,
 * wtmp support for (at least linux)
 *
 * Revision 1.55  1995/10/16  16:04:16  rgg
 * now works in Solaris 2.x and Linux 1.2.x
 *
 * Revision 1.5 08/09/1993 stempien
 * Something was wrong with the Linux support!
 * I fixed it using the provided utmp manipulation routines.
 * I also surrounded many varables that were not needed for Linux
 * in the BSD defines to reduce the memory needed to run.
 * I didn't touch the Sun part of the code so it should still work.
 *
 * $Log: utmp.c,v $
 * Revision 1.4  1993/08/09  11:54:15  lipka
 * now works both on Linux and SunOs 4.1.3.
 * Brians clean-ups incorporated
 *
 * Revision 1.3  1993/08/09  07:16:42  lipka
 * nearly correct (running) linux-version.
 * Delete-Window is still a problem
 *
 * Revision 1.1  1993/08/07  18:03:53  lipka
 * Initial revision
 *
 * Clean-ups according to suggestions of Brian Stempien (stempien@cs.wmich.edu)
 *
 *    Bugs:
 *	UTMP should be locked from call to utmp_end() 'til makeutent() (?).
 *	Maybe the child should tell the parent, where the entry is made.
 *	Tested only on Linux.
 *
 *	Gives weird inital idle times. They go away after one uses the
 *	window, but......
 * ------------------------------------------------------------------------
 * This version has wtmp support for (at least linux) added by:
 *    Piet W. Plomp,
 *    ICCE - Institute for educational technology,
 *    State University of Groningen, The Netherlands,
 *    piet@icce.rug.nl or (faster) piet@idefix.icce.rug.nl
 *
 *  All additions were put in the non-BSD branch
 *  Function added:
 *      write_wtmp ();
 *  Functions changed:
 *      makeutent ();
 *      cleanutent ();
 *  all WTMP specific code if #ifdef'd WTMP_SUPPORT, which currently depends
 *  on UTMP_SUPPORT.
 * This code is valid and tested on linux (libc.so.4.6.27), but is
 * POSIX compliant and should work on SYSVR4, except possibly the use
 * of EAGAIN, which may be called EACCESS in SVR4. Linux has only EAGAIN,
 * POSIX allows either.
 *
 * My additions are tagged with an entry like "... pwp 95-12-07", where the
 * former are my initials and the latter the date in yy-mm-dd format.
 *----------------------------------------------------------------------*/
#include "rxvt.h"

/* There must be a more elegant way than this HUGE ifdef to do this */
#ifdef __alpha
# define SVR4
#endif
#ifdef SVR4_UTMPX	/* rgg */
# include <utmpx.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>		/*#define HAVE_SYS_TIME_H*/
#include <utmp.h>
#include <unistd.h>		/*#define HAVE_UNISTD_H*/
#ifdef BSD
# ifndef FREEBSD
#   include <lastlog.h>
# endif
# include <strings.h>
#endif
#include <pwd.h>

/* WTMP_SUPPORT added pwp 95-12-07 */
#ifdef UTMP_SUPPORT
# define WTMP_SUPPORT
# include <errno.h>
# include <fcntl.h>
# if !defined (EAGAIN) && defined (EACCESS)
#   define EAGAIN EACCESS
# endif
#endif

#ifndef UTMP_SUPPORT
/*
 * Dummy routines to use if utmp support is not wanted/needed
 */
void makeutent (char *ttyname) {}
void cleanutent (void) {}

#else	/* UTMP_SUPPORT */

/*----------------------------------------------------------------------*
 * extern variables referenced
 */
extern char *display_name;

/*----------------------------------------------------------------------*
 * extern variables declared here
 */
int utmp_inhibit = 0;

/*----------------------------------------------------------------------*
 * local variables
 */
static unsigned char utmp_made = 0;	/* marks if an entry has been made */
static int utmp_pos;		/* position of utmp-stamp */

/* This #ifdef and all in it added by pwp 95 12 07 */
#ifdef WTMP_SUPPORT
static char wtmpf[] = WTMP_FILE;
#endif  /* WTMP_SUPPORT */

/*----------------------------------------------------------------------*
 * Code to make utmp entries really starts here !
 */
/*
 * on Sparcs login/logouts are logged at /var/adm/wtmp
 * but talk(d)/finger only look at /etc/utmp
 */
#ifndef UTMP
# ifdef UTMP_FILE
#  define UTMP	UTMP_FILE
# else
#  define UTMP	"/etc/utmp"
# endif
#endif

#ifndef WTMP_FILE
# define WTMP_FILE	"/etc/wtmp"
#endif

#ifndef TTYTAB
# define TTYTAB	"/etc/ttytab"
#endif
#ifndef USER_PROCESS
# define USER_PROCESS 7
#endif

#ifndef DEAD_PROCESS
# define DEAD_PROCESS 8
#endif

/*
 * The code was pretty ugly when BSD and SYSV style utmp stuff was mixed,
 * so I just made a huge ifdef for BSD, and another for SYSV
 *
 * SVR4 is also divided on utmpx support (Solaris 2.x, define SVR4_UTMPX)
 * and normal SVR4 utmp support -- rgg 16/10/95
 */
#ifdef BSD
/*----------------------------------------------------------------------*
 * get_tslot() - grabbed from xvt-1.0 - modified by David Perry
 *
 * Look up the tty name in the /etc/ttytab file and return a slot number
 * that can be used to access the utmp file.  We cannot use ttyslot()
 * because the tty name is not that of fd 0.
 *----------------------------------------------------------------------*/
static int
get_tslot (char *ttyname)
{
   FILE *fd;
   char buf [256], name [256];
   int i;

   if ((fd = fopen (TTYTAB,"r")) != NULL)
     {
	for (i = 1; fgets (buf, sizeof(buf), fd) != NULL; i++)
	  {
	     if (*buf == '#' || sscanf (buf,"%s",name) != 1)
	       continue;
	     if (!strcmp (ttyname, name))
	       {
		  fclose (fd);
		  return i;
	       }
	  }
	fclose (fd);
     }
   return -1;
}

/*
 * write a utmp entry to the utmp file
 */
static void
write_utmp (char *ttyname, struct utmp * u)
{
   FILE *fd;

   if ((fd = fopen (UTMP,"r+")) == NULL)
     return;
   utmp_pos = get_tslot (ttyname) * sizeof(struct utmp);
   if (utmp_pos < 0)
     return;
   fseek (fd, utmp_pos, 0);
   fwrite (u, sizeof(struct utmp), 1, fd);
   fclose (fd);
   utmp_made = 1;
}

/*
 * Makes a utmp entry
 */
void
makeutent (char *ttyname)
{
   struct utmp u;
   struct timeval tp;
   struct timezone tzp;
   struct passwd *pwent;

   char *hostname = display_name;

   if (utmp_inhibit)
     return;

   pwent = getpwuid (getuid());
   memset (&u, 0, sizeof(u));

   /* get the host, the line, the time and the name: */
   strncpy (u.ut_host, hostname, sizeof(u.ut_host));
   strncpy (u.ut_line, ttyname, sizeof(u.ut_line));
   if (!gettimeofday (&tp, &tzp))
     u.ut_time = tp.tv_sec;
   strncpy (u.ut_name, pwent->pw_name, sizeof(u.ut_name));
   write_utmp (ttyname, &u);
}

/*
 * Removes a utmp entry
 *
 * there is a nice function "endutent" defined in <utmp.h>;
 * like "setutent" it takes no arguments, so I think it gets all information
 * from library-calls.
 * That's why "setutent" has to be called by the child-process with
 * file-descriptors 0/1 set to the pty. But that child execs to the
 * application-program and therefore can't clean it's own utmp-entry!(?)
 * The master on the other hand doesn't have the correct process-id
 * and io-channels... I'll do it by hand:
 * (what's the position of the utmp-entry, the child wrote? :-)
 */
void
cleanutent (void)
{
   FILE *fd;
   struct utmp u;

   if (!utmp_made)
     return;

   if ((fd = fopen (UTMP,"r+")) == NULL)
     return;
   fseek (fd, utmp_pos, 0);
   memset (&u, 0, sizeof(u));
   fwrite (&u, sizeof(struct utmp), 1, fd);
   fclose (fd);
}

/*----------------------------------------------------------------------*
 * Here's where we start SYSV style utmp entry code
 *----------------------------------------------------------------------*/
#else /* not BSD */

#ifdef SVR4_UTMPX	/* rgg */

#ifndef WTMPX_FILE
Error WTMPX_FILE must be defined on Solaris 2.x
#endif
/*
 * write a utmp entry to the utmp file
 */
static void
write_utmp (struct utmpx *ux)
{
  struct utmp u;

  utmpname (UTMP);
  getutmp (ux, &u);
  pututline (&u);
  pututxline (ux);
  updwtmpx (WTMPX_FILE, ux);
  endutent ();
  utmp_made = 1;
}

/*
 * Makes a utmp entry
 */
void
makeutent (char *ttyname)
{
   struct passwd *pwent;
   struct utmpx ux;
   int num;
   char *hostname = display_name;

   if (utmp_inhibit)
     return;

   pwent = getpwuid (getuid ());
   memset (&ux, 0, sizeof(ux));

   /* get the host: */
   strncpy (ux.ut_host, hostname, sizeof(ux.ut_host));
   ux.ut_syslen = strlen (ux.ut_host) + 1;

   /* and now the line: */
   if (sscanf (ttyname, "pts/%d", &num) != 1)
     {
	print_error ("can't parse tty name %s", ttyname);
	return;
     }
   sprintf (ux.ut_id, "vt%02x", num);
   sprintf (ux.ut_line, "pts/%d", num);

   time (&ux.ut_xtime);
   strncpy (ux.ut_user, pwent->pw_name, sizeof (ux.ut_user));
   ux.ut_type = USER_PROCESS;
   ux.ut_pid = getpid ();

   write_utmp (&ux);
}

/*
 * Removes a utmp entry
 */
void
cleanutent (void)
{
   struct utmp u;

   if (!utmp_made)
     return;

   utmpname (UTMP);
   setutent ();
   if (getutid (&u) == NULL)
     return;
   u.ut_type = DEAD_PROCESS;
   time (&u.ut_time);
   pututline (&u);
   updwtmp (WTMP_FILE, &u);
}
#else /* !SVR4_UTMPX */

/*
 * write a utmp entry to the utmp file
 */
static void
write_utmp (struct utmp * u)
{
   utmpname (UTMP);
   setutent ();
   pututline (u);
   endutent ();
   utmp_made = 1;
}

/*
 * write_wtmp added by pwp 95 12 07
 * called by makeutent() and cleanutent() below
 */
static void
write_wtmp (struct utmp * wtmp)
{
#ifdef WTMP_SUPPORT
   unsigned int retry = 10;	/* 10 retries when wtmp cannot be locked */
   int wtmp_handle;		/*  handle of open wtmp file */
   struct flock wtmp_lock;      /*  fcntl locking scheme for wtmpf  */

   if ((wtmp_handle = open(wtmpf, O_WRONLY|O_APPEND, 0)) > 0)  /* if ok */
     {
        /*  attempt to lock the wtmp file   */
        wtmp_lock.l_whence = SEEK_END;	/* start lock at current eof    */
        wtmp_lock.l_len    = 0;		/* end at ``largest possible eof'' */
        wtmp_lock.l_start  = 0;
        wtmp_lock.l_type   = F_WRLCK;	/* we want a write lock         */

        /* locking attempt with F_SETLK; retrying 10 tries
         * use of F_SETLKW would cause a deadlock! */
        while (retry--)
	  {
	     if (fcntl (wtmp_handle, F_SETLK, &wtmp_lock) < 0)	/* fail */
	       {
		  if (errno == EAGAIN)  /* if wtmp already locked */
                    continue;   /* try again, or give up after RETRY times */
		  else		/* another errno: give up   */
		    {
		       close (wtmp_handle);
		       return;
		    }
	       }
	  }

        /* ok, the lock was successfully set! we can write now */
        write (wtmp_handle, (void *)wtmp, sizeof(struct utmp));
        /* write errors are not checked */

        /* now prepare for unlocking */
        wtmp_lock.l_type = F_UNLCK;

        /* and do it. errors are not checked, as close will try again */
        fcntl (wtmp_handle, F_SETLK, &wtmp_lock);
        close (wtmp_handle);
    }
#endif	/* WTMP_SUPPORT */
}

/*
 * Makes a utmp entry
 */
void
makeutent (char *ttyname)
{
   struct passwd *pwent;
   struct utmp u;
   char *hostname = display_name;

   if (utmp_inhibit)
     return;

   pwent = getpwuid (getuid ());
   memset (&u, 0, sizeof(u));

   /* get the host */
   strncpy (u.ut_host, hostname, sizeof(u.ut_host));

   /* and now the line: */
   strcpy (u.ut_line, ttyname);	/* This works at the moment. I don't think */
				/* that ttyname is NULL terminated, so */
				/* something more elaborate may need to be */
				/* done. */

   time (&u.ut_time);
   strncpy (u.ut_user, pwent->pw_name, sizeof(u.ut_user));
   u.ut_type = USER_PROCESS;
   u.ut_pid = getpid ();
   strncpy (u.ut_id, (ttyname+3), 2);

   write_utmp (&u);
   write_wtmp (&u);	/* add same to wtmp: line opened -- pwp 95 12 07 */
}

/*
 * Removes a utmp entry
 *
 * there is a nice function "endutent" defined in <utmp.h>;
 * like "setutent" it takes no arguments, so I think it gets all information
 * from library-calls.
 * That's why "setutent" has to be called by the child-process with
 * file-descriptors 0/1 set to the pty. But that child execs to the
 * application-program and therefore can't clean it's own utmp-entry!(?)
 * The master on the other hand doesn't have the correct process-id
 * and io-channels... I'll do it by hand:
 * (what's the position of the utmp-entry, the child wrote? :-)
 */
void
cleanutent (void)
{
   int pid;
   struct utmp *u;

   if (!utmp_made)
     return;

   utmpname (UTMP);
   setutent ();
   pid = getpid ();
   /* The following 11 lines of code were copied from the
    * poeigl-1.20 login/init package. Special thanks to
    * poe for the code examples.
    */
   while ((u = getutent()))
     {
	if (u->ut_pid == pid)
	  {
	     time (&u->ut_time);
	     memset (&u->ut_user, 0, sizeof(u->ut_user));
	     memset (&u->ut_host, 0, sizeof(u->ut_host));
	     u->ut_type = DEAD_PROCESS;
	     u->ut_pid = 0;
#if !defined (SVR4) && !defined (AIXV3)
	     u->ut_addr = 0;
#endif
	     pututline (u);	/* Was reversed with in the original */
	     endutent ();
             /* write_wtmp () added by pwp 95 12 07 */
             write_wtmp (u);  /* add empty entry to wtmp: line has closed */
	  }
     }
}
#endif /* SVR4_UTMPX */
#endif /* BSD */

#endif /* UTMP_SUPPORT */
/*----------------------- end-of-file (C source) -----------------------*/
