#include "illum.h"
FILE *casiofile;
FILE *altfile;
char dbase_str[]   = "dbase-test";
char alt_str[]   = "dbase-alt";

/*
This is a simple example of how you could manipulate
a casio illuminator database file for the illuminator 
and extarct its information;

in this example the output file is hard-coded to the stdout and the
database file is hard-coded to dbase-test

You read from dbase-test and write to stdout;
you could then edit the data or whatever, recompute
the checksum and finaly write it to an alternate file
(hard-coded again to dbase-alt) for storage

These files are actually included in the package 
for testing

*/


main (int argc, char *argv[])
{
int i;
casiorec *temp1,*temp2;
data=stdout;
 if ((casiofile = fopen (dbase_str, "rb")) == (FILE *) 0)
  {
  fprintf (stderr, "Cannot open d-base file %s\n", dbase_str);
  exit(0);
  }

/* open that alternate file to send casio formated data to */
     if ((altfile = fopen (alt_str, "wb")) == (FILE *) 0)
        {
  fprintf (stderr, "Cannot open alternate file %s\n", alt_str);
  exit(0);
        }

/*
* 	initialise therecs
*/
 for (i=0;i<15;i++)
   {
   therecs[i]=NULL;
   }

/* 
populate therecs with casio records in the file
descriptor casiofile
*/
readcasdata(casiofile);


/*
*  write them to that data file
*/

 for (i=0;i<15;i++)
   {
	   if(therecs[i]!=NULL)
	   {

            for (temp1=therecs[i];temp1 !=NULL;temp1=temp1->next)
	    {
			/*
			*/
            fprintf (data, "\n>>>>>>type %s<<<<<<<\n", rectypes[temp1->type]);
/* invoke the displayer for this type */
			displayers[temp1->type](temp1);
                        printf("\n -------------------- \n");
/* You can edit the data here */
/* re-compute the checksum in case you have edited the 
   data */
			temp1->cksum=cas_cksum(temp1);
                        printf("\n -------------------- \n");
/* 
write the casio record data structures to a different file;
returns 1 if failed
exit if errors
*/
if ( write2file(altfile,temp1))
goto cleanup;

                        printf("\n -------------------- \n");
                        printf("\n -------------------- \n");
		    }
	   }
  }

/* cleanup --
close all files;
free all allocated mem
*/
/*
* 	initialise therecs
*/
cleanup:  printf("\n cleaning up ..\n");
for (i=0;i<15;i++)
   {
   if(therecs[i]!=NULL)
   {
    for (temp1=therecs[i];temp1 !=NULL;)
    {
    temp2=temp1->next;
    free(temp1);
    temp1=temp2;
    }

   }
   }
fclose(casiofile);
fclose(altfile);
fclose(data);

}
