#include "list.h"
#include "tool.h"
#include <stdio.h>
#include <string.h>

int main(int argc, char *argv[])
{
	char *listname,*temp,*temp2;
	FILE *f;
	char *config;
	unsigned char tmp=0;

	if(argc>2) {
		puts("Wrong number of parameters.");
		exit(1);
	} else if(argc==2) {
		listname=(char *) salloc(strlen(argv[1])+1);
		strcpy(listname,argv[1]);
	} else {
		listname=input("new list name:",255);
	}	
	config=(char *) salloc(strlen(LISTDIR)+1+strlen(listname)+7+1);
	sprintf(config,"%s/%s.config\0",LISTDIR,downcase(listname));
	f=fopen(config,"w");
	fprintf(f,"# %s list config file for %s\n",VERSION,listname);

	if(yn("allow new users to subscribe?"))
		fputs("newusers=yes\n",f);
	else
		fputs("newusers=no\n",f);

	puts("Who should be able to post messages to the list?");
	puts("1) Everyone");
	puts("2) Everyone who is subscribed to the list");
	puts("3) Only list operators");
	switch(choice("choice:","123")) {
		case 0:
			fputs("closed=no\n",f);
			break;
		case 1:
			fputs("closed=yes\n",f);
			break;
		case 2:
			fputs("closed=operators\n",f);
			break;
	}
	
	temp=input("e-mail address of list administrator:",255);
	fprintf(f,"contact=%s\n",temp);
	free(temp);
	
	puts("BeroList can send the messages from the list from different addresses:");
	puts("1) The original author if the message");
	puts("2) The list address");
	puts("3) any other address");
	switch(choice("choice:","123")) {
		case 0:
			fprintf(f,"sender=original\n");
			break;
		case 1:
			fprintf(f,"sender=list\n");
			break;
		case 2:
			temp=input("address:",255);
			fprintf(f,"sender=%s\n",temp);
			free(temp);
			break;
	}	

	puts("Set Reply-To field of all messages from the list from to:");
	puts("1) The original author if the message");
	puts("2) The list address");
	puts("3) any other address");
	puts("4) do not generate a Reply-To field");
	switch(choice("choice:","1234")) {
		case 0:
			fprintf(f,"replyto=original\n");
			break;
		case 1:
			fprintf(f,"replyto=list\n");
			break;
		case 2:
			temp=input("address:",255);
			fprintf(f,"replyto=%s\n",temp);
			free(temp);
			break;
	}

	puts("In which way should the list handle MAILER-DAEMON error messages?");
	puts("1) Automatically unsubscribe faulty addresses");
	puts("2) Forward to an administrator");
	puts("3) Both");
	switch(choice("choice:","123")) {
		case 0:
			fprintf(f,"errors=unsubscribe\n");
			break;
		case 2:
			fprintf(f,"errors=forward\n");
			tmp=1;
		case 3:
			if(tmp!=1) fprintf(f,"errors=both\n");
			temp=input("Redirect MAILER-DAEMON messages to (e-mail):",255);
			fprintf(f,"errors-to=%s\n",temp);
			free(temp);
	}
	
	if(yn("Do you want to limit the size of messages for the list?")) {
		temp=input("Maximum size (in bytes)",10);
		temp2=input("Filename of error message sent to people trying to send bigger messages:",255);
		fprintf(f,"limit=%s,%s\n",temp,temp2);
		free(temp);
		free(temp2);
	}

	puts("Do you want to prefix a message (i.e. list name) to the subject of every");
	puts("message? (For example, a message with the subject ""123"" on test-list");
	if(yn("could be delievered to the subscribers with the subject ""[TEST] 123""")) {
		temp=input("Prefix: ",100);
		fprintf(f,"prefix=%s\n",temp);
		free(temp);
	}
	
	#ifdef LOG
		if(yn("Do you want to keep a log file for this list?")) {
			temp=input("Filename:",255);
			fprintf(f,"log=%s\n",temp);
			free(temp);
		}
	#endif
	
	#if defined(ARCHIVE) && defined(HAS_GDBM)
		if(yn("Do you want to keep an archive of list messages?")) {
			temp=input("Filename:",255);
			fprintf(f,"archive=%s\n",temp);
			free(temp);
		} else
			fprintf(f,"archive=none\n");
	#endif
	
	#ifdef HAS_NNTP
		if(yn("Do you want to use the news/nntp gateway?")) {
			temp=input("Newsgroup:",255);
			fprintf(f,"newsgroup=%s\n",temp);
			free(temp);
			temp=input("News/NNTP server:",255);
			fprintf(f,"nntp-server=%s\n",temp);
			free(temp);
			if(choice("Distribution (world/local)","wl")==0)
				fprintf(f,"distribution=world\n");
			else
				fprintf(f,"distribution=local\n");
		}
	#endif
	#ifndef NO_WWW
		if(yn("Do you want to use the WWW gateway for this list?")) {
			puts("Should users be allowed to subscribe to the list using WWW?");
			puts("The problem with this is that there's no way to make sure the user is");
			puts("supplying his/her own e-mail address, so theoretically, everyone can");
			puts("subscribe anyone else.");
			puts("An alternative is to replace CGI subscription with a mailto: command - ");
			puts("which might be confusing to beginners.");
			puts("");
			puts("1) Permit CGI-based subscription");
			puts("2) Use mailto: tag instead");
			puts("3) Don't permit WWW based subscription at all");
			puts("");
			switch(choice("choice:","123")) {
				case 1:
					fprintf(f,"www-subscribe=cgi\n");
					break;
				case 2:
					fprintf(f,"www-subscribe=mailto\n");
					break;
				case 3:
					fprintf(f,"www-subscribe=no\n");
					break;
			}
			puts("Should users be allowed to unsubscribe from the list using WWW?");
			puts("1) Permit CGI-based unsubscription");
			puts("2) Use mailto:");
			puts("3) Don't permit WWW based unsubscription");
			puts("");
			switch(choice("choice:","123")) {
				case 1:
					fprintf(f,"www-unsubscribe=cgi\n");
					break;
				case 2:
					fprintf(f,"www-unsubscribe=mailto\n");
					break;
				case 3:
					fprintf(f,"www-unsubscribe=no\n");
					break;
			}
		}
		if(yn("Do you wish to enable WWW-based list administration?")) {
			temp=input("Which password do you want to use?",255);
			free(temp);
			fprintf(f,"www-password=%s\n",temp);
		}
	#endif
	fclose(f);
	puts("");
	puts("The list config file has been set up.");
	if(geteuid()!=0) {
		puts("Since you aren't root, you cannot assign the list address.");
		printf("You will also need to chown bin.bin %s manually.\n",config);
		exit(1);
	} else {
		chown(config,1,1);
	}
	puts("BeroList can attempt to assign the list address automatically.");
	puts("Generally, this will work if your mailer uses /etc/aliases.");
	puts("It definately works with sendmail 8.8.x.");
	puts("If you chose not to let BeroList assign the address, you'll have");
	puts("to do it manually. Check the README file on how to do this.");
	if(yn("Try to assign address?")) {
		if(!exist("/etc/aliases")) {
			puts("There is no file /etc/aliases present on your system!");
			if(!yn("Are you sure your mailer can handle it?"))
				exit(1);
		}
		f=fopen("/etc/aliases","a");
		fprintf(f,"%s:\"|%s/list %s\"\n",downcase(listname),BINDIR,downcase(listname));
		fclose(f);
		system("newaliases");
	}
	puts("");
	printf("The list %s is now set up.\n",listname);
	puts("If your mailer is running as a user different from 1.1 (see README");
	puts("and PROBLEMS), you will need to change owner/group owner of the");
	printf("configuration file, %s.\n",config);
	puts("");
	puts("If you wish, go ahead and create .welcome, .footer, .members");
	puts("and .operators files for your new list.");
}
