#! /usr/bin/perl
###############################################################################
#
# $Id: Util.pl,v 1.1 1997/12/06 00:18:29 bcwhite Exp $
#
# Util.pm
#
# Written by: Behan Webster <behanw@pobox.com>
#


###########################################################################
# uniq a list
#
sub uniq {
	grep {!/^\s*$/} sort { if(lc($a) eq lc($b)){$b="";} $a gt $b } @_;
}


###########################################################################
# Slurp in a file
#
sub slurp {
	my ($buffer, @files) = @_;

	my $eol = $/; undef $/;			# delete the EOL character

	#
	# Slurp in file
	#
	$$buffer = "";
	push( @files, "-" ) if !@files;	# Read STDIN
	foreach (@files) {
		if(/^-?$/) {				# Open STDIN if file is "-"
			open(FILE, "<&STDIN");
		} else {
			open(FILE, "<$_") || die "$_: $!\n";
		}
		$$buffer .= <FILE>;			# slurp in the file
	}

	$/ = $eol;						# restore the EOL character
}

1;
