/*
 *
 * $Id: pattern-client.c,v 1.4 1998/02/09 23:57:20 bcwhite Exp $
 *
 * Pass command line and stdin to the pattern server.
 *
 */


#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/sem.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>


#define	SERVER_SOCKET_DIR	"/tmp/."
#define	SERVER_SOCKET_EXT	"-spamfilter"
#define SERVER_START_EXEC	"pattern-server"
#define	SERVER_BINARY_DIR	"/usr/lib/spamfilter/bin"

#define NEXTMSG	"\nFrom dummy@not.real.mail\n\nFrom ===done===\n"
#define TIMEOUT	10
#define	SEMKEY	0xD0E0F3C6


char*	Argv0;
int		SemId = -1;


void lock_server_create(void)
{
	union	semun	un;
	struct	sembuf	buf;

	if (SemId != -1) {
		SemId = semget(SEMKEY,1,0777);
	}

	if (SemId == -1) {
		SemId = semget(SEMKEY,1,0777|IPC_CREAT);
		un.val = 1;
		semctl(SemId,0,SETVAL,un);
	}

	if (SemId == -1) {
		return;
	}

	buf.sem_num = 0;
	buf.sem_op	=-1;
	buf.sem_flg = 0;
	semop(SemId,&buf,1);
}


void unlock_server_create(void)
{
	struct	sembuf	buf;

    if (SemId == -1) return;

	buf.sem_num = 0;
	buf.sem_op	= 1;
	buf.sem_flg = 0;
	semop(SemId,&buf,1);
}



int connect_to_server(void)
{
	int const			maxpathlength=128;
	struct sockaddr_un	saddr;
	struct sockaddr_un	daddr;
	char				path[maxpathlength];
	int					sock;
	int					retcode;
	int					pid;

	strcpy(path,SERVER_SOCKET_DIR);
	strcat(path,getenv("LOGNAME"));
	strcat(path,SERVER_SOCKET_EXT);

	sock = socket(PF_UNIX,SOCK_STREAM,0);
	if (sock == -1) {
		perror("Error: could not create unix socket");
		return -1;
	}

#if 0
	bzero(&saddr,sizeof(saddr));
	saddr.sun_family=AF_UNIX;
	retcode = bind(sock,(struct sockaddr*)&saddr,sizeof(saddr));
	if (retcode == -1) {
		perror("Error: could not bind to unix socket");
		return -1;
	}
#endif

	bzero(&daddr,sizeof(daddr));
	daddr.sun_family=AF_UNIX;
	strncpy(daddr.sun_path,path,sizeof(daddr.sun_path)-1);
	retcode = connect(sock,(struct sockaddr*)&daddr,sizeof(daddr));
	if (retcode == -1) {
		lock_server_create();
		retcode = connect(sock,(struct sockaddr*)&daddr,sizeof(daddr));
	}
	if (retcode == -1) {
		unlink(path);

		pid = vfork();
		if (pid == 0) {
			char* argv[3] = {SERVER_START_EXEC,path,NULL};
			char  fullpath[256];

			execv(SERVER_START_EXEC,argv);

			strcpy(fullpath,SERVER_BINARY_DIR);
			strcat(fullpath,"/");
			strcat(fullpath,SERVER_START_EXEC);
			execv(fullpath,argv);

			exit(errno);
		} else if (pid > 0) {
			int try,status;

			fprintf(stderr,"%s: Starting server process (pid %d)...\n",Argv0,pid);

			for (try=0; try < 10; try++) {
				sleep(1);
				retcode = connect(sock,(struct sockaddr*)&daddr,sizeof(daddr));
				if (retcode == 0) {
					break;
				}
				if (waitpid(pid,&status,WNOHANG) == pid) {
					if (WIFEXITED(status)) {
						errno = WEXITSTATUS(status);
					}
					break;
				}
			}
		}

		if (retcode == -1) {
			perror("Error: could not start server process");
			return -1;
		}
	}

	return sock;
}


int main(int argc, char* argv[])
{
	int const	maxlinelength=65535;
	char		line[maxlinelength];
	int			length;
	int			sock;
	int			i;

	Argv0 = argv[0];

	alarm(TIMEOUT);

	strcpy(line,argv[0]);
	for (i=1; i < argc; i++) {
		strcat(line," ");
		strcat(line,argv[i]);
	}
	strcat(line,"\n");

	sock = connect_to_server();
	unlock_server_create();
	if (sock == -1) {
		exit(errno);
	}

	write(sock,line,strlen(line));
	while ((length=read(0,&line,maxlinelength)) != 0) {
		write(sock,line,length);
	}

	write(sock,NEXTMSG,strlen(NEXTMSG));
	length = read(sock,&line,20);
	close(sock);

	alarm(0);
	exit(line[0]-'0');
}
