.TH ifhp 8 "_VERSION_"
.SH NAME
ifhp \- HP LaserJet (Printer Job Language) filters
.SH SYNOPSIS
.B ifhp
.br
[-F format] [-?value (other LPRng filter options)]
.br
[-Z[duplex][landscape][simplex][upper][lower][manual][top][back]]
.br
[-T[options[,options]*]*
.br
[file]
.br
.sp
.BR ofhp "(symbolic link to ifhp)"
.SH DESCRIPTION
.LP
The
.B ifhp
is a general purpose filter for 
.B HP LaserJet III, IV, and V
series printers.
It was originally developed during phase II of the
.B CTI-Print 
project at the 
.B Division of Computing Facilities 
of the 
.B Computer Technology Institute (CTI), Patras, Greece,
and has been adapated for use with the PLP and LPRng
spooling software by Patrick Powell <papowell@sdsu.edu>.
The main objective of the project 
was to develop a mechanism to serve multiple formats
(
.B ascii, PCL 
and 
.BR PostScript )
and to support downloading of fonts (in the case of 
.B ascii 
jobs) depending on the 
source of the request (i.e. in order to print jobs containing Greek characters 
such as the 
.B ISO 8859/7, DEC Greek 
etc).
.LP
.B ifhp
can be used as either an IF or OF print spooler filter;
the
.BR -F o 
option or 
.B ofhp
executable name selects the 
.B OF
operation.
When used as an IF filter,
.B ifhp 
synchronizes with the printer,
checks the file to determine if it is PostScript or text (PCL),
sets the appropriate printer mode,
and then sends the file to be printed.
If the file is not PostScript,
the filter tries to locate a default font to download
by scanning the
.B host_fonts
file.
This file contains lines listing the requesting host,
the font file subdirectory,
and the default font name for the requesting host.
For example,
the host fonts file line
.sp .5v
.DS
hermes.cti.gr       elot-928    c1201c.10
.DE
.sp .5v
would indicate that host
.I hermes.cti.gr
uses font
.I elot-928/c1201c.10
in the font directory.
.LP
Options controlling
.B ifhp
operations are specified by
.BR -T option
values or environment varialbles with the capitalized option name.
The following options are available.
The default value is indicated with an *.
.sp .5v
.TP
.BR accounting	=accounting_script_pathname
.br
Invoke the accounting script with a subset of the options passed to the
filter.
In addition,
the
.RI -b pagecount
option indicates the number of pages printed for the job.
.TP
.BR autodetect	=[on|off*]
.br
The printer has or does not have job type autodetect capability.
Do not download fonts or try to determine job type if autodetect is on.
.TP
.BR banner =[on|off*]
If banner is on,
then the 
.B ifhp
filter will attempt to print a banner using information
passed on the command line or on the standard input.
The
.B title
option can be used to specify additional title information on the banner.
See
.I "BANNERS"
below for details.
.TP
.BR cartridge  =[*on|off]
.br
(Alias for postscript)
.br
If cartridge is on, the printer has PostScript support.
The filter will try to determine if a job is postscript
and send Printer Job Language commands to put the printer in PostScript mode.
.TP
.BR debug  =debuglevel
Sets the debugging level; 2 is the default;
a larger number causes more verbose error messages.
.TP
.BR defaultfont  =fontname
Sets the default font to be downloaded; default is NONE.
.TP
.BR dev  =/device
.TP
.BR dev  =host%port
.br
.BR dev  =host%port+orig_port
.br
Open the specified device or connection to remote host;
by default
.B ifhp
filter uses file descriptor 1 (stdout).
If the optional orig_port is specified,
connections will be originated from this port.
Some printers require that connections originate from a port in
the range 1-1024.
.TP
.BR infostatus  =[*on|off]
The PJL INFOSTATUS request is not supported on some
HP printers.
Use this to turn the status request off.
Note that you cannot get real time
reports of the printer status if you do this.
This will also suppress getting pagecount information
using the PJL facilities.
.TP
.BR forcepagecount  =[on|off*]
If you have a printer that has PostScript page count
information support,
you can set infostatus to OFF and forcepagecount to ON.
This will cause the PostScript facility to be used.
If you set cartridge or postscript to OFF then this will not
be done.
.TP
.BR logall
Save all of the error and information messages from the printer
in the log file.
This is useful when you wish to examine returned status from the printer.
.TP
.BR model =(C5M|III|IIID|IIISi|IV*)
The model of HP printer.
C5M is Color 5M, III is HP LaserJet 3,
IIID is HP LaserJet 3D, etc.
Additional printers may be added or defined
at various times - please consult the source for details.
This selects various timing and format characteristics.
This is a desperation parameter for users with antique or
non-conforming PJL based equipment;
read the source code for details on the particular peculiarities.
.TP
.BR pagecount  =[on*|off]
Get the hardware pagecounter value for accounting.
Some printers such as the HP LJ4s do not have hardware support
for pagecounters,
and return bogus numbers.
Use this to suppress attempting to get valid information.
If your printer does support PostScript,
then you can get the page count value using PostScript by
setting forcepagecount to ON.
.TP
.BR plp  =[on|off*]
Return PLP status values on exit;
by default LPRng status values are returned.
.TP
.BR postscript  =[on*|off]
The printer has postscript support.
.TP
.BR quiet =[on|off*]
If set, do not report common status messages.
.TP
.BR retries =count
The number of times to retry connecting to the printer.
.TP
.BR sleep =time
The number of seconds to wait before trying to connect to the printer.
.TP
.BR status  =[*on|off]
When on,
the printer is
treated as a write only device
and is not queried for pagecount and status information.
Set status=OFF for parallel printers.
If status is OFF,
then the
.B ifhp
filter simply adds job control language headers,
fonts,
and trailers to the jobs.
.TP
.BR stty "=stty flags"
if the output device is a serial line,
set the line characters according to the stty flags.
These flags are (most likely) identical to those available
with the stty(1) command on the host system.
.TP
.BR summary "=[filename|host%port]"
This option specifies that summary or informational messages should
be placed in the specified file or sent,
using the UDP protocol,
to the indicated host and port address.
This allows remote monitoring of the printing and error activity.
The undocumented
.i monitor
program included with the filter distribution is a simple program
that can be used to perform the monitoring.
.TP
.BR sync  =[*on|off]
Try to synchronize communications with printer.
This will ensure that the printer has been reset,
and no problems involving the previous job will result.
.TP
.BR title =line[/line]*
The title information is printed on the banner page;
it consists of a list of / separated lines which are added to the
banner information.
.TP
.BR wrap  =[on|off*]
which enables or disables
line wrapping in PCL mode.
.LP
The
.B ifhp
filter exits with a
0 status when the job is done successfully,
and a non-zero status otherwise.
.LP
.B PJL 
(Printer Job Language) is
fully utilised for controlling printer operations.
The comments in Chapter 9, 
Programming Tips for Using PJL,
of the 
.B Printer Job Language Technical Reference Manual
(HP 5961-0603, First Edition - July 1993) have been taken into account;
in addition the filter has been used
in educational environments
where malformed print jobs are normal.
The printer will try to report its status every 
.B sleep=time 
seconds.
The filter will print an error message if any other errors occur.
All problems are reported in the spooler error log file.
.LP
When the print job has been completely transferred
the
.B ifhp 
filter takes extremely aggressive action to force the printer
to terminate printing.
The accounting procedures used by the
.B ifhp
filter were developed in an educational environment where
attempts by users to avoid accounting procedures is common.
At the start of a job
.B ifhp
obtains the value of the pagecounter value from the printer;
this value along with user and job identification is written
to the accounting file.
Similarly,
at the end of the job the page counter value is obtained and
also written to the accouting file.
The accounting procedures will make use of these page counter values
to calculate the actual number of pages printed.
.SH "STATUS, PAGECOUNT, AND POSTSCRIPT"
.PP
Over the years,  printers have evolved and provided more
functionality.
In addition,
they are now usually connected using network interfaces.
This has led to a series of compatibility problems with
status and accounting gathering.
.PP
If your printer is attached by a parallel port,
unless you have a bidirectional interface AND the
data can be read using a simple read() system call,
then you will be unable to get printer status.
If this is the case,
use the -Tstatus=off option to totally suppress status
gathering.
.pp
If your printer is attached to a bidirectional interface,
you now have to determine how compatible your printer is
with the PJL/PCL standards.
Here is a brief summary of the options that should work
with each printer.
Note that you can try using the
infostatus=on option,
but if it fails then you should turn it off.
.nf
.ta 12n +12n
Printer	PostScript	Options
HPII	NO	-Tstatus=off
HPII	YES	-Tsycn=off,infostatus=off,forcepagecount=on
HPIII	NO	-Tinfostatus=off,forcepagecount=on
HPIIIsi	NO	-Tsycn=off,infostatus=off,forcepagecount=on
HPIVsi	NO	-Tinfostatus=off
HPIV*,HPV*	(defaults should work)
.SH "Z OPTIONS"
The PLP and LPRng software 
.B lpr
programs pass the -Z option to the filter.
These are recognized when printing a PCL or text file.
For example if duplex printing and a font needs to be downloaded,
this can be requested with the -Z option as:
.sp .5v
.B 	lpr -P<printer> -Z'duplex font=/absolutepath' <file> 
.sp .5v
The
.B ifhp
filter recognizes the following -Z options,
which prefixes the print job with the following strings.
.br
.nf
Postscript
.sp .5v
landscape	"@PJL SET ORIENTATION = LANDSCAPE"
duplex	"statusdict begin true setduplexmode false settumble end\er\en"
lduplex	"statusdict begin true setduplexmode false settumble end\er\en"
sduplex	"statusdict begin true setduplexmode true settumble end\er\en"
simplex	"statusdict begin false setduplexmode end\er\en"
upper	"statusdict begin 0 setpapertray end\er\en"
lower	"statusdict begin 1 setpapertray end\er\en"
manual	"statusdict begin /manualfeed true store end\er\en"
envelop	"statusdict begin com10envelopetray end\er\en"
top		"statusdict begin 0 setoutputtray end\er\en"
back	"statusdict begin 1 setoutputtray end\er\en"

PCL
.sp .5v
landscape	"@PJL SET ORIENTATION = LANDSCAPE"
duplex	"\e033&l1S"
lduplex	"\e033&l1S"
sduplex	"\e033&l2S"
simplex	"\e033&l0S"
upper	"\e033&l1H"
lower	"\e033&l4H"
manual	"\e033&l2H"
envelop	"\e033&l1S\e033&l1O\e033&l81A"
top		"\e033&l1G"
back		"\e033&l2G"
.sp
.fi
Landscape selects landscape mode,
while
duplex, lduplex, sduplex, and simplex cause duplex or simplex printing.
The upper and lower select upper and lower tray respectively;
manual selects manual feed.
The top and back select the output tray.
.TP
.B font=fontname
Download font to the printer.
Note that the default font is NONE.
.SH "OPTIONS"
The
.B ifhp
printer recognizes the following options provided by the spooler.
.TP
.BR -w width
page width (page setup- 80 or 132) 
.TP
.BR -l length
.b
page length in lines (page setup - 60 or 66)
.TP
.B -c
literal (binary).
Suppresses just about all filter actions except job start,
end,
and accounting.
.TP
.BR -Z options
Filter options
.TP
.BR -C class
job class (banner)
.TP
.BR -J 	jobname
job name (banner)
.TP
.BR -R accoutname
account for billing purposes (accounting)
.TP
.BR -n user
user name (banner, accounting)
.TP
.BR -h host
host name (banner, accounting)
.TP
.BR -F format
filter format;
format 'o' selects OF action.
.TP
.B accountingfile
accounting information is written to this file.
.SH BANNERS
The
.B ifhp
filter can also be used as an OF printer.
If invoked with the name
.B ofhp
or with the
.B -Fo
option,
it will assume that it is being used as an OF filter
and scan the input for a special stop sequence (see the Printer Spooler
documentation for details).
When it encounters the sequence it will suspend itself;
the spooler will restart the filter when it has more output for it. 
.LP
When running in OF mode,
the
.B ifhp
filter can also print banners.
This is enabled by the
.BR -Tbanner =headerlines
option.
The headerlines,
together with host,
user,
and job information are formatted sent to the printer as a PCL job.
In addition,
the filter will scan for non-whitespace input lines and parse them as well.
These input lines should have the format:
.sp
host: hostname user: username  job: job information class: class
.sp
.LP
.SH FILES
.PD 0
.TP
.B _INSTDIR_/ifhp
.TP
.B _INSTDIR_/accounting.sh
.br
Executables.
.TP
.B _FONTDIR_/host_fonts
Machines - fonts mapping.
.TP
.B _FONTDIR_/dec-greek/cp12.fnt
.br
.TP
.B _FONTDIR_/elot-928/c1201c.10
.br
.TP
.B _FONTDIR_/cp-437/c1201c.10
Fonts to be downloaded on request.
.br
.SH "SEE ALSO"
.BR lpd (8),
.BR lpq (1),
.BR lpr (1),
.BR lprm (1),
.BR hosts (5),
.BR printcap (5),
.BR lpc (8).
.LP
.nf
FTP sites:
  ftp://iona.ie/pub/LPRng
  ftp://dickory.sdsu.edu/pub/LPRng
.SH "BUGS"
.LP
It is possible,
by suitable abuse of the Job Control Language,
Printer Control Language,
or PostScript,
to hang up the printer so that it will not respond and the
.B ifhp
filter must be restarted.
This technique is usually used by users trying to avoid page accounting.
However,
the accounting file contains the page counter value;
this can be used to deduce the number of pages actually used in such cases.
.LP
The
.B ifhp
does not share network printers well.
You should not enable resourcesharing if you are using a network printer.
.SH "AUTHORS"
.nf
.in +.5i
.ti -.5i
Original Author:
Panos Dimakopoulos, Systems Programmer,
Computer Technology Institute (CTI),
Division of Computing Facilities,
P.O. Box 1122,
261 10  Patras, 
Greece
(e-mail: dimakop@cti.gr)
Tel: +30 61 992061
Fax: +30 61 993973
.sp
.ti -.5i
Modified by:
Prof. Patrick Powell,
Dept. Electrical and Computer Engineering,
San Diego State University,
San Diego CA 92182
<papowell@sdsu.edu>
