/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: cleanup.c,v 2.1 1997/01/05 18:41:37 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

static int exitval;

void cleanup(sig)
int sig;
{
	log(4,"Signal %s received-entering cleanup", Sigstr(sig) );

	if( monitpid > 0 ) {
        log(3,"Father murders %d", monitpid);
        kill(monitpid,SIGTERM);
        kill(monitpid,SIGCONT);
	}
	if( exitval ){
		fexit(exitval);
	} else if( getpid() != filterpid ){
		/* we are the child */
		exit(0);
    }
	exitval = FILTRETRY;
	log(3,"Job Interrupted");
	header_info();
	exit(exitval);
}
