/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: readpipe.c,v 2.3 1997/01/21 04:07:12 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

#define UNSOL(msg,X) (!strncmp(msg,X,strlen(X)))
char CODE[]  = "CODE=";
char PAGECOUNT[]  = "PAGECOUNT";

/* set if pagecount found on previous line */
static int pagecount_found;

/*
	readpipe will read a line of input,
	and then decode it for status and other information
	int readpipe(int *inptr, int timeout)
		inptr - pointer to location for status value
		timeout - time for the read
	returns:
	  n	> 0  number of characters read
	  n = 0  timeout on input
	  n < 0  EOF on input
*/

int readpipe(int *inptr, int timeout)
{
	int   n, cd;
	char *s, *start, *end;
	if( inptr ) *inptr = -1;

	cd = 0;
	if ( (n=port_readline(STDOUT,readprin,sizeof(readprin)-1,timeout)) <0 ) {
		logerr(2,"Could not read from STDOUT");
		return( n );
	}
	readprin[n] = 0;
	log(3,"readpipe: read %d, '%s'", n, readprin);

	for( start = readprin; start && *start; start = end ){
		end = strpbrk( start, "\n\r\004" );
		if( end ){
			*end++ = 0;
		}
		while( isspace(*start) ) ++start;
		if( *start == 0 ) continue;
		log(3,"readpipe: checking '%s'", start);
		if( pagecount_found ){
			log(3,"readpipe: pagecount_found %d", pagecount_found );
			pagecount_found = 0;
			npages = get_num( start );
			log(3,"readpipe: npages now %d", npages );
		}
		for( s = start; (s = getcrstr(s, CODE, sizeof(CODE)-1 ));
			s += sizeof(CODE) ) {
			cd = get_num( s );
			if( inptr ){
				*inptr = cd;
			}
			check_code( cd );
		}
		for( s = start; (s = getcrstr(s, PAGECOUNT, sizeof(PAGECOUNT)-1 ));
			s += sizeof(PAGECOUNT) ) {
			pagecount_found = 0;
			/* get_num skips only white spaces to next number */
			npages = get_num( s );
			log(4,"Pagecounter = %d", npages);
			/* if at the end of input, find it on the next line */
			if( npages < 0 ){
				pagecount_found = 1;
			}
		}
		if( getcrstr( start, job_start, strlen( job_start )-2) ) {
			job_started	= TRUE;
			log(3,"readpipe: job started");
		} else if( getcrstr( start, job_end, strlen( job_end )-2) ) {
			log(3,"readpipe: job ended");
			job_ended	= TRUE;
		}
		if( strstr( start, "Error:" ) || logall ){
			log(1,"STATUS: %s", start );
		}
	}
	return n;
}

static char statuscolon[] = "status:";
/* static char busy[] = "busy"; */
static char waiting[] = "waiting";
static char pridle[] = "idle";

int readpspipe(int *inptr, int timeout)
{
	int   n, cd;
	char *s, *start, *end;
	if( inptr ) *inptr = 0;

	cd = 0;
	if ( (n=port_readline(STDOUT,readprin,sizeof(readprin)-1,timeout)) <0 ) {
		logerr(2,"Could not read from STDOUT");
		return( n );
	} else if( n > 0 ){
		log(3,"readpspipe: read %d, '%s'", n, readprin);
		for( start = readprin; (cd = *start) && isspace( cd ); ++start );
	}
	if ( n == 0 || cd == 0 ) return n;

	n = 0;
	for( start = readprin; n == 0 && start && *start; start = end ){
		end = strpbrk( start, "\n\r\004" );
		if( end ){
			*end++ = 0;
		}
		s = strstr( start, statuscolon );
		if( s ){
			log(3,"readpspipe: checking '%s'", s);
			s += sizeof( statuscolon ) - 1;
			while( isspace( *s ) ) ++s;
			log(3,"readpspipe: status '%s'", s);
			if( strncmp( s, waiting, sizeof(waiting)-1 ) == 0 ){
				n = 1;
			} else if( strncmp( s, pridle, sizeof(pridle)-1 ) == 0 ){
				n = 1;
			}
		}
	}
	if( inptr ) *inptr = n;
	return 0;
}
