/**************************************************************************** 
** File: in_cksum.c
**
** Author: Mike Borella
**
** Comments: Lifted from ping.c
**
*****************************************************************************/

#include <stdio.h> 
#include <sys/types.h> 
#include <unistd.h>
#include "config.h"

/*----------------------------------------------------------------------------
**
** in_cksum.c()
**
** Do IP checksum
**
**----------------------------------------------------------------------------
*/

u_int16_t in_cksum(u_int16_t *addr, int len) 
{ 
  int nleft = len; 
  u_int16_t *w = addr; 
  u_int32_t sum = 0; 
  u_int16_t answer = 0; 
     
  /* 
   * Our algorithm is simple, using a 32 bit accumulator (sum), we add 
   * sequential 16 bit words to it, and at the end, fold back all the 
   * carry bits from the top 16 bits into the lower 16 bits. 
   */ 
  while (nleft > 1)  
    { 
      sum += *w++; 
      nleft -= 2; 
    } 
     
  /* 
   * mop up an odd byte, if necessary 
   */ 
   
  if (nleft == 1) 
    { 
      *(u_int8_t *)(&answer) = *(u_int8_t *)w ; 
      sum += answer; 
    } 
     
    /* 
     * add back carry outs from top 16 bits to low 16 bits 
     */ 
   
  sum = (sum >> 16) + (sum & 0xffff); /* add hi 16 to low 16 */ 
  sum += (sum >> 16);         /* add carry */ 
  answer = ~sum;              /* truncate to 16 bits */ 
  return(answer); 
} 


