#ifndef AFPD_CONFIG_H
#define AFPD_CONFIG_H 1

#include <sys/cdefs.h>
#include <atalk/server_child.h>
#include "globals.h"

typedef struct AFPConfig {
  AFPObj obj;
  int fd;
 /* the following greatly exceeds the max number of transports
  * possible given the bitfield declared in afp_options */
  unsigned char *optcount;
  void *status;
  const void *defoptions;
  int (*server_start) __P((const struct AFPConfig *, struct AFPConfig *,
			   server_child *));
  void (*server_cleanup) __P((const struct AFPConfig *));
  struct AFPConfig *next;
} AFPConfig;

AFPConfig *configinit __P((struct afp_options *));
void configfree __P((AFPConfig *, const AFPConfig *));
#endif
