/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * All rights reserved. See COPYRIGHT.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <atalk/dsi.h>
#include "dsi_private.h"

DSI *dsi_init(const dsi_proto protocol, const char *program, 
	      const char *hostname, const char *address,
	      const int port)
{
    DSI		*dsi;

    if ((dsi = (DSI *) calloc(1, sizeof(DSI))) == NULL) {
      return( NULL );
    }
    dsi->attn_quantum = DSI_DEFQUANT; /* default quantum size */
    dsi->program = program;

    /* signals to block and ignore. we actually only ignore signals
     * when a "known" large transfer is going to happen (i.e.,
     * dsi_read/write are invoked) . */
    sigemptyset(&dsi->signals.block);
    sigaddset(&dsi->signals.block, SIGTERM);
    sigaddset(&dsi->signals.block, SIGHUP);
    sigaddset(&dsi->signals.block, SIGALRM);
    dsi->signals.ignore = SIGALRM;
    dsi->signals.act.sa_handler = SIG_IGN;
    
    switch (protocol) {
      /* currently the only transport protocol that exists for dsi */
    case DSI_TCPIP: 
      if (!dsi_tcp_init(dsi, hostname, address, port)) {
	free(dsi);
	dsi = NULL;
      }
      break;

    default: /* unknown protocol */
      free(dsi);
      dsi = NULL;
      break;
    }

    return dsi;
}

void dsi_setstatus(DSI *dsi, u_int8_t *status, size_t slen)
{
    dsi->status = status;
    dsi->statuslen = slen;
}
