/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * All rights reserved. See COPYRIGHT.
 *
 * 7 Oct 1997 added checks for 0 data.
 */

/* this streams writes */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

#include <atalk/dsi.h>
#include <netatalk/endian.h>

#ifndef min
#define min(a,b)     ((a) < (b) ? (a) : (b))
#endif

/* initialize relevant things for dsi_write. this returns the amount
 * of data in the data buffer. the interface has been reworked to allow
 * for arbitrary buffers. */
size_t dsi_writeinit(DSI *dsi, void *buf, const size_t buflen)
{
  size_t len, header;

  /* figure out how much data we have. do a couple checks for 0 
   * data */
  header = ntohl(dsi->header.dsi_code);
  dsi->datasize = header ? ntohl(dsi->header.dsi_len) - header : 0;
  if (dsi->datasize > 0) {
    len = min(sizeof(dsi->commands) - header, dsi->datasize);
    
    /* write last part of command buffer into buf */
    memcpy(buf, dsi->commands + header, len);
    
    /* recalculate remaining data */
    dsi->datasize -= len;
  } else
    len = 0;

  /* ignore an inappropriate signal. i'm doing it this way to ensure
   * that we don't get confused if a writeflush on zero remaining data is,
   * for some reason, needed. */
  sigaction(dsi->signals.ignore, &dsi->signals.act, &dsi->signals.save);
  return len;
}

/* fill up buf and then return. this should be called repeatedly
 * until all the data has been read. i block alarm processing 
 * during the transer to avoid sending unnecessary tickles. */
size_t dsi_write(DSI *dsi, void *buf, const size_t buflen)
{
  size_t length;

  if ((length = min(buflen, dsi->datasize)) > 0) {
    dsi->datasize -= dsi->proto_raw_read(dsi, buf, length);
    return length;
  }

  sigaction(dsi->signals.ignore, &dsi->signals.save, NULL);
  return 0;
}

/* flush any unread buffers. */
void dsi_writeflush(DSI *dsi)
{
  size_t length;

  while (dsi->datasize > 0) { 
    length = dsi->proto_raw_read(dsi, dsi->data,
				 min(sizeof(dsi->data), dsi->datasize));
    if (length > 0)
      dsi->datasize -= length;
    else
      break;
  }

  sigaction(dsi->signals.ignore, &dsi->signals.save, NULL);
}
