!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  system.S
!* Purpose: system management functions for DOS simulator
!* Entries: dos0D, dos0E, dos19, dos1A, dos25, dos2E, dos2F, dos30,
!*          dos34, dos35, dos37, dos54
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./dospriv.inc"


!
!**************************************************************************
!
! Miscellaneous equates:
!
DEF_DTA		equ	$0080		! default DTA address within PSP
DOS_MAJOR	equ	3		! simulate DOS major version 3
DOS_MINOR	equ	2		! simulate DOS minor version 2


!
!**************************************************************************
!
! BSS segment
!
	.bss

	extrn	curr_psp		! current PSP segment
	extrn	dos_active		! DOS active flag


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	dos0D
	public	dos0E
	public	dos19		! define entry points
	public	dos1A
	public	dos25
	public	dos2E
	public	dos2F
	public	dos30
	public	dos34
	public	dos35
	public	dos37
	public	dos54


!
!**************************************************************************
!
! Dummy for unused functions.
! Input:  none
! Output: AL  -  zero
! Registers changed: AL
!
dos54:
dos19:
dos0E:

	xor	al,al

dos37:
dos2E:
dos1A:
dos0D:

	ret


!
!**************************************************************************
!
! Set interrupt vector
! Input:  AL     -  interrupt number
!         DS:DX  -  pointer to interrupt routine
! Output: none
! Registers changed: none
!
dos25:

	push	es
	push	ax
	push	bx
#ifdef IS386
	movzx	bx,al
#else
	mov	bl,al
	xor	bh,bh
#endif
#ifdef IS186
	shl	bx,#2
#else
	shl	bx,#1			! convert interrupt number into
	shl	bx,#1			! vector address
#endif
	xor	ax,ax
	mov	es,ax
	mov	ax,old_ds[bp]
	cli
	seg	es
	mov	[bx+0],dx		! save new vector
	seg	es
	mov	[bx+2],ax
	sti
	pop	bx
	pop	ax
	pop	es
	ret


!
!**************************************************************************
!
! Return current DTA.
! Input:  none
! Output: ES:BX  -  address of current DTA
! Registers changed: BX, ES
!
dos2F:

	mov	es,curr_psp		! return PSP:0080 as the DTA address
	mov	bx,#DEF_DTA
	ret


!
!**************************************************************************
!
! Return DOS version number. This will return 3.2 as the simulated
! version number.
! Input:  none
! Output: AL  -  major version number
!         AH  -  minor version number
! Registers changed: AX, BX, CX
!
dos30:

	mov	ax,#(DOS_MINOR << 8) + DOS_MAJOR
	ret


!
!**************************************************************************
!
! Return address of DOS active byte (undocumented).
! Input:  none
! Output: ES:BX  -  pointer to DOS active byte
! Registers changed:  BX, ES
!
dos34:

	mov	bx,ds
	mov	es,bx
	mov	bx,#dos_active
	ret


!
!**************************************************************************
!
! Return interrupt vector.
! Input:  AL     -  vector number
! Output: ES:BX  -  pointer to vector routine
! Registers changed: BX, ES
!
dos35:

	xor	bx,bx
	mov	es,bx
#ifdef IS386
	movzx	bx,al
#else
	mov	bl,al
	xor	bh,bh
#endif
#ifdef IS186
	shl	bx,#2
#else
	shl	bx,#1			! compute pointer to interrupt
	shl	bx,#1			! vector
#endif
	seg	es
	les	bx,[bx]			! get interrupt vector
	ret


!
!**************************************************************************
!
	end

