/*
 * runtime.inc  -  constants for runtime module
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*
 ***************************************************************************
 *
 * Vendor information for the boot rom image. These values have to be
 * identical to those in mknbi.h.
 */

#define VENDOR_MAGIC	"GK-mknbi-mgl"	/* vendor ID */
#define VENDOR_SIZE	3		/* size of vendor ID in dwords */

#define VENDOR_RUNTIME	16		/* tag for runtime segment */

#define SERVICE_INT	0x0078		/* Bootrom services interrupt */
#define SERVICE_MAGIC	0x474B		/* Magic ID */



/*
 ***************************************************************************
 *
 * The following values have to be identical with those in the C header
 * files:
 */
#define DATAOFS		0x0008
#define CMD_FIRSTINT	0x0062
#define MAX_STR_LEN	255
#define ADDR_SERVERNAME	0x0100
#define ADDR_HOSTNAME	0x0200



/*
 ***************************************************************************
 *
 * Layout and magic ID of boot rom image header. These values have to
 * be identical to those used by the boot rom. See SPEC.DOC of the
 * boot rom source for further information.
 */

#define	BOOT_MAGIC	0x1B031336	/* boot image header magic cookie */
#define BOOT_SIZE	512		/* total size of boot image header */

#define BOOT_HD_SIZE	4		/* size of header in dwords */
#define BOOT_HD_MAGIC	0		/* offset for header magic number */
#define BOOT_HD_LENGTH	4		/* offset for header length */
#define BOOT_HD_FLAG1	5		/* offset for header flag 1 */
#define BOOT_HD_FLAG2	6		/* offset for header flag 2 */
#define BOOT_HD_FLAG3	7		/* offset for header flag 3 */
#define BOOT_HD_LOCN	8		/* offset for header location */
#define BOOT_HD_EXEC	12		/* offset for execute address */
#define BOOT_HD_VENDOR	16		/* offset for header vendor information */

#define BOOT_LD_SIZE	4		/* size of load record in dwords */
#define BOOT_LD_LENGTH	0		/* offset for load record length */
#define BOOT_LD_TAG1	1		/* offset for load record tag 1 */
#define BOOT_LD_TAG2	2		/* offset for load record tag 2 */
#define BOOT_LD_FLAGS	3		/* offset for load record flags */
#define BOOT_LD_ADDR	4		/* offset for absolute address */
#define BOOT_LD_ILENGTH	8		/* offset for image length */
#define BOOT_LD_MLENGTH	12		/* offset for memory length */
#define BOOT_LD_VENDOR	16		/* offset for vendor information */

#define BOOT_FLAG_B0	0x01		/* mask for load record flag B0 */
#define BOOT_FLAG_B1	0x02		/* mask for load record flag B1 */
#define BOOT_FLAG_EOF	0x04		/* mask for load record flag EOF */



/*
 ***************************************************************************
 *
 * Layout and magic ID of bootp record. Refer to RFC 951, RFC 1048
 * and RFC 1533 for further information. The BOOTP record can be
 * longer than the standard length as the bootrom might be able to
 * load a vendor extension file via tftp.
 */

#define BOOTP_MAGIC_RFC	0x63, 0x82, 0x53, 0x63	/* RFC 1048 vendor ID */
#define BOOTP_MAGIC_CMU	0x43, 0x4D, 0x55, 0x00	/* CMU vendor ID */
#define BOOTP_MAGIC_STA	0x53, 0x54, 0x41, 0x4E	/* Stanford vendor ID */
#define BOOTP_MAGIC_LEN	4			/* length of vendor ID */

#define BOOTP_REQUEST	1		/* bootp OP-code */
#define BOOTP_REPLY	2

#define BOOTP_OP	0		/* offset to bootp OP-code */
#define BOOTP_SERVER	20		/* offset to server address */
#define BOOTP_SNAME	44		/* offset to server name */
#define BOOTP_FNAME	108		/* offset to image file name */
#define BOOTP_VEND	236		/* offset to vendor information */
#define BOOTP_SIZE	300		/* size of complete bootp record */

#define BOOTP_MAX_SNAME	64		/* max size of server name */
#define BOOTP_MAX_FNAME	128		/* max size of image file name */
#define BOOTP_MAX_SIZE	2048		/* max size of bootp per Spec.doc */

#define BOOTP_RFC_NOP	0		/* RFC vendor tag for NO-OP */
#define BOOTP_RFC_ROUTE	3		/* RFC vendor tag for gateway address */
#define BOOTP_RFC_HOST	12		/* RFC vendor tag for host name */
#define BOOTP_RFC_END	255		/* RFC vendor tag for end of record */

