/*
 * PPPupd - pppupd.h - Include file for PPPupd daemon.
 * Jake Bouvrie	<swarthy@thetasys.com>
 * Fri Jan 26 03:01:04 EST 1996
 */

#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<signal.h>
#include        <errno.h>
#include	<syslog.h>

#include	<time.h>
#include	<malloc.h>
#include	<ctype.h>
#include	<string.h>

#include	<netdb.h>

#include	<stdio.h>
#include	<stdlib.h>

typedef struct opt {
	char	*logpath;
	char	*connectscriptpath;
	char	*killscriptpath;
	char	*pingpath;
	char	*pingaddr;
	char	*pidpath;
	char	*syslogpriority;
	int	sysloglogging;
	int	stdoutlogging;
	int	delay;
	uid_t	uid;
	gid_t	gid;
} OPT ;	

/* from pppsubs.c */
OPT     *ParseConfigFile(void);
int     PPPConnect(OPT *);
int     PPPConnectTest(OPT *);
int     PPPSendPing(OPT *);
int	PPPKill(char	*killscriptpath);

/* from misc.c */
int	exist(char *);
int	makepriority(char *,int	*,int	*);
char	*getdate();
char	*lowerstr(char *);
void	err_fatal(char *);

