/*
 * snmpwalk.c -
 * send snmp GETNEXT requests to a network entity, walking a subtree.
 *
 */
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#ifdef linux
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#endif

#include "mib.h"
#include "snmp.h"
#include "snmp_impl.h"
#include "asn1.h"
#include "snmp_api.h"
#include "snmp_client.h"

#include "version.h"

#include <sys/time.h>


#define MAX_VARIABLES 32

oid objid_mib[] = {1, 3, 6, 1, 2, 1};

int	snmp_dump_packet = 0;

static void
usage ()
{
    fprintf (stderr, 
	     "usage: snmpwalk [opts] host community [object-id ...]\n");
    fprintf (stderr, "valid opts are:\n");
    fprintf (stderr, " -p <port>    - port to use; default port 161\n");
    fprintf (stderr, " -s           - print additional statistics\n");
    fprintf (stderr,
	     " -T <timeout> - initial timeout in ms; default is %d ms\n",
	     (int) (SNMP_API_DEFAULT_TIMEOUT / 1000));
    fprintf (stderr, " -R <retries> - # of retries; default is %d retries\n",
	     SNMP_API_DEFAULT_RETRIES);
    fprintf (stderr, " -V           - print version and exit\n");

    exit (1);
}


int
main(argc, argv)
    int	    argc;
    char    *argv[];
{
    struct snmp_session	session, *ss;
    struct snmp_pdu *pdu, *response = 0;
    struct variable_list *vars;
    int	arg;
    char *gateway = NULL;
    char *community = NULL;
#if 0
    int gotroot = 0;
    oid	name[32];
    int name_length;
    oid root[MAX_NAME_LEN];
    int	rootlen, count;
#else
    int rootCount = 0;
    oid name[MAX_VARIABLES][MAX_NAME_LEN];
    int name_length[MAX_VARIABLES];
    oid root[MAX_VARIABLES][MAX_NAME_LEN];
    int rootlen[MAX_VARIABLES], count;
#endif
    int running;
    int status;
    int port_flag = 0;
    int dest_port = 0;
    int timo_flag = 0;
    int timo_val = 0;
    int retry_flag = 0;
    int retry_val = 0;
    int replyCount = 0;
    int variableCount = 0;
    int dump_statistics = 0;

    int i = 0;

    struct timeval mytimeval;
    time_t seconds1, seconds2;
    int useconds1, useconds2;
    long mydiff;

    init_mib();
    /*
     * usage: snmpwalk gateway-name community-name [object-id]
     */
    for(arg = 1; arg < argc; arg++) {

	if (argv[arg][0] == '-') {

	    switch (argv[arg][1]){

		case 'V':
		    printf ("%s\n", CMU_VERSION);
		    exit (1);
		    break;

		case 'd':
		    snmp_dump_packet++;
		    break;

		case 's':
		    dump_statistics++;
		    break;

                case 'p':
                    port_flag = 1;
		    if (arg + 1 >= argc)
		      usage ();
                    dest_port = atoi(argv[++arg]);
                    break;

                case 'T':
                    timo_flag = 1;
		    if (arg + 1 >= argc)
		      usage ();
                    timo_val = atoi(argv[++arg]);
                    break;

                case 'R':
                    retry_flag = 1;
		    if (arg + 1 >= argc)
		      usage ();
                    retry_val = atoi(argv[++arg]);
                    break;

		default:
		    printf("invalid option: -%c\n", argv[arg][1]);
		    usage ();
		    break;
	    }
	} else if (gateway == NULL) {
	    gateway = argv[arg];
	} else if (community == NULL) {
	    community = argv[arg]; 
#if 0
	} else {
	    rootlen = MAX_NAME_LEN;
	    if (read_objid(argv[arg], root, &rootlen)){
		gotroot = 1;
	    } else {
#else
        } else if( rootCount < MAX_VARIABLES ) {
	  rootlen[rootCount] = MAX_NAME_LEN;
	  if (read_objid(argv[arg], &(root[rootCount][0]),
			 &(rootlen[rootCount]))) {
	    ++rootCount;
	  } else {
#endif
	    printf("Invalid object identifier: %s\n", argv[arg]);
	    exit (1);
	  }
	}
        else
            fprintf( stderr,
                     "Too many variables (maximum is %d), ignoring %s\n",
                     MAX_VARIABLES, argv[arg]
                     );
    }

#if 0
    if (gotroot == 0){
	bcopy((char *)objid_mib, (char *)root, sizeof(objid_mib));
	rootlen = sizeof(objid_mib) / sizeof(oid);
	gotroot = 1;
    }
#else
    if (rootCount == 0)
    {
        bcopy((char *)objid_mib, (char *)&(root[0][0]), sizeof(objid_mib));
        rootlen[0] = sizeof(objid_mib) / sizeof(oid);
        rootCount = 1;
    }
#endif

#if 0
    if (!(gateway && community && gotroot == 1)){
#else
    if (!(gateway && community && rootCount > 0)) {
#endif
	usage ();
    }

    bzero((char *)&session, sizeof(struct snmp_session));
    session.peername = gateway;
    if (port_flag)
      session.remote_port = dest_port;
    session.community = (u_char *)community;
    session.community_len = strlen((char *)community);
    if (retry_flag) {
      session.retries = retry_val;
    } else {
      session.retries = SNMP_DEFAULT_RETRIES;
    }
    if (timo_flag) {
      session.timeout = timo_val * 1024;
    } else {
      session.timeout = SNMP_DEFAULT_TIMEOUT;
    }
    session.authenticator = NULL;
    snmp_synch_setup(&session);
    ss = snmp_open(&session);
    if (ss == NULL) {
	printf("Couldn't open snmp\n");
	exit(-1);
    }

#if 0
    bcopy((char *)root, (char *)name, rootlen * sizeof(oid));
    name_length = rootlen;
#else
    gettimeofday(&mytimeval, 0);
    seconds1 = mytimeval.tv_sec;
    useconds1 = mytimeval.tv_usec;

    for( i=0; i<rootCount; ++i ) {

      bcopy((char *)&(root[i][0]), (char *)&(name[i][0]),
	    rootlen[i] * sizeof(oid));
      name_length[i] = rootlen[i];
    }
#endif

    running = 1;
    while(running) {
	running = 0;
	pdu = snmp_pdu_create(GETNEXT_REQ_MSG);

#if 0
	snmp_add_null_var(pdu, name, name_length);
#else
        for( i=0; i<rootCount; ++i ) {
            snmp_add_null_var(pdu, name[i], name_length[i]);
	}
#endif

	status = snmp_synch_response(ss, pdu, &response);
#if 0
	/* why this ? */
 	sleep(1);
#endif

#if 0
	if (status == STAT_SUCCESS){
	    if (response->errstat == SNMP_ERR_NOERROR){
		if (response->command == REPORT_MSG) {
#else
        if (status == STAT_SUCCESS) {
	  ++replyCount;

	  if (response->errstat == SNMP_ERR_NOERROR) {
	    
	    if (response->command == REPORT_MSG) {
#endif
		    printf ("This is an error report.\n");
		    for(vars = response->variables; vars; 
				vars = vars->next_variable)
			print_variable(vars->name, vars->name_length, vars);
		    }

	        i=0;   /** for now **/
		for(vars = response->variables; vars; vars = vars->next_variable){
#if 0
		    if (vars->name_length < rootlen || bcmp(root, vars->name, rootlen * sizeof(oid)))
#else
                    if (vars->name_length < rootlen[i] || bcmp(&(root[i][0]), vars->name, rootlen[i] * sizeof(oid)))
#endif
			continue;	/* not part of this subtree */
		    if( vars->type != SNMP_ENDOFMIBVIEW ) {
			    if( response->command == REPORT_MSG )
				printf( "this is an error report\n" );
                        ++variableCount;
			    print_variable(vars->name, vars->name_length, vars);
#if 0
			    bcopy((char *)vars->name, (char *)name, vars->name_length * sizeof(oid));
			    name_length = vars->name_length;
#else
                        bcopy((char *)vars->name, (char *)&(name[i][0]), vars->name_length * sizeof(oid));
                        name_length[i] = vars->name_length;
#endif
			    if( response->command != REPORT_MSG )
				running = 1; /* restart so we can get next variable */
		    }
                    ++i; // for now
                }
	    } else {
		if (response->errstat == SNMP_ERR_NOSUCHNAME){
		    printf("End of MIB.\n");
		} else {
		    printf("Error in packet.\nReason: %s\n", snmp_errstring(response->errstat));
		    if (response->errstat == SNMP_ERR_NOSUCHNAME){
			printf("The request for this object identifier failed: ");
			for(count = 1, vars = response->variables; vars && count != response->errindex;
			    vars = vars->next_variable, count++)
				;
			if (vars)
			    print_objid(vars->name, vars->name_length);
			printf("\n");
		    }
		}
	    }

	} else if (status == STAT_TIMEOUT){
	    printf("No Response from %s\n", gateway);
	    exit (1);
	} else {    /* status == STAT_ERROR */
	    printf("An error occurred, Quitting\n");
	    exit (1);
	}

	if (response) {
	    snmp_free_pdu(response);
	    response = 0;
	}
    }

    if (dump_statistics) {
      gettimeofday(&mytimeval, 0);
      seconds2 = mytimeval.tv_sec;
      useconds2 = mytimeval.tv_usec;
      mydiff = (seconds2-seconds1)*1000000 + (useconds2 - useconds1);
      mydiff = mydiff/1000;

      printf("Got %d responses containing %d variables\n", replyCount, 
	     variableCount );
      printf ("time taken %ld milliseconds\n" , mydiff);
    }

    snmp_close(ss);

    return 0;
}

