/*  VER 023   TAB P   $Id: auth.c,v 1.2 1997/08/14 13:39:42 src Exp $
 *
 *  authorization related stuff
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

/*
 *  pick authorisation info
 */
void 
get_authinfo(char *file)
{
    FILE *f;
    char *p;
    static char buf[BUFSIZ];

    if (!(f = fopen(file,"r"))) {
	log_msg(L_ERRno,"can't open authorization file \"%s\"",file);
	unlock_exit(10);
    }
    while (fgets(buf,BUFSIZ,f)) {
	p = buf;
	while (isspace(*p)) ++p;
	if (p[0] && p[0] != '#') {
	    ai_username = p;
	    while (*p && !isspace(*p)) ++p;
	    if (!*p) {
	      bad:
		log_msg(L_ERRno,"bad syntax in authinfo \"%s\"",buf);
		unlock_exit(10);
	    }
	    *p++ = '\0';
	    log_msg(L_DEBUG4,"username %s",ai_username);
	    while (isspace(*p)) ++p;
	    if (!*p) goto bad;
	    ai_password = p;
	    while (*p && !isspace(*p)) ++p;
	    *p = '\0';
	    break;
	}
    }
    fclose(f);
}

/*
 *  check in the authinfo username and password with the
 *  server 
 */
void 
do_authinfo(char *username,char *password)
{
    char buf[NNTP_STRLEN];
    char *endptr;

    progtitle("do authinfo");

    /* send the username to the server */
    sprintf(buf, "AUTHINFO USER %s%s", username,newline);
    put_server(buf);
    if (noaction_opt) return;

    /* get the response and check it's okay */
    if (!get_server_nntp(buf, sizeof(buf))) unlock_exit(9);
    if (strtoul(buf,&endptr,10) != NEED_AUTHDATA) {
	log_msg(L_ERR,"NNTP authinfo protocol error: got \"%s\"", buf);
	unlock_exit(4);
    }
		    
    /* send the password to the server */
    sprintf(buf, "AUTHINFO PASS %s%s", password,newline);
    put_server(buf);

    /* get the response and check it's okay */
    if (!get_server_nntp(buf, sizeof(buf))) unlock_exit(9);
    if (strtoul(buf,&endptr,10) != OK_AUTH) {
	log_msg(L_ERR,"NNTP authorization failed: got \"%s\"", buf);
	unlock_exit(4);
    }
}

/*
 *  send mode reader command to INN to switch to nnrpd
 *  so we can do a NEWNEWS.
 */
void 
do_mode_reader(void)
{
    char buf[NNTP_STRLEN];
    char *endptr;

    progtitle("mode reader");
    /* send the command to the server */
    sprintf(buf, "MODE READER%s", newline);
    put_server(buf);
    if (noaction_opt) return;

    /* get the response and check it's okay */
    if (!get_server_nntp(buf,sizeof(buf))) unlock_exit(9);

    switch (strtoul(buf,&endptr,10)) {
    case OK_NOPOST:
	/* BUG: handle this? */
    case OK_CANPOST:
	break;
    default:
	log_msg(L_ERR,"NNTP mode reader protocol error: got \"%s\"", buf);
	unlock_exit(4);
    }
}
