## --------------------------------------------------------- ##
## Find if ogonkify package should be installed		     ##
## Find what it needs.         demaille@inf.enst.fr          ##
## --------------------------------------------------------- ##

# serial 2

#
#	Ogonkify support
#

dnl Composite needs ibmfonts and perl
AC_DEFUN(ad_IBMFONTS,
   [AC_MSG_CHECKING(for IBM font files)
    for i in /usr/local/lib/X11R6/fonts/Type1 \
	/usr/local/lib/X11R5/fonts/Type1 \
	/usr/local/X11R6/lib/X11/fonts/Type1 \
	/usr/local/X11R5/lib/X11/fonts/Type1 \
	/usr/openwin/lib/X11/fonts/Type1 \
	/usr/local/share/TeX/gs/fonts
	do
	 if test -r $i; then
	   for j in 'cour*.pfa' 'ncr*.pfa'
	   do
	     if test -n "`ls $i/$j`"; then
	       ibmfonts=$i/$j
	       AC_SUBST(ibmfonts)
		 break 2;
	     fi
	   done
	 fi
	done
	if test -n "$ibmfonts"; then
	   AC_MSG_RESULT($ibmfonts)
	else
 	   AC_MSG_RESULT(no)
	fi])


AC_DEFUN(ad_WITH_OGONKIFY,
  [AC_MSG_CHECKING(whether ogonkify is required)
   AC_ARG_WITH(ogonkify,
     	       [  --without-ogonkify      do not install ogonkify],
	       [if test x$withval = xno; then
                  AC_MSG_RESULT(no)
	          install_ogonkify=no
		else
                  AC_MSG_RESULT(yes)
		  install_ogonkify=yes
		fi],
	       [AC_MSG_RESULT(yes)
		install_ogonkify=yes])
   if test x$install_ogonkify = xyes; then
     dnl Ogonkify needs perl
     AC_PATH_PROG(PERL, perl, no)
     if test x$ac_cv_path_PERL = xno; then
        install_ogonkify=no
     fi
   fi
   if test x$install_ogonkify = xyes; then
    ad_IBMFONTS
   fi
   AM_CONDITIONAL(WITH_OGONKIFY, test x$install_ogonkify = xyes)
  ])
