/*
 * options.h
 *
 * options handling & (dynamic) configuration of a2ps.
 *
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97, 98 Akim Demaille, Miguel Santana
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "backupfile.h"

struct a2ps_job;

/*
 * Type of the functions for options hooks
 */
typedef int (* option_hook) PARAMS ((int opt, char * arg));
extern option_hook handle_option_hook;

/*
 * Handle options' arguments
 */
int a2ps_get_symbolic_value PARAMS ((const char * const args[], 
				const void * values,
				const char * opt,
				const char * arg));
enum backup_type a2ps_get_backup_type PARAMS ((const char * word));
boolean a2ps_get_boolean PARAMS ((const char * option, const char * arg));
int a2ps_get_integer_in_range PARAMS ((const char * option, const char * arg,
				  int min, int max));

/*
 * Handle the options.
 */
int a2ps_handle_option PARAMS ((struct a2ps_job * job,
				int argc, char *argv[]));
int a2ps_handle_string_options PARAMS ((struct a2ps_job * job,
					const char *string));

#endif
