/* path-concat.c -- concatenate two arbitrary pathnames
   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by Jim Meyering.  */
/* Modified by Akim Demaille:
   1. hard coded `/' is now macro DIR_SEP
   2. dir may be NULL
   3. Use MALLOC instead of malloc
   */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "xmalloc.h"
#include "pathconcat.h"

char *stpcpy ();

/* Concatenate two pathname components, DIR and BASE, in newly-allocated
   storage and return the result.  Return 0 if out of memory.  Add a slash
   between DIR and BASE in the result if neither would contribute one.
   If each would contribute at least one, elide one from the end of DIR.
   Otherwise, simply concatenate DIR and BASE.  In any case, if
   BASE_IN_RESULT is non-NULL, set *BASE_IN_RESULT to point to the copy of
   BASE in the returned concatenation.  */

char *
path_concat (dir, base, base_in_result)
     const char *dir;
     const char *base;
     char **base_in_result;
{
  char *p;
  char *p_concat;

  if (!dir) {
    p_concat = xstrdup (base);
    if (base_in_result)
      *base_in_result = p_concat;
    return p_concat;
  }

  p_concat = MALLOC (strlen (dir) + strlen (base) + 2);
  p = stpcpy (p_concat, dir);
  
  if (*(p - 1) == DIR_SEP && *base == DIR_SEP)
    --p;
  else if (*(p - 1) != DIR_SEP && *base != DIR_SEP) {
    *p++ = DIR_SEP;
    *p = '\0';
  }

  if (base_in_result)
    *base_in_result = p;

  stpcpy (p, base);

  return p_concat;
}
