;; $Id: dbsect.dsl 1.3 1998/02/04 02:51:42 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================== SECTIONS ==============================

;; BRIDGEHEAD isn't a proper section, but appears to be a section title
(element BRIDGEHEAD
  (let* ((renderas (attribute-string "renderas"))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if not real section level,
	      (string->number             ;;   then get the apparent level
	       (substring renderas 4 5))  ;;   from "renderas",
	      (SECTLEVEL)))               ;; else use the real level
	 (helem
	  (string-append "H" (number->string (+ hlevel 1)))))
    (make element gi: helem
	  (process-children))))

(define ($section-separator$) 
  (if (or (not nochunks) (node-list=? (current-node) (sgml-root-element)))
      (empty-sosofo)
      (make empty-element gi: "HR")))

(define ($section$)
  (html-document (with-mode title-mode (process-first-descendant "TITLE"))
		 ($section-body$)))

(define ($section-body$)
  (make sequence
    ($section-separator$)
    ($section-title$)
    (process-children)))

(define ($section-title$)
  (let* ((sect (current-node))
	 (info (cond
		((equal? (gi) "SECT1")
		 (select-elements (children sect) "SECT1INFO"))
		((equal? (gi) "SECT2")
		 (select-elements (children sect) "SECT2INFO"))
		((equal? (gi) "SECT3")
		 (select-elements (children sect) "SECT3INFO"))
		((equal? (gi) "SECT4")
		 (select-elements (children sect) "SECT4INFO"))
		((equal? (gi) "SECT5")
		 (select-elements (children sect) "SECT5INFO"))
		((equal? (gi) "REFSECT1")
		 (select-elements (children sect) "REFSECT1INFO"))
		((equal? (gi) "REFSECT2")
		 (select-elements (children sect) "REFSECT2INFO"))
		((equal? (gi) "REFSECT3")
		 (select-elements (children sect) "REFSECT3INFO"))
		(else ;; BIBLIODIV, GLOSSDIV, INDEXDIV, PARTINTRO, SIMPLESECT
		 (empty-node-list))))
	 (subtitles (select-elements (children info) "SUBTITLE"))
	 (renderas (inherited-attribute-string "renderas" sect))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if not real section level,
	      (string->number             ;;   then get the apparent level
	       (substring renderas 4 5))  ;;   from "renderas",
	      (SECTLEVEL)))               ;; else use the real level
	 (h1elem
	  (string-append "H" (number->string hlevel)))
	 (h2elem
	  (string-append "H" (number->string (+ hlevel 1))))
	 (name (element-id))
	 (isep (gentext-intra-label-sep (gi sect)))
	 (nsep (gentext-label-title-sep (gi sect))))
    (make sequence
      (make element gi: h1elem
	    (make element gi: "A"
		  attributes: (list (list "NAME" name))
		  (if (string=? (element-label (current-node)) "")
		      (empty-sosofo)
		      (literal (element-label (current-node)) nsep))
		  (element-title-sosofo sect)))
      (if (node-list-empty? subtitles) 
	  (empty-sosofo)
	  (with-mode subtitle-mode
	    (make element gi: h2elem
		  (process-node-list subtitles)))))))

(element SECT1 ($section$))
(element (SECT1 TITLE) (empty-sosofo))

(element SECT2 ($section$))
(element (SECT2 TITLE) (empty-sosofo))

(element SECT3 ($section$))
(element (SECT3 TITLE) (empty-sosofo))

(element SECT4 ($section$))
(element (SECT4 TITLE) (empty-sosofo))

(element SECT5 ($section$))
(element (SECT5 TITLE) (empty-sosofo))

(element SIMPLESECT ($section$))
(element (SIMPLESECT TITLE) (empty-sosofo))

