;; $Id: dbprint.dsl 1.0 1997/12/30 17:30:52 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define (HSIZE n)
  (let ((m (if (< n 0) 0 n)))
    (* %bf-size%
       (expt %hsize-bump-factor% m))))

;; ====================== COMMON STYLE TEMPLATES =======================

(define ($block-container$)
  (make display-group
	space-before: %block-sep%
	space-after: %block-sep%
	start-indent: %body-start-indent%
	(process-children)))

(define ($paragraph$)
  (make paragraph
	use: para-style
	space-before: %para-sep%
	space-after: %para-sep%
 	quadding: %default-quadding%
	(process-children)))

(define ($para-container$)
  (make paragraph
	space-before: %para-sep%
	space-after: %para-sep%
	start-indent: (if (member (current-node) outer-parent-list)
			  %body-start-indent%
			  (inherited-start-indent))
	(process-children)))

(define ($indent-para-container$)
  (make paragraph
	space-before: %para-sep%
	space-after: %para-sep%
	start-indent: (+ (inherited-start-indent) (* (ILSTEP) 2))
	quadding: %default-quadding%
	(process-children)))

(define para-style
  (style
   font-size: %bf-size%
   font-weight: 'medium
   font-posture: 'upright
   font-family-name: %body-font-family%
   line-spacing: (* %bf-size% %line-spacing-factor%)))

(define ($bold-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-weight: 'bold
    sosofo))

(define ($italic-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-posture: 'italic
    sosofo))

(define ($bold-italic-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-weight: 'bold
    font-posture: 'italic
    sosofo))

(define ($mono-seq$ #!optional (sosofo (process-children)))
  (let ((%factor% (if %verbatim-size-factor% 
		      %verbatim-size-factor% 
		      1.0)))
    (make sequence
      font-family-name: %mono-font-family%
      font-size: (* (inherited-font-size) %factor%)
      sosofo)))

(define ($italic-mono-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-family-name: %mono-font-family%
    font-posture: 'italic
    sosofo))

(define ($bold-mono-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-family-name: %mono-font-family%
    font-weight: 'bold
    sosofo))

(define ($score-seq$ stype #!optional (sosofo (process-children)))
  (make score
    type: stype
    sosofo))

(define ($charseq$ #!optional (sosofo (process-children)))
  (make sequence
    sosofo))

(define ($guilabel-seq$ #!optional (sosofo (process-children)))
  (make sequence
    font-family-name: %guilabel-font-family%
    sosofo))

;; Stolen from a posting by James on dssslist
(define *small-caps*
  (letrec ((signature (* #o375 256))
	   (make-afii
	    (lambda (n)
	      (glyph-id (string-append "ISO/IEC 10036/RA//Glyphs::"
				       (number->string n)))))
	   (gen
	    (lambda (from count)
	      (if (= count 0)
		  '()
		  (cons (cons (make-afii from)
			      (make-afii (+ from signature)))
			(gen (+ 1 from)
			     (- count 1)))))))
    (glyph-subst-table (gen #o141 26))))

