/* $Id: col-align.cc,v 1.3 1997/03/22 20:20:17 dps Exp $ */
#include <string.h>
#include <ctype.h>
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

/* Calculate the widths and guess the alignment a column wants */
struct wd_info find_width(int rows, const char *const *cdata)
{
    int max_wd[3], i, not_num, is_num;
    int lt_sp, rt_sp, align_set;
    wd_info res;
    const char *cdp, *sc;
    num_info nd;

    max_wd[0]=0;
    max_wd[1]=0;
    max_wd[2]=0;
    is_num=not_num=align_set=0;
    res.align=ALIGN_LEFT;
    res.has_sign=0;

    for (i=0; i<rows; i++)
    {
	cdp=cdata[i];
	if (cdp==NULL)
	    continue;		// Handle blank entries

	nd=scan_num(cdp);
	if (nd.dot_pos==-1)
	    not_num++;
	else
	{
	    is_num++;
	    res.has_sign |= nd.has_sign;
	    if (nd.wd[0]>max_wd[0])
		max_wd[0]=nd.wd[0];
	    if (nd.wd[1]>max_wd[1])
		max_wd[1]=nd.wd[1];
	}
	if (strlen(cdp)>(unsigned) max_wd[2])
	    max_wd[2]=strlen(cdp);
	for (lt_sp=0, sc=cdp; isspace(*sc); sc++, lt_sp++)
	{
	    if (*sc==CH_SUSPECT)
		align_set=1;
	}
	if (*sc=='\0')
	    continue;		// Blank entry gives no information

	while (*sc!='\0')
	{
	    if (*sc==CH_SUSPECT)
		align_set=1;
	    if (isspace(*sc))
		rt_sp++;
	    else
		rt_sp=0;
	    sc++;
	}

	if (align_set)
	    continue;

	if (lt_sp==0 && rt_sp<=1)
	    continue;
	if (lt_sp-rt_sp<-1)
	{
	    res.align=ALIGN_LEFT;
	    continue;
	}
	if (lt_sp-rt_sp>1)
	{
	    res.align=ALIGN_RIGHT;
	    continue;
	}
	res.align=ALIGN_CENTER;
    }

    if (is_num>not_num)
    {
	/*
	 * Decimal alignment, set dp_col and leave the alignment
	 * alone to handle non-number entries nicely.
	 */
	res.width=max_wd[0]+(max_wd[1]>0) ? 0 : 1;
	res.dp_col=max_wd[0]+1;
    }
    else
    {
	res.width=0;
	res.dp_col=-1;
    }

    if (res.width<max_wd[2])
	res.width=max_wd[2];	// dp_col irrelant

    return res;
}
