/* $Id: fmt-latex.h,v 1.3 1997/03/31 21:59:42 dps Exp $ */
/* Shared stuff for the *TeX output format */

#ifndef __fmt_latex_h__
#define __fmt_latex_h__
#include "tblock.h"
#include "interface.h"
#include "latex-table.h"

/* Anything shorter than this is not a real paragraph */
#define PAR_TRESHOLD_LEN 10

/* Type */
struct embed
{
    const char *key;
    int key_len;
    void (*handle)(const char *txt, const docfmt *fmt, FILE *out,
		   void *d);
};


/* Local data */
struct latex_data
{
    latex_table *tabl;
    int col;
    int row;
    const char *last_tc;
    int unit_type;
    int par_flg;
    int list_flg;
};

/* latex-fmt.cc */
extern tblock *__latex_do_map(const char *s);

/* latex-embed.cc */
extern void ltx_embed(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d);

#endif  /* __fmt_latex_h__ */




