/* $Id: rtest2.cc,v 1.3 1997/03/21 20:39:36 dps Exp $ */
/* Reader test program */

#include <stdio.h>
#include <stdlib.h>
#include "interface.h"

/* Dummy to just read the files out */
void reader_test_raw(FILE *f)
{
    const char *s;
    const tok_seq::tok *d;
    tok_seq rd(f);
    static const char null[]={ '\0' };

    while ((d=rd.read_token())!=NULL)
    {

	printf((d->end==tok_seq::tok::TOK_START) ? "<" : "</");
	if (d->tok!=T_TABLE)
	{
	    s=(d->data.d==NULL) ? null : d->data.d;
	}

	switch(d->tok)
	{
	case T_TABLE:
	    printf("TABLE %d x %d>\n", d->data.table.cols, d->data.table.rows);
	    break;

	case T_PARAGRAPH:
	    printf("PARAGRAPH>%s\n\n", s);
	    break;

	case T_FIELD:
	    printf("FIELD>%s", s);
	    break;

	case T_ROW:
	    printf("ROW>%s\n", s);
	    break;

	case T_SPEC:
	    printf("SPEC>%s", s);
	    break;

	case T_DOC:
	    printf("DOCUMENT>%s", s);
	    break;

	default:
	    printf("?>%s\n",  s);
	}
    }
}


int main(int argc, const char **argv)
{
    FILE *f;

    argc=argc;
    f=fopen(argv[1],"r");
    if (f==NULL)
    {
	fprintf(stderr,"%s not found\n", argv[1]);
	exit(1);
    }
    reader_test_raw(f);
    return 0;
}

