#ifndef _FTFMT_TAPELIB_H
#define _FTFMT_TAPELIB_H

/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /homes/cvs/ftape-stacked/contrib/ftformat/ftfmt-tapelib.h,v $
 * $Revision: 1.4.6.1 $
 * $Date: 1997/11/14 14:55:37 $
 *
 *      This program contains the tape manipulation function
 *      declarations for the user level floppy tape formatting stuff
 *      for the QIC-40/80/3010/3020 floppy-tape driver "ftape" for
 *      Linux.
 */


extern int  tape_open(const char *name, struct opt_parms *opts,
					  u_int8_t *drive_status,					  
					  u_int8_t *drive_config,
					  u_int8_t *tape_status);
extern int tape_reopen_rw(const char *name, int tape_fd);
extern void *tape_mmap(int tape_fd, size_t dma_size);
extern void tape_close(const int tape_fd,
					   void *dma_buffer, const size_t dma_size);
extern int qic_simple_command(const int tape_fd,
							  const int ready_wait,
							  const qic117_cmd_t qic_cmd, const int parameter,
							  const int timeout, u_int8_t *status);
extern int qic_report_command(const int tape_fd,
							  const qic117_cmd_t qic_cmd,
							  const int numbits);
extern int qic_calibrate_tape_length(const int tape_fd);
extern int write_reference_burst(const int tape_fd);
extern int erase_cartridge(const int tape_fd, const int tpc);
extern int read_header_segment(const int tape_fd, void *hseg);
extern int set_format_parms(const int tape_fd,
							const struct format_parms *fmt_opts);
extern int get_format_parms(const int tape_fd,
							struct format_parms *fmt_opts);
extern int format_cartridge(const int tape_fd,
							void *dma_buf, const size_t dma_size,
							const struct format_parms *fmt_opts);
extern int verify_cartridge(const int tape_fd,
							const struct format_parms *fmt_opts,
							void *hseg);
extern int write_header_segments(const int tape_fd,
								 u_int8_t *hseg, const char *tape_label,
								 const struct format_parms *fmt_opts);
extern unsigned long tape_capacity(const struct format_parms *fmt_opts);

#endif

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  c-basic-offset: 4
 *  tab-width: 4
 * End:
 */
