/*
 * dsock.c - SGI IRIX socket processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.6 98/03/06 08:22:24 abe Exp $";
#endif


#include "lsof.h"


#if	IRIXV<50101
/*
 * process_socket() - process socket
 *
 * Handle sockets for IRIX versions below 5.1.1.
 */

void
process_socket(sa)
	KA_T sa;			/* socket address in kernel */
{
	struct inpcb cb;
	struct domain d;
	struct in_addr *fa = (struct in_addr *)NULL;
	int fam;
	int fp, lp;
	struct inode i;
	int is;
	struct in_addr *la = (struct in_addr *)NULL;
	struct mbuf mb;
	struct protosw p;
	struct rawcb raw;
	struct socket s;
	struct unpcb u, uc;
	struct sockaddr_un *ua = NULL;
	struct sockaddr_un un;
/*
 * Read the socket, then the protocol switch structure, then the
 * domain structure.
 */
	if (kread(sa, (char *)&s, sizeof(s))) {
	    enter_nm("can't read socket struct");
	    return;
	}
	if (!s.so_proto
	||  kread((KA_T)s.so_proto, (char *)&p, sizeof(p))) {
	    enter_nm("can't read protosw");
	    return;
	}
	if (!p.pr_domain
	||  kread((KA_T)p.pr_domain, (char *)&d, sizeof(d))) {
	    enter_nm("can't read protosw's domain struct");
	    return;
	}
/*
 * Save size information.
 */
	if (Fsize) {
	    if (Lf->access == 'r')
		Lf->sz = (SZOFFTYPE)s.so_rcv.sb_cc;
	    else if (Lf->access == 'w')
		Lf->sz = (SZOFFTYPE)s.so_snd.sb_cc;
	    else
		Lf->sz = (SZOFFTYPE)(s.so_rcv.sb_cc + s.so_snd.sb_cc);
	    Lf->sz_def = 1;
	} else
	    Lf->off_def = 1;

#if	defined(HASTCPTPIQ)
	Lf->lts.rq = s.so_rcv.sb_cc;
	Lf->lts.sq = s.so_snd.sb_cc;
	Lf->lts.rqs = Lf->lts.sqs = 1;
#endif	/* defined(HASTCPTPIQ) */

	switch ((fam = d.dom_family)) {

	/*
	 * Process Unix domain socket.
	 */

	case AF_UNIX:
	    if (Funix)
		Lf->sf |= SELUNX;
	    (void) strcpy(Lf->type, "unix");
	    enter_dev_ch(print_kptr(sa, (char *)NULL));
	/*
	 * Read the Unix protocol control block.
	 */
	    if (kread((KA_T) s.so_pcb, (char *)&u, sizeof(u))) {
		(void) strcpy(Namech, "can't read unpcb");
		break;
	    }
	    if ((struct socket *)sa != u.unp_socket) {
		(void) strcpy(Namech, "unp_socket mismatch");
		break;
	    }
	/*
	 * If there is an address, read it.
	 */
	    if (u.unp_addr) {
		if (kread((KA_T) u.unp_addr, (char *)&mb, sizeof(mb))) {
		    (void) strcpy(Namech, "can't read unp_addr");
		    break;
		}
		ua = (struct sockaddr_un *)(((char *)&mb) + mb.m_off);
	    }
	    if (!ua) {
		ua = &un;
		(void) bzero((char *)ua, sizeof(un));
		ua->sun_family = AF_UNSPEC;
	    }
	/*
	 * Get information on Unix socket that has no address bound
	 * to it, although it may be connected to another Unix domain
	 * socket as a pipe.
	 */
	    if (ua->sun_family != AF_UNIX) {
		if (ua->sun_family == AF_UNSPEC) {
		    if (u.unp_conn) {
			if (kread((KA_T)u.unp_conn, (char *)&uc, sizeof(uc)))
			    (void) strcpy(Namech, "can't read unp_conn");
			else
			    (void) sprintf(Namech, "->%s",
				print_kptr((KA_T)uc.unp_socket, (char *)NULL));
		    } else
			(void) strcpy(Namech, "->(none)");
		} else
		    (void) sprintf(Namech, "unknown sun_family (%d)",
			ua->sun_family);
		break;
	    }
	/*
	 * Read associated inode.
	 */
	    if (u.unp_inode && !readinode((KA_T)u.unp_inode, &i))
		is = 1;
	    else
		is = 0;
	/*
	 * Generate Unix socket information.
	 */
	    if (is) {
		Lf->dev = i.i_dev;
		Lf->dev_def = 1;
		if (Lf->dev_ch) {
		   (void) free((FREE_P *)Lf->dev_ch);
		    Lf->dev_ch = (char *)NULL;
		}
		Lf->inode = (unsigned long)i.i_number;
		Lf->inp_ty = 1;
	    }
	    if (ua->sun_path[0]) {
		if (mb.m_len >= sizeof(struct sockaddr_un))
		    mb.m_len = sizeof(struct sockaddr_un) - 1;
		*((char *)ua + mb.m_len) = '\0';
		if (Sfile && is_file_named(ua->sun_path, IFSOCK))
		    Lf->sf |= SELNM;
		else
		    (void) strcpy(Namech, ua->sun_path);
	    } else
		(void) strcpy(Namech, "no address");
	    break;
	/*
	 * Process Internet domain socket.
	 */

	case AF_INET:
	    if (Fnet)
		Lf->sf |= SELNET;
	    (void) strcpy(Lf->type, "inet");
	    printiproto(p.pr_protocol);
	    Lf->inp_ty = 2;
	    if (!s.so_pcb) {
		enter_nm("no inpcb available");
		return;
	    }
	/*
	 * Read protocol control block.
	 */
	    if (s.so_type == SOCK_RAW) {

	    /*
	     * Print raw socket information.
	     */
		if (kread((KA_T)s.so_pcb, (char *)&raw, sizeof(raw))
		||  (struct socket *)sa != raw.rcb_socket) {
		    enter_nm("can't read rawcb");
		    return;
		}
		(void) sprintf(dev_ch, "0x%08x",
		enter_dev_ch(print_kptr((KA_T)(raw.rcb_pcb ? raw.rcb_pcb
							   : s.so_pcb);
					(char *)NULL));
		if (raw.rcb_laddr.sa_family == AF_INET)
		    la = (struct in_addr *)&raw.rcb_laddr.sa_data[2];
		else if (raw.rcb_laddr.sa_family)
		    printrawaddr(&raw.rcb_laddr);
		if (raw.rcb_faddr.sa_family == AF_INET)
		    fa = (struct in_addr *)&raw.rcb_faddr.sa_data[2];
		else if (raw.rcb_faddr.sa_family) {
		    (void) strcat(endnm(), "->");
		    printrawaddr(&raw.rcb_faddr);
		}
		if (fa || la)
		    (void) ent_inaddr(la, -1, fa, -1);
	    } else {

	    /*
	     * Print Internet socket information.
	     */
		if (kread((KA_T)s.so_pcb, (char *)&cb, sizeof(cb))
		||  (struct socket *)sa != cb.inp_socket) {
		    enter_nm("can't read inpcb");
		    return;
		}
		enter_dev_ch(print_kptr((KA_T)(cb.inp_ppcb ? cb.inp_ppcb
							   : s.so_pcb),
					(char *)NULL));
		if (p.pr_protocol == IPPROTO_TCP
		||  p.pr_protocol == IPPROTO_UDP) {
		    la = &cb.inp_laddr;
		    lp = (int)ntohs(cb.inp_lport);
		    if (cb.inp_faddr.s_addr != INADDR_ANY || cb.inp_fport != 0)
		    {
			fa = &cb.inp_faddr;
			fp = (int)ntohs(cb.inp_fport);
		    }
		    if (fa || la)
			(void) ent_inaddr(la, lp, fa, fp);
		}
	    }
	    break;
	default:
	    printunkaf(fam);
	}
	if (Namech[0])
	    enter_nm(Namech);
}
#endif	/* IRIXV<50101 */


#if	IRIXV>=50101
/*
 * process_socket() - process socket
 *
 * (IRIX version 5.1.1 and above have BSD style sockets.)
 */

void
process_socket(sa)
	KA_T sa;			/* socket address in kernel */
{
	KA_T ca;
	struct domain d;
	char dev_ch[32];
	struct in_addr *fa = (struct in_addr *)NULL;
	int fam;
	int fp, lp;
	struct inpcb inp;
	struct in_addr *la = (struct in_addr *)NULL;
	struct mbuf mb;
	struct protosw p;
	struct rawcb raw;
	struct socket s;
	struct tcpcb t;
	struct unpcb uc, unp;
	struct sockaddr_un *ua = NULL;
	struct sockaddr_un un;

# if	IRIXV>=60200
	struct sockaddr rsa;
# endif	/* IRIXV>=60200 */

	(void) strcpy(Lf->type, "sock");
	Lf->inp_ty = 2;
/*
 * Read the socket, protocol, and domain structures.
 */
	if (!sa) {
	    enter_nm("no socket address");
	    return;
	}
	if (kread(sa, (char *)&s, sizeof(s))) {
	    (void) strcpy(Namech, "can't read socket struct");
	    enter_nm(Namech);
	    return;
	}
	if (!s.so_type) {
	    enter_nm("no socket type");
	    return;
	}
	if (!s.so_proto
	||  kread((KA_T)s.so_proto, (char *)&p, sizeof(p))) {
	    enter_nm("no protocol switch");
	    return;
	}
	if (kread((KA_T)p.pr_domain, (char *)&d, sizeof(d))) {
	    (void) strcpy(Namech, "can't read domain struct");
	    enter_nm(Namech);
	    return;
	}
/*
 * Save size information.
 */
	if (Fsize) {
	    if (Lf->access == 'r')
		Lf->sz = (SZOFFTYPE)s.so_rcv.sb_cc;
	    else if (Lf->access == 'w')
		Lf->sz = (SZOFFTYPE)s.so_snd.sb_cc;
	    else
		Lf->sz = (SZOFFTYPE)(s.so_rcv.sb_cc + s.so_snd.sb_cc);
	    Lf->sz_def = 1;
	} else
	    Lf->off_def = 1;

#if	defined(HASTCPTPIQ)
	Lf->lts.rq = s.so_rcv.sb_cc;
	Lf->lts.sq = s.so_snd.sb_cc;
	Lf->lts.rqs = Lf->lts.sqs = 1;
#endif	/* defined(HASTCPTPIQ) */

/*
 * Process socket by the associated domain family.
 */
	switch ((fam = d.dom_family)) {
/*
 * Process an Internet domain socket.
 */
	case AF_INET:
	case AF_ROUTE:
	    if (Fnet)
		Lf->sf |= SELNET;
	    (void) strcpy(Lf->type, "inet");
	    printiproto(p.pr_protocol);
	/*
	 * Read protocol control block.
	 */
	    if (!s.so_pcb) {
		(void) strcpy(Namech, "no protocol control block");
		enter_nm(Namech);
		return;
	    }
	    if (s.so_type == SOCK_RAW) {

	    /*
	     * Print raw socket information.
	     */
		if (kread((KA_T) s.so_pcb, (char *)&raw, sizeof(raw))
		||  (struct socket *)sa != raw.rcb_socket) {
		    (void) strcpy(Namech, "can't read rawcb");
		    enter_nm(Namech);
		    return;
		}
		ca = (KA_T)(raw.rcb_pcb ? raw.rcb_pcb : s.so_pcb);
		enter_dev_ch(print_kptr((KA_T)(ca & 0xffffffff),
		    (char *)NULL));

# if	IRIXV>=60200
		if (raw.rcb_laddr
		&&  kread((KA_T)raw.rcb_laddr, (char *)&rsa, sizeof(rsa))) {
		    if (rsa.sa_family == AF_INET)
			la = (struct in_addr *)&rsa.sa_data[2];
		    else if (rsa.sa_family)
			printrawaddr(&rsa);
		}
		if (raw.rcb_faddr
		&&  kread((KA_T)raw.rcb_faddr, (char *)&rsa, sizeof(rsa))) {
		    if (rsa.sa_family == AF_INET)
			fa = (struct in_addr *)&rsa.sa_data[2];
		    else if (rsa.sa_family) {
			(void) strcat(endnm(), "->");
			printrawaddr(&rsa);
		    }
		}
# else	/* IRIXV<60200 */
		if (raw.rcb_laddr.sa_family == AF_INET)
		    la = (struct in_addr *)&raw.rcb_laddr.sa_data[2];
		else if (raw.rcb_laddr.sa_family)
		    printrawaddr(&raw.rcb_laddr);
		if (raw.rcb_faddr.sa_family == AF_INET)
		    fa = (struct in_addr *)&raw.rcb_faddr.sa_data[2];
		else if (raw.rcb_faddr.sa_family) {
		    (void) strcat(endnm(), "->");
		    printrawaddr(&raw.rcb_faddr);
		}
# endif	/* IRIXV>=60200 */

		if (fa || la)
		    (void) ent_inaddr(la, -1, fa, -1);
	    } else {

	    /*
	     * Print Internet socket information.
	     */
		if (kread((KA_T) s.so_pcb, (char *) &inp, sizeof(inp))
		||  (struct socket *)sa != inp.inp_socket) {
		    enter_nm("can't read inpcb");
		    return;
		}
		ca = (KA_T)(inp.inp_ppcb ? inp.inp_ppcb : s.so_pcb);
		enter_dev_ch(print_kptr((KA_T)(ca & 0xffffffff),
		    (char *)NULL));
		la = &inp.inp_laddr;
		lp = (int)inp.inp_lport;
		if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport != 0) {
		    fa = &inp.inp_faddr;
		    fp = (int)inp.inp_fport;
		}
		if (fa || la)
		    (void) ent_inaddr(la, lp, fa, fp);
		if (p.pr_protocol == IPPROTO_TCP && inp.inp_ppcb
		&&  !kread((KA_T)inp.inp_ppcb, (char *)&t, sizeof(t))) {
		    Lf->lts.type = 0;
		    Lf->lts.state.i = (int)t.t_state;
		}
	    }
	    break;
/*
 * Process a Unix domain socket.
 */
	case AF_UNIX:
	    if (Funix)
		Lf->sf |=- SELUNX;
	    (void) strcpy(Lf->type, "unix");
	/*
	 * Read Unix protocol control block and the Unix address structure.
	 */
	    enter_dev_ch(print_kptr((KA_T)(sa & 0xffffffff), (char *)NULL));
	    if (kread((KA_T) s.so_pcb, (char *) &unp, sizeof(unp))) {
		(void) strcpy(Namech, "can't read unpcb");
		break;
	    }
	    if ((struct socket *)sa != unp.unp_socket) {
		(void) strcpy(Namech, "unp_socket mismatch");
		break;
	    }
	    if (unp.unp_addr) {
		if (kread((KA_T) unp.unp_addr, (char *) &mb, sizeof(mb))) {
		    (void) strcpy(Namech, "can't read unp_addr");
		    break;
		}
		ua = (struct sockaddr_un *)(((char *)&mb) + mb.m_off);
	    }
	    if (!ua) {
		ua = &un;
		(void) bzero((char *)ua, sizeof(un));
		ua->sun_family = AF_UNSPEC;
	    }
	/*
	 * Print information on Unix socket that has no address bound
	 * to it, although it may be connected to another Unix domain
	 * socket as a pipe.
	 */
	    if (ua->sun_family != AF_UNIX) {
		if (ua->sun_family == AF_UNSPEC) {
		    if (unp.unp_conn) {
			if (kread((KA_T)unp.unp_conn,(char *)&uc,sizeof(uc)))
			    (void) strcpy(Namech, "can't read unp_conn");
			else {
			    ca = (KA_T)uc.unp_socket;
			    (void) sprintf(Namech, "->%s",
				print_kptr((KA_T)(ca&0xffffffff),(char *)NULL));
			}
		    } else
			(void) strcpy(Namech, "->(none)");
		} else
		    (void) sprintf(Namech, "unknown sun_family (%d)",
			ua->sun_family);
		break;
	    }
	    if (ua->sun_path[0]) {
		if (mb.m_len >= sizeof(struct sockaddr_un))
		    mb.m_len = sizeof(struct sockaddr_un) - 1;
		*((char *)ua + mb.m_len) = '\0';
		if (Sfile && is_file_named(ua->sun_path, VSOCK))
		    Lf->sf |= SELNM;
		else
		    (void) strcpy(Namech, ua->sun_path);
	    } else
		(void) strcpy(Namech, "no address");
	    break;
	default:
	    printunkaf(fam);
	}
	if (Namech[0])
	    enter_nm(Namech);
}
#endif	/* IRIXV>=50101 */
