/*
 * dlsof.h - Linux header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.9 98/02/13 12:43:39 abe Exp $
 */


#if	!defined(LINUX_LSOF_H)
#define	LINUX_LSOF_H	1

#include <dirent.h>
#include <fcntl.h>
#include <malloc.h>
#include <mntent.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <unistd.h>

# if	LINUXV>=1147
#define	__KERNEL__	1
#undef	INT_MAX
#undef	UINT_MAX
#undef	LONG_MAX
#undef	ULONG_MAX
# endif	/* LINUXV>=1147 */

# if	LINUXV>=1999
#undef	d_namlen
# endif	/* LINUXV>=1999 */

#include <linux/socket.h>

# if	defined(HAS_ATOMIC_T) 
#include <asm/atomic.h>
#define	SOCK_RMEM_ALLOC	rmem_alloc.counter
#define	SOCK_WMEM_ALLOC	wmem_alloc.counter
# else	/* !defined(HAS_ATOMIC_T) */
#define	SOCK_RMEM_ALLOC	rmem_alloc
#define	SOCK_WMEM_ALLOC	wmem_alloc
# endif	/* defined(HAS_ATOMIC_T) */

# if	defined(HAS_SOCKET_SK)
#define	SOCK_SENT_SEQ	write_seq
#define	SOCKET_SOCK	sk
# else	/* !defined(HAS_SOCKET_SK) */
#define	SOCK_SENT_SEQ	sent_seq
#define	SOCKET_SOCK	data
# endif	/* defined(HAS_SOCKET_SK) */

#include <linux/net.h>

# if	defined(GLIBCV) && GLIBCV>=2

/*
 * Take glibc2 evasions.
 *
 * Because lsof works with Linux kernel structures, it needs access to
 * kernel header files.  Unfortunately glibc2 header files in /usr/include
 * are sometimes incompatible with kernel header files.  Herein we perform
 * some magic to let them coexist.
 *
 * Other more serious hanky-panky takes place in machine.h, before this
 * lsof header file is included.  Less serious glibc2 tomfoolery takes
 * place in dsock.c
 */

#undef	FASYNC
#undef	FD_SET
#undef	FD_CLR
#undef	FD_ISSET
#undef	FD_ZERO
#undef	S_IFMT
#undef	S_IFSOCK
#undef	S_IFLNK
#undef	S_IFREG
#undef	S_IFCHR
#undef	S_IFBLK
#undef	S_IFDIR
#undef	S_IFIFO
#undef	S_ISUID
#undef	S_ISGID
#undef	S_ISVTX
#undef	S_ISLNK
#undef	S_ISREG
#undef	S_ISDIR
#undef	S_ISCHR
#undef	S_ISBLK
#undef	S_ISFIFO
#undef	S_ISSOCK
#undef	S_IRWXU
#undef	S_IRUSR
#undef	S_IWUSR
#undef	S_IXUSR
#undef	S_IRWXG
#undef	S_IRGRP
#undef	S_IWGRP
#undef	S_IXGRP
#undef	S_IRWXG
#undef	S_IRWXO
#undef	S_IROTH
#undef	S_IWOTH
#undef	S_IXOTH
#define	timespec		glibc_timespec
#define	flock			glibc_flock
#undef	errno
#  if	LINUXV<2157
#define	key_t			glibc_key_t
#  endif	/* LINUXV<2157 */
# endif	/* defined(GLIBCV) && GLIBCV>=2 */

# if	LINUXV>=2157
#define	stat	kernel_stat
# endif	/* LINUXV>=2157 */

#define	RPC_MISMATCH	NFS_RPC_MISMATCH	/* avoid conflict with RPC */
#define	RPC_SUCCESS	NFS_RPC_SUCCESS		/* avoid conflict with RPC */
#include <linux/fs.h>

# if	LINUXV>=2157
#undef	stat
# endif	/* LINUXV>=2157 */

#include <linux/tasks.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/unistd.h>

# if	defined(HAS_QUERY_MODULE)
#define	query_module(nm, wh, b, bl, r)	syscall(__NR_query_module, (nm), (wh), (b), (bl), (r))
# else	/* !defined(HAS_QUERY_MODULE) */
#define	get_kernel_syms(addr)	syscall(__NR_get_kernel_syms, (addr))
# endif	/* defined(HAS_QUERY_MODULE) */

# if	LINUXV<1147
#define	PWD	pwd
#define	ROOT	root
# else	/* LINUXV>=1147 */
#define	PWD	fs->pwd
#define	ROOT	fs->root
# endif	/* LINUXV<1147 */

#include <linux/mm.h>

# if	LINUXV<1147
#include <linux/ddi.h>
# endif	/* LINUXV<1147 */

# if	defined(HASNETDEVICE_H)
#include <linux/netdevice.h>
# endif	/* defined(HASNETDEVICE_H) */

# if	LINUXV<1300
#include <net/inet/sock.h>
# else	/* LINUXV>=1300 */
#include <net/sock.h>
# endif	/* LINUXV<1300 */

# if	defined(GLIBCV) && GLIBCV>=2

/*
 * Undo the glibc2 errno evasion with a *very* risky definition.
 *
 * This is forced upon lsof by the glibc2 header file design.
 */

#  if	!defined _LIBC || defined _LIBC_REENTRANT
#define errno (*__errno_location ())
#  endif	/* !defined _LIBC || defined _LIBC_REENTRANT */
#  if	LINUXV>=2157
#define	sa_family_t		kern_sa_family_t
#  endif	/* LINUXV>=2157 */
# endif	/* defined(GLIBCV) && GLIBCV>=2 */

#include <sys/un.h>

# if	defined(HASUNMINSOCK) && HASUNMINSOCK==1
#include <net/af_unix.h>
# endif	/* defined(HASUNMINSOCK) && HASUNMINSOCK==1 */

# if	LINUXV<1300
#include <net/unix/unix.h>
# endif	/* LINUXV<1300 */


# if	defined(GLIBCV) && GLIBCV>=2

/*
 * Take glibc2 evasions.
 *
 * Because lsof works with Linux kernel structures, it needs access to
 * kernel header files.  Unfortunately glibc2 header files in /usr/include
 * are sometimes incompatible with kernel header files.  Herein we perform
 * some magic to let them coexist.
 *
 * Other more serious hanky-panky takes place in machine.h, before this
 * lsof header file is included.  Less serious glibc2 tomfoolery takes
 * place in dsock.c
 */

#undef SOCK_STREAM
#undef SOCK_DGRAM
#undef SOCK_RAW
#undef SOCK_RDM
#undef SOCK_SEQPACKET
#undef SOCK_PACKET
#undef	PF_UNSPEC
#undef	PF_UNIX
#undef	PF_INET
#undef	PF_AX25
#undef	PF_IPX
#undef	PF_APPLETALK
#undef	PF_NETROM
#undef	PF_BRIDGE
#undef	PF_AAL5
#undef	PF_X25
#undef	PF_MAX
#undef	AF_UNSPEC
#undef	AF_UNIX
#undef	AF_INET
#undef	AF_AX25
#undef	AF_IPX
#undef	AF_APPLETALK
#undef	AF_NETROM
#undef	AF_BRIDGE
#undef	AF_AAL5
#undef	AF_X25
#undef	AF_MAX
#undef	IN_CLASSA
#undef	IN_CLASSB
#undef	IN_CLASSC
#undef	IN_CLASSD
#undef	IN_EXPERIMENTAL
#undef	IN_BADCLASS
#undef	INADDR_ANY
#undef	INADDR_BROADCAST
#undef	INADDR_NONE
#undef	SCM_RIGHTS
#define	linger			kern_linger
#define	msghdr			kern_msghdr
#define	in_addr			kern_inaddr
#define	sockaddr		kern_sockaddr
#define	sockaddr_in		kern_sockaddr_in
#define	ip_mreq			kern_ip_mreq

#  if	LINUXV>=2157
#define	cmsghdr			kern_cmsghdr
#  endif	/* LINUXV>=2157 */

#  if	defined(__OPTIMIZE__)
#undef	htonl
#undef	ntohl
#  endif	/* defined(__OPTIMIZE__) */

#define	htonl			kern_htonl
#define	ntohl			kern_ntohl
#define	IPPROTO_IP		kern_IP
#define	IPPROTO_ICMP		kern_ICMP
#define	IPPROTO_IGMP		kern_IGMP
#define	IPPROTO_IPIP		kern_IPIP
#define	IPPROTO_TCP		kern_TCP
#define	IPPROTO_EGP		kern_EGP
#define	IPPROTO_PUP		kern_PUP
#define	IPPROTO_UDP		kern_UDP
#define	IPPROTO_IDP		kern_IDP
#define	IPPROTO_RAW		kern_RAW
#define	IPPROTO_MAX		kern_MAX
#undef	MSG_CTRUNC
#undef	MSG_DONTROUTE
#undef	MSG_OOB
#undef	MSG_PEEK
#undef	MSG_PROXY
#  if	LINUXV>=2157
#undef	PF_LOCAL
#undef	PF_INET6
#undef	AF_LOCAL
#undef	AF_INET6
#undef	CMSG_DATA
#undef	CMSG_NXTHDR
#undef	CMSG_FIRSTHDR
#define	IPPROTO_IPV6		kern_IPV6
#undef	IPPROTO_ICMPV6
#  endif	/* LINUXV>=2157 */
#  if	LINUXV>=2170
#define	__cmsg_nxthdr	kern__cmsg_hdr
#  endif	/* LINUXV>=2170 */
#include <netinet/in.h>
/*
 * Some RPC and glibc evasions
 */
#define	itimerval		glibc_itimerval
#define	NFS_RPC_MISMATCH	glibc_NFS_RPC_MISMATCH
#define	NFS_RPC_SUCCESS		glibc_NFS_RPC_SUCCESS
#define	timeval			glibc_timeval
#define	timezone		glibc_timezone
#undef	ITIMER_PROF
#undef	ITIMER_REAL
#undef	ITIMER_VIRTUAL
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#undef	itimerval
#undef	NFS_RPC_MISMATCH
#undef	NFS_RPC_SUCCESS
#undef	timeval
#undef	timezone
# else	/* !defined(GLIBCV) || GLIBCV<2 */


/*
 * Since glibc2 isn't in use, get symbols and structures in a conventional
 * fashion.
 */

#include <linux/in.h>
#include <netinet/protocols.h>
#undef	RPC_MISMATCH
#undef	RPC_SUCCESS
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#define	IPPROTO_TCP	IP_TCP
#define	IPPROTO_UDP	IP_UDP
#define	IPPROTO_ICMP	IP_ICMP
#define	IPPROTO_IGMP	IP_IGMP
#define	IPPROTO_GGP	IP_GGP
#define	IPPROTO_EGP	IP_EGP
#define	IPPROTO_PUP	IP_PUP
#define	IPPROTO_IDP	IP_XNS_IDP
#define	IPPROTO_ND	IP_SUN_ND
# endif	/* defined(GLIBCV) && GLIBCV>=2 */

#include <sys/sysmacros.h>


#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	void
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define QSORT_P		void
#define	READLEN_T	size_t
#define STRNCPY_L	size_t
#define	STRNML		32
#define	XDR_PMAPLIST	(xdrproc_t)xdr_pmaplist
#define	XDR_VOID	(xdrproc_t)xdr_void


/*
 * Global storage definitions (including their structure definitions)
 */

extern int Cfd;
extern struct file *Cfp;
extern int HasNFS;
extern int Kd;

struct nlist_private {
	char *n_name;			/* kernel symbol name */
	int n_type;			/* type: 0 = defined, 1 = undefined */
	unsigned long n_value;		/* address value */
};
#define	NLIST_TYPE	nlist_private
#define	NL_NAME		n_name

struct mounts {
        char *dir;              	/* directory (mounted on) */
	char *fsname;           	/* file system
					 * (symbolic links unresolved) */
	char *fsnmres;           	/* file system
					 * (symbolic links resolved) */
        dev_t dev;              	/* directory st_dev */
	dev_t rdev;			/* directory st_rdev */
	ino_t inode;			/* directory st_ino */
	mode_t mode;			/* directory st_mode */
	mode_t fs_mode;			/* file system st_mode */
	int ty;				/* node type -- e.g., N_REGLR, N_NFS */
        struct mounts *next;    	/* forward link */
};

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	umode_t mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

struct task_struct *Tsp;


/*
 * Definitions for rdev.c
 */

#define	DIRTYPE	dirent

# if	LINUXV<1208
#define HASDNAMLEN	1	/* struct DIRTYPE has d_namlen element */
# endif	/* LINUXV<1208 */


/*
 * Definition for rmnt.c
 */

#define MNTSKIP \
	{ if (strcmp(mp->mnt_type, MNTTYPE_IGNORE) == 0) \
		continue; }

# if	defined(GLIBCV) && GLIBCV>=2

/*
 * Take glibc2 evasions.
 *
 * Because lsof works with Linux kernel structures, it needs access to
 * kernel header files.  Unfortunately glibc2 header files in /usr/include
 * are sometimes incompatible with kernel header files.  Herein we perform
 * some magic to let them coexist.
 *
 * Other more serious hanky-panky takes place in machine.h, before this
 * lsof header file is included.  Less serious glibc2 tomfoolery takes
 * place in dsock.c.
 */

#undef	ITIMER_PROF
#undef	ITIMER_REAL
#undef	ITIMER_VIRTUAL
#define	itimerval		kern_itimerval
#undef	ntohl

#  if	LINUXV>=2100 && LINUXV<2172
#define	timeval			kern_timeval
#  endif	/* LINUXV<2172 */

#define	timezone		kern_timezone
# endif	/* defined(GLIBCV) && GLIBCV>=2 */

#endif	/* LINUX_LSOF_H	*/
