.TH pscolor 5 "July 14 1997" "File Formats"
.SH NAME
pscolor \- color definitions for \fBps\fP(1) and \fBtop\fP(1)
.SH SYNOPSIS
.B /etc/pscolor
.P
.B $HOME/.pscolor
.P
.SH DESCRIPTION
The \fIpscolor\fP file tells \fBpscol\fP(1) to setup the colorization variables
in your shell.
.SH FORMAT
Each line is made up of:
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.br
The config file looks like this:
.P
[COMMON]
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.br
	...
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.P
[PS]
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.br
	...
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.P
[TOP]
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.br
	...
.br
\fItype\fP,\fIdate\fP,\fIcolor\fP
.P
Anything that follows a # sign and blank lines will be ignored.  If you want to
include all of \fBPS\fP in \fBTOP\fP, put \fB=PS\fP under \fB[TOP]\fP.  Same is
true for \fBPS\fP to include \fBTOP\fP.  \fB[COMMON]\fP is just that but you
have to include it using \fB=COMMON\fP (placement usually matters in ps/top).
\fB[COMMON]\fP may not include \fBPS\fP or \fBTOP\fP.  If both \fBPS\fP and
\fBTOP\fP are not present, but \fB[COMMON]\fP is, \fB[COMMON]\fP will become
both.  You can also put \fI#!/usr/bin/pscol\fP at the beginning to use the
color file as a script.
.br
Confusing?  See examples.
.P
\fBtype\fP		\fIdata\fP			description
.br
\fB1/unk\fP				not yet implemented
.br
\fB2/user\fP	\fIuid/name/+\fP	any process belonging to user with uid/name \fIs\fP
.br
\fB3/state\fP	\fIchar state\fP	any process with state \fIs\fP
.br
\fB4/mem\fP	\fI% mem\fP		any process using more than \fIs\fP% phys. memory
.br
\fB5/cpu\fP	\fI% cpu\fP		same as above, but cpu usage
.br
\fB6/size\fP	\fIsize in K\fP		any process alrger than \fIsize\fP k
.br
\fB7/tty\fP	\fItty(char 4)\fP	any process having controlling terminal s
.P
.TP 0.5i
.I unk
Unknown.  This is part of proc ps that wasn't defined.
.TP 0.5i
.I user
Shows processes owned by \fIuser\fP.  \fIuser\fP may be a colon seperated list
of usernames.  If \fIuser\fP is a user name, that user name is converted to a
number.  If \fIuser\fP is a +, it will be replaced by the uid of the person
who ran pscol.
.TP 0.5i
.I state
Shows processes that have state \fIs\fP.  State can be one of:
.br
\fB<\fP Niced process (level < 0, usually privilaged)
.br
\fB>\fP Process exceeded soft limits?
.br
\fBD\fP uniteruptible sleeping (probably \fBD\fPead)
.br
\fBN\fP Niced process (level > 0)
.br
\fBR\fP running processes (You really should go catch it!)
.br
\fBS\fP sleeping processes
.br
\fBT\fP suspended processes
.br
\fBW\fP Swapped out (usually following an \fBS\fP)
.br
\fBZ\fP zombied processes
.TP 0.5i
.I mem
Percentage of memory used.
.TP 0.5i
.I cpu
Percentage of cpu used.
.TP 0.5i
.I size
Any process using more then \fIsize\fPk of ram
.TP 0.5i
.I tty
Any process running on \fItty\fP without /dev and tty.
.br
Examples: 1 p0 C2 S4
.br
\fBNOTE\fP this will segfault \fBps\fP(1) 1.09.  I do not know about other
versions.
.P
Colorization can be done 2 ways.
.br
1: use ANSI codes (leaving off \fBESC\fP[ and the trailing m)
.br
2: use words.
.P
\fBANSI CODES\fP
.br
.TP 0.7i
.B 1
Set high intensity attribute (BOLD)
.TP 0.7i
.B 4
Set underscoring attribute (not all terminals)
.TP 0.7i
.B 5
Set blinking attribute
.TP 0.7i
.B 7
Set reverse video attribute
.TP 0.7i
.B 8
Set concealed attribute (useless)
.TP 0.7i
.B FG BG
.TP 0.7i
.B 30 40
black
.TP 0.7i
.B 31 41
red
.TP 0.7i
.B 32 42
green
.TP 0.7i
.B 33 43
yellow (low intensity yields brown on some terminals)
.TP 0.7i
.B 34 44
blue
.TP 0.7i
.B 35 45
magenta
.TP 0.7i
.B 36 46
cyan
.TP 0.7i
.B 37 47
white
.P
If you'd rather not look at the above EVERYTIME you want to add another color
or to even change a color.  You may want to use the word format:
.br
\fB[\fIblink\fB]\fP \fB[\fIbright\fB]\fP \fIforeground color\fB [\fIon
background color\fB]\fP
.TP 0.9i
.B blink
Sets blinking attribute
.TP 0.9i
.B bright
Sets the hight intensity attribute (BOLD)
.TP 0.9i
.B black
Set color to black (default for background)
.TP 0.9i
.B blue
Set color to blue
.TP 0.9i
.B green
Set color to green
.TP 0.9i
.B cyan
Set color to cyan
.TP 0.9i
.B red
Set color to red
.TP 0.9i
.B magenta
Set color to magenta
.TP 0.9i
.B yellow
Set color to yellow (low intensity yields brown on some terminals)
.TP 0.9i
.B white
Set color to white (default for the foreground)
.P
Each of these can be shortened to only 3 characters.  (Actually, \fIpscol\fP
only reads the first 3 letters of the color, so if you put 'blueiscool' for
the color, \fIpscol\fP will read it as 'blu')
.SH EXAMPLES
See \fIpscolor\fP for an example.  See \fIpscolor.1\fP and \fIpscolor.2\fP for
more examples
.SH AUTHOR
William Thompson, <wakko@ani.ml.org>, <wakko@kite.ml.org>.
.SH SEE ALSO
\fBps\fP(1), \fBps_color\fP(7), \fBpscol\fP(1), \fBtop\fP(1)
