/********************************************************************\
 * Action.h -- the Action data structure                            *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1997 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
\********************************************************************/

#ifndef __XACC_ACTION_H__
#define __XACC_ACTION_H__

#include "config.h"

/* The action types */
enum {
  SELL,
  BUY,
  DIV,          /* dividend                 */
  LTCG,         /* long term capital gains  */
  STCG,         /* short term capital gains */
  DIST,         /* distribution             */
  SPLIT         /* stock split              */
};


/** STRUCTS *********************************************************/
typedef struct _Action {
  /* public data, describes action */
  char      actionType; 
  String    actionName;
  String    actionDescription;

  /* private data, controls display and editing */
} Action;

/** PROTOTYPES ******************************************************/

Action      *mallocAction( void );
void         freeAction( Action *acc );

/** GLOBALS *********************************************************/


#endif /* __XACC_ACTION_H__ */
