/*****
* Parser.h : xmHTMLParserObjectClass public header file
*
* This file Version	$Revision: 1.1 $
*
* Creation date:		Sun Apr 13 00:58:43 GMT+0100 1997
* Last modification: 	$Date: 1997/11/30 05:13:03 $
* By:					$Author: linas $
* Current State:		$State: Exp $
*
* Author:				newt
*
* Copyright (C) 1994-1997 by Ripley Software Development 
* All Rights Reserved
*
* This file is part of the XmHTML Widget Library
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the Free
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/
/*****
* $Source: /home/linas/cvsroot/xacc/lib/XmHTML-1.1.0/src/Parser.h,v $
*****/
/*****
* ChangeLog 
* $Log: Parser.h,v $
* Revision 1.1  1997/11/30 05:13:03  linas
* import XmHTML source for the help widget
*
* Revision 1.1  1997/04/29 14:19:25  newt
* Initial Revision
*
*****/ 

#ifndef _Parser_h_
#define _Parser_h_

/* Required includes */
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <HTML.h>

_XFUNCPROTOBEGIN

typedef struct _XmHTMLParserClassRec *XmHTMLParserObjectClass;
typedef struct _XmHTMLParserRec *XmHTMLParserObject;

externalref WidgetClass xmHTMLParserObjectClass;

/* XmHTMLParser Object subclassing macro */
#ifndef XmIsHTMLParser
#define XmIsHTMLParser(w) XtIsSubclass(w, xmHTMLParserObjectClass)
#endif /* XmIsHTMLParser */

/********    Public Function Declarations    ********/

/* Create a HTML Parser if parent is not null and not a XmHTMLParser itself */
extern Widget XmCreateHTMLParser(Widget parent, String name, ArgList arglist,
    Cardinal argcount);

/* Quick method for enabling/disabling XmNparserCallback honoring */
extern void XmHTMLParserSetAutoMode(Widget w, Boolean set);

/* Quick method for enabling/disabling XmNparserIsProgressive resource */
extern void XmHTMLParserSetProgressiveMode(Widget w, Boolean set);

/*****
* Set and parse a new HTML source. Resets and clears any old source.
* When source is NULL, any existing source and parser tree is cleared.
*****/
extern Boolean XmHTMLParserSetString(Widget w, String source);

/*****
* Update the current HTML source when in progressive mode and start
* parsing the new part. Returns True when successfully set and parsed,
*
* Returns False if parser isn't in progressive mode, the new source matches
* the old source exactly, the new source is smaller than the current source,
* the lower part of the old source doesn't match the current source or when
* the new source is NULL.
* When returning False, this function also calls any installed 
* XmNdocumentCallback callback resources.
*****/
extern Boolean XmHTMLParserUpdateSource(Widget w, String source);

/* Perform parser wrapup and call any installed XmNdocumentCallbacks */
extern Boolean XmHTMLParserEndSource(Widget w);

/* expand all character escape sequences in the given text */
extern void XmHTMLParserExpandEscapes(String source);

/*****
* Terminate the current parsing process. Calls any installed
* XmNdocumentCallback callback resources with the Terminated field set to True.
*****/
extern void XmHTMLParserTerminateSource(Widget w);

/* Get the original source text */
extern String XmHTMLParserGetSource(Widget w); 

/* Create a HTML source from the parser tree */
extern String XmHTMLParserGetString(Widget w);

/* Return the generated parser tree. May never be freed. */
extern XmHTMLObject *XmHTMLParserGetTree(Widget w);

/*****
* Unknown HTML alias table routines 
* All routines that return an alias table return a copy of the requested
* alias table which must be freed by the caller.
* All routines that install an alias or alias table make a copy of the table
* or alias to be installed.
*****/
/* sets an alias table in the given parser. */
extern int XmHTMLParserSetAliasTable(Widget w, XmHTMLAliasTable alias_table,
	int nalias);

/* returns the current alias table of the given parser. */
extern XmHTMLAliasTable XmHTMLParserGetAliasTable(Widget w, int *nalias);

/* add a single alias to the alias table of a parser */
extern Boolean XmHTMLParserAddAlias(Widget w, String element, htmlEnum alias);

/* remove an alias from the alias table of a parser. */
extern Boolean XmHTMLParserRemoveAlias(Widget w, String element,
	htmlEnum alias);

/* free the alias table of a parser */
extern void XmHTMLParserFreeAliasTable(Widget w);

/* Return a copy the global alias table used by all parsers */
extern XmHTMLAliasTable XmHTMLGetGlobalAliasTable(int *nalias);

/* free the given alias table */
extern void XmHTMLParserDestroyAliasTable(XmHTMLAliasTable table, int nalias);

_XFUNCPROTOEND

/* Don't add anything after this endif! */
#endif /* _Parser_h_ */
