//  
//  Copyright (c) 1994, 1995 by Mike Romberg ( romberg@fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//
//
// $Id: MeterMaker.cc,v 1.10 1997/03/15 21:03:03 mromberg Exp $
//
#include "MeterMaker.h"
#include "xosview.h"

#include "cpumeter.h"
#include "memmeter.h"
#include "swapmeter.h"
#include "pagemeter.h"
#include "netmeter.h"
#include "intmeter.h"
#include "serialmeter.h"
#include "loadmeter.h"
#include "btrymeter.h"

#include <stdlib.h>


MeterMaker::MeterMaker(XOSView *xos){
  _xos = xos;
}

void MeterMaker::makeMeters(void){
  // check for the load meter
  if (_xos->isResourceTrue("load"))
    push(new LoadMeter(_xos));

  // Standard meters (usually added, but users could turn them off)
  if (_xos->isResourceTrue("cpu"))
    push(new CPUMeter(_xos));
  if (_xos->isResourceTrue("mem"))
    push(new MemMeter(_xos));
  if (_xos->isResourceTrue("swap"))
    push(new SwapMeter(_xos));
  
  if (_xos->isResourceTrue("page"))
    push(new PageMeter(_xos, atof(_xos->getResource("pageBandwidth"))));

  // check for the net meter
  if (_xos->isResourceTrue("net"))
    push(new NetMeter(_xos, atof(_xos->getResource("netBandwidth"))));

  // check for the serial meters.
  for (int i = 0 ; i < SerialMeter::numDevices() ; i++)
    if (strcmp(_xos->getResource(
      SerialMeter::getResourceName((SerialMeter::Device)i)), "False"))
      push(new SerialMeter(_xos, (SerialMeter::Device)i));

  // check for the interrupt meter
  if (_xos->isResourceTrue("interrupts"))
    push(new IntMeter(_xos));

  if (_xos->isResourceTrue("battery"))
    push(new BtryMeter(_xos));
}
