# define Y_EOF 257
# define Y_NL 258
# define Y_INT 259
# define Y_ID 260
# define Y_REG 261
# define Y_FP_REG 262
# define Y_STR 263
# define Y_FP 264
# define Y_ABS_D_OP 265
# define Y_ABS_S_OP 266
# define Y_ADDIU_OP 267
# define Y_ADDI_OP 268
# define Y_ADDU_OP 269
# define Y_ADD_D_OP 270
# define Y_ADD_OP 271
# define Y_ADD_S_OP 272
# define Y_ANDI_OP 273
# define Y_AND_OP 274
# define Y_BC0F_OP 275
# define Y_BC0T_OP 276
# define Y_BC1F_OP 277
# define Y_BC1T_OP 278
# define Y_BC2F_OP 279
# define Y_BC2T_OP 280
# define Y_BC3F_OP 281
# define Y_BC3T_OP 282
# define Y_BEQ_OP 283
# define Y_BGEZAL_OP 284
# define Y_BGEZ_OP 285
# define Y_BGTZ_OP 286
# define Y_BLEZ_OP 287
# define Y_BLTZAL_OP 288
# define Y_BLTZ_OP 289
# define Y_BNE_OP 290
# define Y_BREAK_OP 291
# define Y_CFC0_OP 292
# define Y_CFC1_OP 293
# define Y_CFC2_OP 294
# define Y_CFC3_OP 295
# define Y_COP0_OP 296
# define Y_COP1_OP 297
# define Y_COP2_OP 298
# define Y_COP3_OP 299
# define Y_CTC0_OP 300
# define Y_CTC1_OP 301
# define Y_CTC2_OP 302
# define Y_CTC3_OP 303
# define Y_CVT_D_S_OP 304
# define Y_CVT_D_W_OP 305
# define Y_CVT_S_D_OP 306
# define Y_CVT_S_W_OP 307
# define Y_CVT_W_D_OP 308
# define Y_CVT_W_S_OP 309
# define Y_C_EQ_D_OP 310
# define Y_C_EQ_S_OP 311
# define Y_C_F_D_OP 312
# define Y_C_F_S_OP 313
# define Y_C_LE_D_OP 314
# define Y_C_LE_S_OP 315
# define Y_C_LT_D_OP 316
# define Y_C_LT_S_OP 317
# define Y_C_NGE_D_OP 318
# define Y_C_NGE_S_OP 319
# define Y_C_NGLE_D_OP 320
# define Y_C_NGLE_S_OP 321
# define Y_C_NGL_D_OP 322
# define Y_C_NGL_S_OP 323
# define Y_C_NGT_D_OP 324
# define Y_C_NGT_S_OP 325
# define Y_C_OLT_D_OP 326
# define Y_C_OLT_S_OP 327
# define Y_C_OLE_D_OP 328
# define Y_C_OLE_S_OP 329
# define Y_C_SEQ_D_OP 330
# define Y_C_SEQ_S_OP 331
# define Y_C_SF_D_OP 332
# define Y_C_SF_S_OP 333
# define Y_C_UEQ_D_OP 334
# define Y_C_UEQ_S_OP 335
# define Y_C_ULT_D_OP 336
# define Y_C_ULT_S_OP 337
# define Y_C_ULE_D_OP 338
# define Y_C_ULE_S_OP 339
# define Y_C_UN_D_OP 340
# define Y_C_UN_S_OP 341
# define Y_DIVU_OP 342
# define Y_DIV_D_OP 343
# define Y_DIV_OP 344
# define Y_DIV_S_OP 345
# define Y_JALR_OP 346
# define Y_JAL_OP 347
# define Y_JR_OP 348
# define Y_J_OP 349
# define Y_LBU_OP 350
# define Y_LB_OP 351
# define Y_LHU_OP 352
# define Y_LH_OP 353
# define Y_LUI_OP 354
# define Y_LWC0_OP 355
# define Y_LWC1_OP 356
# define Y_LWC2_OP 357
# define Y_LWC3_OP 358
# define Y_LWL_OP 359
# define Y_LWR_OP 360
# define Y_LW_OP 361
# define Y_MFC0_OP 362
# define Y_MFC1_OP 363
# define Y_MFC2_OP 364
# define Y_MFC3_OP 365
# define Y_MFHI_OP 366
# define Y_MFLO_OP 367
# define Y_MOV_D_OP 368
# define Y_MOV_S_OP 369
# define Y_MTC0_OP 370
# define Y_MTC1_OP 371
# define Y_MTC2_OP 372
# define Y_MTC3_OP 373
# define Y_MTHI_OP 374
# define Y_MTLO_OP 375
# define Y_MULTU_OP 376
# define Y_MULT_OP 377
# define Y_MUL_D_OP 378
# define Y_MUL_S_OP 379
# define Y_NEG_D_OP 380
# define Y_NEG_S_OP 381
# define Y_NOR_OP 382
# define Y_ORI_OP 383
# define Y_OR_OP 384
# define Y_PFW_OP 385
# define Y_RFE_OP 386
# define Y_SB_OP 387
# define Y_SH_OP 388
# define Y_SLLV_OP 389
# define Y_SLL_OP 390
# define Y_SLTIU_OP 391
# define Y_SLTI_OP 392
# define Y_SLTU_OP 393
# define Y_SLT_OP 394
# define Y_SRAV_OP 395
# define Y_SRA_OP 396
# define Y_SRLV_OP 397
# define Y_SRL_OP 398
# define Y_SUBU_OP 399
# define Y_SUB_D_OP 400
# define Y_SUB_OP 401
# define Y_SUB_S_OP 402
# define Y_SWC0_OP 403
# define Y_SWC1_OP 404
# define Y_SWC2_OP 405
# define Y_SWC3_OP 406
# define Y_SWL_OP 407
# define Y_SWR_OP 408
# define Y_SW_OP 409
# define Y_SYSCALL_OP 410
# define Y_TLBP_OP 411
# define Y_TLBR_OP 412
# define Y_TLBWI_OP 413
# define Y_TLBWR_OP 414
# define Y_XORI_OP 415
# define Y_XOR_OP 416
# define Y_ABS_POP 417
# define Y_BAL_POP 418
# define Y_BEQZ_POP 419
# define Y_BGEU_POP 420
# define Y_BGE_POP 421
# define Y_BGTU_POP 422
# define Y_BGT_POP 423
# define Y_BLEU_POP 424
# define Y_BLE_POP 425
# define Y_BLTU_POP 426
# define Y_BLT_POP 427
# define Y_BNEZ_POP 428
# define Y_B_POP 429
# define Y_LA_POP 430
# define Y_LD_POP 431
# define Y_LI_POP 432
# define Y_LI_D_POP 433
# define Y_LI_S_POP 434
# define Y_L_D_POP 435
# define Y_L_S_POP 436
# define Y_MFC1_D_POP 437
# define Y_MTC1_D_POP 438
# define Y_MOVE_POP 439
# define Y_MULOU_POP 440
# define Y_MULO_POP 441
# define Y_MUL_POP 442
# define Y_NEGU_POP 443
# define Y_NEG_POP 444
# define Y_NOP_POP 445
# define Y_NOT_POP 446
# define Y_REMU_POP 447
# define Y_REM_POP 448
# define Y_ROL_POP 449
# define Y_ROR_POP 450
# define Y_SD_POP 451
# define Y_SEQ_POP 452
# define Y_SGEU_POP 453
# define Y_SGE_POP 454
# define Y_SGTU_POP 455
# define Y_SGT_POP 456
# define Y_SLEU_POP 457
# define Y_SLE_POP 458
# define Y_SNE_POP 459
# define Y_S_D_POP 460
# define Y_S_S_POP 461
# define Y_ULHU_POP 462
# define Y_ULH_POP 463
# define Y_ULW_POP 464
# define Y_USH_POP 465
# define Y_USW_POP 466
# define Y_ALIAS_DIR 467
# define Y_ALIGN_DIR 468
# define Y_ASCII_DIR 469
# define Y_ASCIIZ_DIR 470
# define Y_ASM0_DIR 471
# define Y_BGNB_DIR 472
# define Y_BYTE_DIR 473
# define Y_COMM_DIR 474
# define Y_DATA_DIR 475
# define Y_DOUBLE_DIR 476
# define Y_ENDB_DIR 477
# define Y_ENDR_DIR 478
# define Y_END_DIR 479
# define Y_ENT_DIR 480
# define Y_ERR_DIR 481
# define Y_EXTERN_DIR 482
# define Y_FILE_DIR 483
# define Y_FLOAT_DIR 484
# define Y_FMASK_DIR 485
# define Y_FRAME_DIR 486
# define Y_GLOBAL_DIR 487
# define Y_HALF_DIR 488
# define Y_K_TEXT_DIR 489
# define Y_K_DATA_DIR 490
# define Y_LABEL_DIR 491
# define Y_LCOMM_DIR 492
# define Y_LIVEREG_DIR 493
# define Y_LOC_DIR 494
# define Y_MASK_DIR 495
# define Y_NOALIAS_DIR 496
# define Y_OPTIONS_DIR 497
# define Y_RDATA_DIR 498
# define Y_REPEAT_DIR 499
# define Y_SDATA_DIR 500
# define Y_SET_DIR 501
# define Y_SPACE_DIR 502
# define Y_STRUCT_DIR 503
# define Y_TEXT_DIR 504
# define Y_VERSTAMP_DIR 505
# define Y_VREG_DIR 506
# define Y_WORD_DIR 507

# line 294 "parser.y"
#include <stdio.h>

#include "spim.h"
#include "spim-utils.h"
#include "inst.h"
#include "mem.h"
#include "reg.h"
#include "sym-tbl.h"
#include "data.h"
#include "scanner.h"
#include "parser.h"


/* return (0) */
#define LINE_PARSE_DONE YYACCEPT

/* return (1) */
#define FILE_PARSE_DONE YYABORT

typedef struct ll
{
  label *head;
  struct ll *tail;
} label_list;


/* Exported Variables: */

int data_dir;			/* Non-zero means item in data segment */

int text_dir;			/* Non-zero means item in text segment */

int parse_error_occurred;  /* Non-zero => parse resulted in error */


/* Local functions: */

#ifdef __STDC__
static imm_expr *branch_offset (int n_inst);
static void clear_labels (void);
static label_list *cons_label (label *head, label_list *tail);
static void div_inst (int op, int rd, int rs, int rt, int const_divisor);
static void mult_inst (int op, int rd, int rs, int rt);
static void nop_inst (void);
static void set_eq_inst (int op, int rd, int rs, int rt);
static void set_ge_inst (int op, int rd, int rs, int rt);
static void set_gt_inst (int op, int rd, int rs, int rt);
static void set_le_inst (int op, int rd, int rs, int rt);
static void store_word_data (int value);
static void trap_inst (void);
#else
static imm_expr *branch_offset ();
static void clear_labels ();
static label_list *cons_label ();
static void div_inst ();
static void mult_inst ();
static void nop_inst ();
static void set_eq_inst ();
static void set_ge_inst ();
static void set_gt_inst ();
static void set_le_inst ();
static void store_word_data ();
static void trap_inst ();
#endif


/* Local variables: */

static int null_term;		/* Non-zero means string terminate by \0 */

static void (*store_op) ();	/* Function to store items in an EXPR_LST */

static label_list *this_line_labels = NULL; /* List of label for curent line */

static int noat_flag = 0;	/* Non-zero means program can use $1 */

static char *input_file_name;	/* Name of file being parsed */



#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 2049 "parser.y"


/* Maintain and update the address of labels for the current line. */

#ifdef __STDC__
void
fix_current_label_address (mem_addr new_addr)
#else
void
fix_current_label_address (new_addr)
     mem_addr new_addr;
#endif
{
  label_list *l;

  for (l = this_line_labels; l != NULL; l = l->tail)
    {
      l->head->addr = new_addr;
    }
  clear_labels ();
}


#ifdef __STDC__
static label_list *
cons_label (label *head, label_list *tail)
#else
static label_list *
cons_label (head, tail)
     label *head;
     label_list *tail;
#endif
{
  label_list *c = (label_list *) malloc (sizeof (label_list));

  c->head = head;
  c->tail = tail;
  return (c);
}


#ifdef __STDC__
static void
clear_labels (void)
#else
static void
clear_labels ()
#endif
{
  label_list *n;

  for ( ; this_line_labels != NULL; this_line_labels = n)
    {
      resolve_label_uses(this_line_labels->head);
      n = this_line_labels->tail;
      free (this_line_labels);
    }
}


/* Operations on op codes. */

#ifdef __STDC__
int
op_to_imm_op (int opcode)
#else
int
op_to_imm_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADD_OP: return (Y_ADDI_OP);
    case Y_ADDU_OP: return (Y_ADDIU_OP);
    case Y_AND_OP: return (Y_ANDI_OP);
    case Y_OR_OP: return (Y_ORI_OP);
    case Y_XOR_OP: return (Y_XORI_OP);
    case Y_SLT_OP: return (Y_SLTI_OP);
    case Y_SLTU_OP: return (Y_SLTIU_OP);
    case Y_SLLV_OP: return (Y_SLL_OP);
    case Y_SRAV_OP: return (Y_SRA_OP);
    case Y_SRLV_OP: return (Y_SRL_OP);
    default: fatal_error ("Can't convert op to immediate op\n"); return (0);
    }
}


#ifdef __STDC__
int
imm_op_to_op (int opcode)
#else
int
imm_op_to_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADDI_OP: return (Y_ADD_OP);
    case Y_ADDIU_OP: return (Y_ADDU_OP);
    case Y_ANDI_OP: return (Y_AND_OP);
    case Y_ORI_OP: return (Y_OR_OP);
    case Y_XORI_OP: return (Y_XOR_OP);
    case Y_SLTI_OP: return (Y_SLT_OP);
    case Y_SLTIU_OP: return (Y_SLTU_OP);
    case Y_J_OP: return (Y_JR_OP);
    case Y_LUI_OP: return (Y_ADDU_OP);
    case Y_SLL_OP: return (Y_SLLV_OP);
    case Y_SRA_OP: return (Y_SRAV_OP);
    case Y_SRL_OP: return (Y_SRLV_OP);
    default: fatal_error ("Can't convert immediate op to op\n"); return (0);
    }
}


#ifdef __STDC__
static void
nop_inst (void)
#else
static void
nop_inst ()
#endif
{
  r_type_inst (Y_OR_OP, 0, 0, 0);
}


#ifdef __STDC__
static void
trap_inst (void)
#else
static void
trap_inst ()
#endif
{
  r_type_inst (Y_BREAK_OP, 0, 0, 0);
}


#ifdef __STDC__
static imm_expr *
branch_offset (int n_inst)
#else
static imm_expr *
branch_offset (n_inst)
     int n_inst;
#endif
{
  return (const_imm_expr (n_inst << 2)); /* Later shifted right 2 places */
}


#ifdef __STDC__
static void
div_inst (int op, int rd, int rs, int rt, int const_divisor)
#else
static void
div_inst (op, rd, rs, rt, const_divisor)
     int op, rd, rs, rt, const_divisor;
#endif
{
  if (rd != 0 && !const_divisor)
    {
      i_type_inst_free (Y_BNE_OP, 0, rt, branch_offset (2));
      trap_inst ();
    }
  if (op == Y_DIV_OP || op == Y_REM_POP)
    r_type_inst (Y_DIV_OP, 0, rs, rt);
  else
    r_type_inst (Y_DIVU_OP, 0, rs, rt);
  if (rd != 0)
    {
      if (op == Y_DIV_OP || op == Y_DIVU_OP)
	r_type_inst (Y_MFLO_OP, rd, 0, 0);
      else
	r_type_inst (Y_MFHI_OP, rd, 0, 0);
    }
}


#ifdef __STDC__
static void
mult_inst (int op, int rd, int rs, int rt)
#else
static void
mult_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  if (op == Y_MULOU_POP)
    r_type_inst (Y_MULTU_OP, 0, rs, rt);
  else
    r_type_inst (Y_MULT_OP, 0, rs, rt);
  if (op == Y_MULOU_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0);	/* Use $at */
      i_type_inst_free (Y_BEQ_OP, 0, 1, branch_offset (2));
      trap_inst ();
    }
  else if (op == Y_MULO_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0); /* use $at */
      r_type_inst (Y_MFLO_OP, rd, 0, 0);
      r_sh_type_inst (Y_SRA_OP, rd, rd, 31);
      i_type_inst_free (Y_BEQ_OP, rd, 1, branch_offset (2));
      trap_inst ();
    }
  if (rd != 0)
    r_type_inst (Y_MFLO_OP, rd, 0, 0);
}


#ifdef __STDC__
static void
set_le_inst (int op, int rd, int rs, int rt)
#else
static void
set_le_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst_free (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst_free (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst ((op == Y_SLE_POP ? Y_SLT_OP : Y_SLTU_OP), rd, rs, rt);
}


#ifdef __STDC__
static void
set_gt_inst (int op, int rd, int rs, int rt)
#else
static void
set_gt_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  r_type_inst (op == Y_SGT_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_ge_inst (int op, int rd, int rs, int rt)
#else
static void
set_ge_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst_free (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst_free (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst (op == Y_SGE_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_eq_inst (int op, int rd, int rs, int rt)
#else
static void
set_eq_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  imm_expr *if_eq, *if_neq;

  if (op == Y_SEQ_POP)
    if_eq = const_imm_expr (1), if_neq = const_imm_expr (0);
  else
    if_eq = const_imm_expr (0), if_neq = const_imm_expr (1);

  i_type_inst_free (Y_BEQ_OP, rs, rt, branch_offset (3));
  /* RD <- 0 (if not equal) */
  i_type_inst_free (Y_ORI_OP, rd, 0, if_neq);
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2)); /* Branch always */
  /* RD <- 1 */
  i_type_inst_free (Y_ORI_OP, rd, 0, if_eq);
}


/* Store the value either as a datum or instruction. */

#ifdef __STDC__
static void
store_word_data (int value)
#else
static void
store_word_data (value)
     int value;
#endif
{
  if (data_dir)
    store_word (value);
  else if (text_dir)
    store_instruction (inst_decode (value));
}



#ifdef __STDC__
void
initialize_parser (char *file_name)
#else
void
initialize_parser (file_name)
     char *file_name;
#endif
{
  input_file_name = file_name;
  only_id = 0;
  data_dir = 0;
  text_dir = 1;
}


#ifdef __STDC__
void
yyerror (char *s)
#else
void
yyerror (s)
     char *s;
#endif
{
  parse_error_occurred = 1;
  error ("spim: (parser) %s on line %d of file %s\n",
	 s, line_no, input_file_name);
  print_erroneous_line ();
}
static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 353,
	261, 356,
	-2, 354,
-1, 379,
	260, 384,
	-2, 383,
-1, 485,
	259, 371,
	260, 371,
	-2, 285,
-1, 499,
	259, 371,
	260, 371,
	-2, 307,
-1, 507,
	259, 371,
	260, 371,
	-2, 330,
	};
# define YYNPROD 386
# define YYLAST 845
static const yytabelem yyact[]={

   111,   110,   414,   486,   476,   482,   413,   489,   241,   240,
   155,   154,   145,   243,   144,   242,   156,   146,   188,   184,
   189,   185,   190,   186,   191,   187,   200,   193,   192,   194,
   195,   197,   196,   201,    27,   232,   233,   234,   235,   485,
   481,   561,   490,   236,   237,   238,   239,   250,   251,   252,
   253,   254,   255,   276,   260,   274,   258,   288,   272,   286,
   270,   287,   271,   283,   267,   285,   269,   289,   273,   278,
   262,   279,   263,   284,   268,   282,   266,   277,   261,   280,
   264,   281,   265,   275,   259,   168,   245,   167,   244,   213,
   212,   211,   210,   113,   112,   115,   114,   124,   121,   127,
   122,   123,   117,   118,   116,   222,   223,   225,   226,   218,
   219,   217,   216,   227,   228,   230,   231,   220,   221,   175,
   174,   247,   246,   257,   256,   164,   157,   148,   120,   142,
   130,   131,   151,   161,   160,   159,   150,   149,   152,   162,
   153,   163,   166,   249,   165,   248,   136,   139,   137,   138,
   133,   134,   132,   143,     9,   367,   415,   460,   158,   147,
    29,   215,   198,   205,   204,   203,   202,   209,   208,   207,
   206,   199,   214,    14,   119,    15,    16,    17,   129,   128,
   224,   229,    33,   173,   172,   171,    31,    30,    28,    32,
   170,   169,    44,    43,   135,   182,   181,   180,   179,   178,
   177,   176,   183,   141,   140,   126,   125,    18,    24,    23,
    69,    70,    71,    72,    73,    74,    75,    76,    77,    79,
    81,    82,    80,    83,    85,    84,    86,    87,    88,    89,
    90,    91,   106,    78,    92,    93,    94,    95,    96,    97,
    98,   100,    99,   101,   102,   103,   104,   105,   107,   108,
   109,   334,   410,   306,   422,   396,   421,   483,   416,   400,
   401,     6,   495,   297,   317,   297,   297,   297,   300,   301,
   297,   297,   307,   313,   415,   313,   313,   509,   522,   318,
   298,   297,   297,   297,   297,   297,   297,   297,   297,   297,
   297,   297,   297,   297,   298,   297,   297,   297,   297,   297,
   297,   520,   439,   298,   298,   504,   341,   480,   342,   353,
   394,   420,   357,   357,   357,   366,   342,   342,   515,   295,
   590,   418,   318,   575,   574,   573,   563,   368,   506,   369,
   505,   299,   437,   365,   441,   374,   444,   446,   503,   502,
   501,   386,   381,   382,   498,   333,   497,   493,   407,   387,
   404,   389,   390,   403,   314,   111,   110,   395,   369,   402,
   405,   399,   369,   369,   350,   354,   398,   397,   393,   478,
   479,   392,   391,   385,   383,   418,   417,   298,   380,   376,
   375,   372,   319,   587,   582,   291,   559,   449,   292,   557,
   565,   355,   496,   566,   356,   360,   343,   344,   345,   346,
   347,   348,   349,   351,   305,   567,   586,   513,   568,   514,
   569,   592,   484,   591,   510,   584,   583,   576,   512,   570,
   585,     5,   308,    10,   491,   311,   290,   379,   499,   487,
   461,   508,   411,   406,   388,   384,   378,   377,   373,   371,
   312,   370,    68,   518,    67,    66,   507,   521,   408,   409,
   525,    65,   527,    64,   529,   531,   358,   359,   533,   535,
   537,   539,   541,   543,   315,   316,    63,    62,   546,   361,
   362,   363,   364,    61,    60,    59,    58,   352,    57,    56,
   555,    55,    54,    53,    52,    51,    50,   556,    49,   558,
   556,    48,    47,   418,   417,    46,   418,   511,    45,    42,
    41,    40,    39,   558,   463,   465,   467,   469,    38,    37,
    36,   558,    35,    34,    26,    25,   571,   572,    22,    21,
    20,    19,    13,    12,    11,   294,     8,   293,     7,     4,
   488,     3,     2,     1,   516,     0,     0,     0,   494,     0,
     0,     0,     0,     0,     0,     0,   500,     0,     0,     0,
     0,     0,   412,     0,     0,     0,   419,     0,     0,     0,
     0,     0,   423,   424,   425,   426,     0,   427,   428,   429,
   430,   580,   581,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   450,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   450,   450,   450,
   450,   450,   342,   342,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   318,   318,   477,   477,   477,
     0,     0,     0,     0,     0,     0,   474,   475,     0,     0,
     0,     0,     0,   369,     0,     0,     0,     0,   492,     0,
     0,   369,     0,   560,     0,     0,     0,     0,     0,   369,
   457,   458,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   431,   432,   433,   434,
   435,   436,   438,   440,   442,   443,   445,   447,   448,     0,
     0,   451,   452,   453,   454,   455,   456,   471,   450,     0,
   450,   472,   473,     0,   450,   450,     0,   450,   470,   450,
   450,     0,     0,   450,   450,   450,   450,   450,   450,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   342,   342,
     0,   342,   342,   342,   342,   342,   342,   342,   342,   477,
     0,     0,     0,   459,   462,   464,   466,   468,     0,     0,
     0,     0,     0,     0,     0,     0,   369,     0,     0,     0,
   562,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   564,     0,   296,     0,     0,   544,   545,     0,   547,
   548,   549,   550,   551,   552,   553,   554,   302,   303,   304,
     0,     0,   309,   310,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   320,   321,   322,   323,   324,   325,   326,
   327,   328,   329,   330,   331,   332,     0,   335,   336,   337,
   338,   339,   340,     0,     0,     0,     0,   577,     0,   579,
     0,     0,     0,     0,   517,   578,   519,     0,     0,     0,
   523,   524,     0,   526,     0,   528,   530,   588,   589,   532,
   534,   536,   538,   540,   542 };
static const yytabelem yypact[]={

-10000000,-10000000,  -257,-10000000,  -257,-10000000,   327,-10000000,-10000000,-10000000,
    59,    33,     7,    33,    33,    33,    10,    10,    33,    33,
    10,    33,     7,    33,    33,    10,-10000000,   123,-10000000,    33,
    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,
    33,    33,    33,    33,    33,    33,    33,    33,    33,-10000000,
    33,    33,    33,    33,    33,    33,    33,    33,-10000000,     7,
    33,    33,    33,     7,    10,    10,    10,    10,    10,    54,
    68,-10000000,-10000000,-10000000,   122,-10000000,-10000000,   121,   120,-10000000,
-10000000,   119,-10000000,-10000000,-10000000,-10000000,   115,-10000000,   114,    33,
-10000000,-10000000,-10000000,-10000000,   113,   112,   109,    49,-10000000,    68,
   108,   107,-10000000,    68,    68,   100,    94,    91,    33,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,    89,    98,    98,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   234,-10000000,   234,    -8,-10000000,-10000000,   -10,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
    33,    33,    33,    33,    33,   116,    43,   116,    33,   116,
   116,    33,    33,    33,-10000000,    33,    33,    33,    33,    33,
    33,-10000000,-10000000,-10000000,-10000000,    33,    33,    33,    33,    33,
-10000000,-10000000,    33,-10000000,-10000000,     7,-10000000,-10000000,-10000000,     7,
     7,    10,    10,    10,    10,    10,    46,-10000000,-10000000,-10000000,
    -6,    -6,-10000000,-10000000,    68,-10000000,-10000000,  -222,-10000000,-10000000,
-10000000,    88,    68,    -1,  -222,    87,    85,-10000000,-10000000,-10000000,
    68,    81,    80,    79,    44,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,    71,    69,-10000000,-10000000,-10000000,-10000000,
-10000000,   237,-10000000,-10000000,-10000000,    62,-10000000,   364,   275,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,   116,-10000000,    42,-10000000,
   234,-10000000,    19,   116,-10000000,   116,-10000000,   116,   116,-10000000,
-10000000,   116,   116,   116,   116,   116,   116,-10000000,-10000000,-10000000,
-10000000,   234,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,    10,-10000000,-10000000,-10000000,-10000000,
-10000000,    -6,-10000000,   331,    -6,-10000000,   328,    68,-10000000,  -223,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -223,-10000000,    33,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,    67,-10000000,-10000000,    33,
   350,   365,   378,    62,    62,    66,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,    65,-10000000,    64,
-10000000,-10000000,-10000000,-10000000,   376,    33,-10000000,    33,    62,    62,
   322,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,   375,-10000000,   374,
   380,   366,   321,-10000000,-10000000,    33,    33,    61,   372,   370,
-10000000,-10000000,-10000000 };
static const yytabelem yypgo[]={

     0,   533,   532,   531,   529,   421,   258,   528,   527,   154,
   526,   525,   524,   763,   252,   523,   331,   522,     6,   404,
   521,   520,   519,   440,   518,   515,   264,   514,   345,   513,
   387,   512,   510,   509,   508,   502,   501,   500,   499,   498,
   495,   492,   491,   488,   306,   486,   485,   484,   157,   483,
   482,   481,   479,   478,   477,   476,   475,   474,   394,   473,
   467,   466,   453,   451,     4,   445,   444,   442,   155,   441,
    40,   439,   438,    39,   437,     7,   436,   435,   251,   434,
   433,   432,   431,     2,   430,   253,     5,     3,   429,   427,
   424,   423 };
static const yytabelem yyr1[]={

     0,     2,     1,     3,     3,     4,     4,     8,     5,    11,
     5,     5,     9,     9,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    15,    15,    15,
    17,    20,    20,    21,    21,    21,    22,    22,    22,    22,
    22,    22,    24,    24,    24,    25,    25,    25,    27,    27,
    29,    29,    29,    29,    29,    29,    29,    31,    31,    31,
    32,    32,    32,    32,    32,    32,    32,    33,    33,    33,
    34,    35,    35,    36,    36,    36,    36,    37,    37,    37,
    39,    39,    40,    40,    41,    41,    42,    42,    38,    38,
    43,    43,    43,    43,    43,    43,    43,    43,    45,    45,
    45,    45,    45,    45,    46,    46,    47,    47,    49,    49,
    50,    50,    51,    51,    52,    52,    53,    53,    53,    53,
    55,    55,    56,    56,    57,    57,    59,    59,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    61,    61,
    61,    61,    61,    61,    61,    61,    62,    62,    63,    63,
    63,    63,    63,    63,    63,    63,    65,    65,    65,    65,
    65,    65,    66,    66,    67,    67,    67,    67,    67,    67,
    67,    67,    67,    67,    67,    67,    67,    67,    67,    67,
    67,    67,    67,    67,    67,    67,    67,    67,    67,    67,
    67,    67,    67,    67,    67,    67,    10,    10,    69,    10,
    71,    10,    10,    10,    72,    10,    10,    10,    10,    10,
    10,    74,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    77,    10,    10,    10,    10,    79,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    80,
    10,    81,    14,    82,    82,    82,    82,    82,    82,    82,
    82,    82,    82,    84,    48,    18,    18,    18,    18,    18,
    83,    83,    83,    13,    28,    30,    54,    58,    23,    78,
    19,    26,    64,    85,    16,    16,    44,    70,    70,    86,
    86,    88,    87,    68,    68,    73,    73,    73,    75,    75,
    89,    76,    90,    90,    91,     6 };
static const yytabelem yyr2[]={

     0,     1,     4,     4,     2,     5,     7,     1,     6,     1,
     6,     2,     3,     3,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     3,
     5,     3,     7,     7,     7,     7,     7,     9,     9,     7,
     9,     9,     7,     9,     7,     9,     9,     9,     9,     7,
     9,     9,     7,     7,     9,     9,     9,     9,     7,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     9,     5,     7,     7,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     5,     5,     7,     5,     7,     5,
     5,     7,     7,     7,     9,     7,     7,     7,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     6,     5,     1,     7,
     1,     7,     2,     4,     1,     7,     7,     3,     5,     3,
     5,     1,     7,     4,     4,     2,     4,     6,     7,     3,
     6,     1,     7,     6,     8,     5,     1,     7,     5,     7,
     6,     6,     6,     6,     4,     5,     3,     5,     3,     5,
     5,     5,     5,     3,     5,     3,     5,     6,     8,     1,
     6,     1,     5,     7,     3,     9,     3,     9,     7,     7,
     7,    13,    13,     1,     5,     3,    13,     3,     7,     7,
     2,     7,     5,     2,     2,     2,     2,     2,     2,     3,
     2,     2,     2,     3,     2,     2,     3,     4,     2,     3,
     7,     1,     5,     2,     3,     5,     3,     7,     5,     3,
     1,     5,     2,     1,     1,     5 };
static const yytabelem yychk[]={

-10000000,    -1,    -2,    -3,    -4,    -5,    -6,    -7,   -10,    -9,
   -91,   -12,   -15,   -17,   430,   432,   433,   434,   464,   -20,
   -21,   -22,   -24,   466,   465,   -25,   -27,   291,   445,   417,
   444,   443,   446,   439,   -29,   -31,   -32,   -33,   -34,   -35,
   -36,   -37,   -38,   450,   449,   -39,   -40,   -41,   -42,   -43,
   -45,   -46,   -47,   -49,   -50,   -51,   -52,   -53,   -55,   -56,
   -57,   -59,   -60,   -61,   -62,   -63,   -65,   -66,   -67,   467,
   468,   469,   470,   471,   472,   473,   474,   475,   490,   476,
   479,   477,   478,   480,   482,   481,   483,   484,   485,   486,
   487,   488,   491,   492,   493,   494,   495,   496,   497,   499,
   498,   500,   501,   502,   503,   504,   489,   505,   506,   507,
   258,   257,   351,   350,   353,   352,   361,   359,   360,   431,
   385,   355,   357,   358,   354,   463,   462,   356,   436,   435,
   387,   388,   409,   407,   408,   451,   403,   405,   406,   404,
   461,   460,   386,   410,   271,   269,   274,   416,   384,   394,
   393,   389,   395,   397,   268,   267,   273,   383,   415,   392,
   391,   390,   396,   398,   382,   401,   399,   344,   342,   448,
   447,   442,   441,   440,   377,   376,   458,   457,   456,   455,
   454,   453,   452,   459,   276,   278,   280,   282,   275,   277,
   279,   281,   285,   284,   286,   287,   289,   288,   419,   428,
   283,   290,   423,   422,   421,   420,   427,   426,   425,   424,
   349,   348,   347,   346,   429,   418,   369,   368,   366,   367,
   374,   375,   362,   363,   437,   364,   365,   370,   371,   438,
   372,   373,   292,   293,   294,   295,   300,   301,   302,   303,
   266,   265,   272,   270,   345,   343,   379,   378,   402,   400,
   304,   305,   306,   307,   308,   309,   381,   380,   313,   341,
   311,   335,   327,   329,   337,   339,   333,   321,   331,   323,
   317,   319,   315,   325,   312,   340,   310,   334,   326,   328,
   336,   338,   332,   320,   330,   322,   316,   318,   314,   324,
    -5,    58,    61,    -8,   -11,   260,   -13,   -78,   261,   -16,
   261,   262,   -13,   -13,   -13,   -19,   -85,   262,   -19,   -13,
   -13,   -19,   -23,   -78,   -16,   -23,   -23,   -26,   -85,   259,
   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,
   -13,   -13,   -13,   -28,   -78,   -13,   -13,   -13,   -13,   -13,
   -13,   -44,    -6,   -28,   -28,   -28,   -28,   -28,   -28,   -28,
   -44,   -28,   -54,   -78,   -44,   -16,   -58,   -78,   -58,   -58,
   -16,   -19,   -19,   -19,   -19,   -26,   261,   -68,   259,    -6,
   -69,   -71,   259,   -72,    -6,   259,   259,   -74,   -76,   -89,
   259,    -6,    -6,   259,   -77,   259,   -78,    -6,   -79,    -6,
    -6,   259,   259,   259,   261,    -6,   -68,   259,   259,    -6,
   -68,   -68,   259,   259,   259,   -78,   -80,   259,    -9,    -9,
   -14,   -81,   -14,   -18,   -83,    40,    -6,   260,   259,   -14,
   -18,   264,   264,   -14,   -14,   -14,   -14,   -14,   -14,   -14,
   -14,   -28,   -28,   -28,   -28,   -28,   -28,   -18,   -28,   259,
   -28,   -18,   -28,   -28,   -18,   -28,   -18,   -28,   -28,   -30,
   -78,   -28,   -28,   -28,   -28,   -28,   -28,   -44,   -44,   -30,
   -48,   -84,   -30,   -48,   -30,   -48,   -30,   -48,   -30,   -48,
   -28,   -16,   -16,   -16,   -26,   -26,   -64,   -85,   -64,   -64,
   261,   -70,   -86,   263,   -70,   -73,   -87,   -88,   -68,   -75,
   264,   -90,    -6,   259,   -68,   263,   -75,   259,   259,   -73,
   -68,   259,   259,   259,   261,   259,   259,   -73,   -82,    40,
   -83,   260,   -83,    43,    45,    43,   259,   -30,   -18,   -30,
   259,   -18,   259,   -30,   -30,   -18,   -30,   -18,   -30,   -18,
   -30,   -18,   -30,   -18,   -30,   -18,   -30,   -18,   -30,   -18,
   -30,   -18,   -30,   -18,   -44,   -44,   -18,   -44,   -44,   -44,
   -44,   -44,   -44,   -44,   -44,   -64,   -86,    58,   -87,    58,
   -68,   264,   -78,   259,   -78,    40,    43,    40,    43,    45,
    41,   -83,   -83,   259,   259,   259,    41,   -78,    -6,   -78,
   -83,   -83,    62,    41,    41,    40,    40,    62,   -78,   -78,
   259,    41,    41 };
static const yytabelem yydef[]={

     1,    -2,   384,     2,     0,     4,     0,     7,     9,    11,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    29,     0,    31,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   384,
     0,     0,     0,     0,     0,     0,     0,   384,   384,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   384,   278,   280,   282,     0,   284,   384,   287,   289,   291,
   380,     0,   295,   384,   384,   299,     0,   301,     0,     0,
   384,   306,   384,   384,     0,     0,     0,     0,   384,   384,
   316,   318,   384,   384,   384,   323,   325,     0,     0,   329,
    12,    13,    98,    99,   100,   101,   102,   103,   104,   105,
   106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
   116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
   126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
   136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
   146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
   156,   157,   158,   159,   168,   169,   160,   161,   162,   163,
   164,   165,   166,   167,   170,   171,   172,   173,   174,   175,
   176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
   186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
   196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
   206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
   216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
   226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
   236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
   246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
   256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
   266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     3,     5,     0,     0,     0,   385,   331,   353,   359,   331,
   364,   365,     0,   331,     0,     0,   360,   363,     0,   331,
   331,   331,   331,   358,   331,   331,   331,   331,   361,    30,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   354,     0,     0,     0,     0,     0,
     0,    71,   366,   384,   384,   343,   343,   343,   343,   343,
    84,    85,     0,    -2,    87,     0,    89,   357,    90,     0,
     0,     0,     0,     0,     0,     0,     0,   277,   373,   374,
     0,     0,   283,   371,   384,   288,   290,     0,   293,    -2,
   294,   296,   384,     0,     0,     0,     0,   305,   371,   308,
   384,     0,     0,     0,     0,   314,   315,   317,   319,   320,
   321,   322,   324,   326,     0,     0,   371,     6,     8,    10,
    14,     0,    15,    16,   345,     0,   347,     0,   350,    17,
    18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
    28,    32,    33,    34,    35,    36,     0,    39,     0,    42,
     0,    44,     0,     0,    49,     0,    52,    53,     0,    58,
   355,     0,     0,     0,     0,     0,     0,    72,    73,   384,
   384,     0,   384,   384,   384,   384,   384,   384,   384,   384,
    86,    88,    91,    92,    93,     0,    95,   362,    96,    97,
   276,   279,   368,   369,   281,    -2,   376,   384,   286,   292,
   379,   381,   382,   297,   298,   300,   302,   303,     0,    -2,
   309,   310,   311,   312,   313,   327,     0,    -2,   332,     0,
   334,   336,     0,     0,     0,     0,   352,    37,    38,    40,
    41,    43,    45,    46,    47,    48,    50,    51,    54,    55,
    56,    57,    59,    61,    60,    62,    63,    64,    65,    66,
    67,    68,    69,    70,    74,    75,   344,    76,    77,    78,
    79,    80,    81,    82,    83,    94,   367,     0,   375,     0,
   372,   378,   304,   328,     0,     0,   384,     0,     0,     0,
     0,   348,   349,   351,   370,   377,   333,     0,   339,     0,
   338,   340,     0,   335,   337,     0,     0,     0,     0,     0,
   346,   341,   342 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"Y_EOF",	257,
	"Y_NL",	258,
	"Y_INT",	259,
	"Y_ID",	260,
	"Y_REG",	261,
	"Y_FP_REG",	262,
	"Y_STR",	263,
	"Y_FP",	264,
	"Y_ABS_D_OP",	265,
	"Y_ABS_S_OP",	266,
	"Y_ADDIU_OP",	267,
	"Y_ADDI_OP",	268,
	"Y_ADDU_OP",	269,
	"Y_ADD_D_OP",	270,
	"Y_ADD_OP",	271,
	"Y_ADD_S_OP",	272,
	"Y_ANDI_OP",	273,
	"Y_AND_OP",	274,
	"Y_BC0F_OP",	275,
	"Y_BC0T_OP",	276,
	"Y_BC1F_OP",	277,
	"Y_BC1T_OP",	278,
	"Y_BC2F_OP",	279,
	"Y_BC2T_OP",	280,
	"Y_BC3F_OP",	281,
	"Y_BC3T_OP",	282,
	"Y_BEQ_OP",	283,
	"Y_BGEZAL_OP",	284,
	"Y_BGEZ_OP",	285,
	"Y_BGTZ_OP",	286,
	"Y_BLEZ_OP",	287,
	"Y_BLTZAL_OP",	288,
	"Y_BLTZ_OP",	289,
	"Y_BNE_OP",	290,
	"Y_BREAK_OP",	291,
	"Y_CFC0_OP",	292,
	"Y_CFC1_OP",	293,
	"Y_CFC2_OP",	294,
	"Y_CFC3_OP",	295,
	"Y_COP0_OP",	296,
	"Y_COP1_OP",	297,
	"Y_COP2_OP",	298,
	"Y_COP3_OP",	299,
	"Y_CTC0_OP",	300,
	"Y_CTC1_OP",	301,
	"Y_CTC2_OP",	302,
	"Y_CTC3_OP",	303,
	"Y_CVT_D_S_OP",	304,
	"Y_CVT_D_W_OP",	305,
	"Y_CVT_S_D_OP",	306,
	"Y_CVT_S_W_OP",	307,
	"Y_CVT_W_D_OP",	308,
	"Y_CVT_W_S_OP",	309,
	"Y_C_EQ_D_OP",	310,
	"Y_C_EQ_S_OP",	311,
	"Y_C_F_D_OP",	312,
	"Y_C_F_S_OP",	313,
	"Y_C_LE_D_OP",	314,
	"Y_C_LE_S_OP",	315,
	"Y_C_LT_D_OP",	316,
	"Y_C_LT_S_OP",	317,
	"Y_C_NGE_D_OP",	318,
	"Y_C_NGE_S_OP",	319,
	"Y_C_NGLE_D_OP",	320,
	"Y_C_NGLE_S_OP",	321,
	"Y_C_NGL_D_OP",	322,
	"Y_C_NGL_S_OP",	323,
	"Y_C_NGT_D_OP",	324,
	"Y_C_NGT_S_OP",	325,
	"Y_C_OLT_D_OP",	326,
	"Y_C_OLT_S_OP",	327,
	"Y_C_OLE_D_OP",	328,
	"Y_C_OLE_S_OP",	329,
	"Y_C_SEQ_D_OP",	330,
	"Y_C_SEQ_S_OP",	331,
	"Y_C_SF_D_OP",	332,
	"Y_C_SF_S_OP",	333,
	"Y_C_UEQ_D_OP",	334,
	"Y_C_UEQ_S_OP",	335,
	"Y_C_ULT_D_OP",	336,
	"Y_C_ULT_S_OP",	337,
	"Y_C_ULE_D_OP",	338,
	"Y_C_ULE_S_OP",	339,
	"Y_C_UN_D_OP",	340,
	"Y_C_UN_S_OP",	341,
	"Y_DIVU_OP",	342,
	"Y_DIV_D_OP",	343,
	"Y_DIV_OP",	344,
	"Y_DIV_S_OP",	345,
	"Y_JALR_OP",	346,
	"Y_JAL_OP",	347,
	"Y_JR_OP",	348,
	"Y_J_OP",	349,
	"Y_LBU_OP",	350,
	"Y_LB_OP",	351,
	"Y_LHU_OP",	352,
	"Y_LH_OP",	353,
	"Y_LUI_OP",	354,
	"Y_LWC0_OP",	355,
	"Y_LWC1_OP",	356,
	"Y_LWC2_OP",	357,
	"Y_LWC3_OP",	358,
	"Y_LWL_OP",	359,
	"Y_LWR_OP",	360,
	"Y_LW_OP",	361,
	"Y_MFC0_OP",	362,
	"Y_MFC1_OP",	363,
	"Y_MFC2_OP",	364,
	"Y_MFC3_OP",	365,
	"Y_MFHI_OP",	366,
	"Y_MFLO_OP",	367,
	"Y_MOV_D_OP",	368,
	"Y_MOV_S_OP",	369,
	"Y_MTC0_OP",	370,
	"Y_MTC1_OP",	371,
	"Y_MTC2_OP",	372,
	"Y_MTC3_OP",	373,
	"Y_MTHI_OP",	374,
	"Y_MTLO_OP",	375,
	"Y_MULTU_OP",	376,
	"Y_MULT_OP",	377,
	"Y_MUL_D_OP",	378,
	"Y_MUL_S_OP",	379,
	"Y_NEG_D_OP",	380,
	"Y_NEG_S_OP",	381,
	"Y_NOR_OP",	382,
	"Y_ORI_OP",	383,
	"Y_OR_OP",	384,
	"Y_PFW_OP",	385,
	"Y_RFE_OP",	386,
	"Y_SB_OP",	387,
	"Y_SH_OP",	388,
	"Y_SLLV_OP",	389,
	"Y_SLL_OP",	390,
	"Y_SLTIU_OP",	391,
	"Y_SLTI_OP",	392,
	"Y_SLTU_OP",	393,
	"Y_SLT_OP",	394,
	"Y_SRAV_OP",	395,
	"Y_SRA_OP",	396,
	"Y_SRLV_OP",	397,
	"Y_SRL_OP",	398,
	"Y_SUBU_OP",	399,
	"Y_SUB_D_OP",	400,
	"Y_SUB_OP",	401,
	"Y_SUB_S_OP",	402,
	"Y_SWC0_OP",	403,
	"Y_SWC1_OP",	404,
	"Y_SWC2_OP",	405,
	"Y_SWC3_OP",	406,
	"Y_SWL_OP",	407,
	"Y_SWR_OP",	408,
	"Y_SW_OP",	409,
	"Y_SYSCALL_OP",	410,
	"Y_TLBP_OP",	411,
	"Y_TLBR_OP",	412,
	"Y_TLBWI_OP",	413,
	"Y_TLBWR_OP",	414,
	"Y_XORI_OP",	415,
	"Y_XOR_OP",	416,
	"Y_ABS_POP",	417,
	"Y_BAL_POP",	418,
	"Y_BEQZ_POP",	419,
	"Y_BGEU_POP",	420,
	"Y_BGE_POP",	421,
	"Y_BGTU_POP",	422,
	"Y_BGT_POP",	423,
	"Y_BLEU_POP",	424,
	"Y_BLE_POP",	425,
	"Y_BLTU_POP",	426,
	"Y_BLT_POP",	427,
	"Y_BNEZ_POP",	428,
	"Y_B_POP",	429,
	"Y_LA_POP",	430,
	"Y_LD_POP",	431,
	"Y_LI_POP",	432,
	"Y_LI_D_POP",	433,
	"Y_LI_S_POP",	434,
	"Y_L_D_POP",	435,
	"Y_L_S_POP",	436,
	"Y_MFC1_D_POP",	437,
	"Y_MTC1_D_POP",	438,
	"Y_MOVE_POP",	439,
	"Y_MULOU_POP",	440,
	"Y_MULO_POP",	441,
	"Y_MUL_POP",	442,
	"Y_NEGU_POP",	443,
	"Y_NEG_POP",	444,
	"Y_NOP_POP",	445,
	"Y_NOT_POP",	446,
	"Y_REMU_POP",	447,
	"Y_REM_POP",	448,
	"Y_ROL_POP",	449,
	"Y_ROR_POP",	450,
	"Y_SD_POP",	451,
	"Y_SEQ_POP",	452,
	"Y_SGEU_POP",	453,
	"Y_SGE_POP",	454,
	"Y_SGTU_POP",	455,
	"Y_SGT_POP",	456,
	"Y_SLEU_POP",	457,
	"Y_SLE_POP",	458,
	"Y_SNE_POP",	459,
	"Y_S_D_POP",	460,
	"Y_S_S_POP",	461,
	"Y_ULHU_POP",	462,
	"Y_ULH_POP",	463,
	"Y_ULW_POP",	464,
	"Y_USH_POP",	465,
	"Y_USW_POP",	466,
	"Y_ALIAS_DIR",	467,
	"Y_ALIGN_DIR",	468,
	"Y_ASCII_DIR",	469,
	"Y_ASCIIZ_DIR",	470,
	"Y_ASM0_DIR",	471,
	"Y_BGNB_DIR",	472,
	"Y_BYTE_DIR",	473,
	"Y_COMM_DIR",	474,
	"Y_DATA_DIR",	475,
	"Y_DOUBLE_DIR",	476,
	"Y_ENDB_DIR",	477,
	"Y_ENDR_DIR",	478,
	"Y_END_DIR",	479,
	"Y_ENT_DIR",	480,
	"Y_ERR_DIR",	481,
	"Y_EXTERN_DIR",	482,
	"Y_FILE_DIR",	483,
	"Y_FLOAT_DIR",	484,
	"Y_FMASK_DIR",	485,
	"Y_FRAME_DIR",	486,
	"Y_GLOBAL_DIR",	487,
	"Y_HALF_DIR",	488,
	"Y_K_TEXT_DIR",	489,
	"Y_K_DATA_DIR",	490,
	"Y_LABEL_DIR",	491,
	"Y_LCOMM_DIR",	492,
	"Y_LIVEREG_DIR",	493,
	"Y_LOC_DIR",	494,
	"Y_MASK_DIR",	495,
	"Y_NOALIAS_DIR",	496,
	"Y_OPTIONS_DIR",	497,
	"Y_RDATA_DIR",	498,
	"Y_REPEAT_DIR",	499,
	"Y_SDATA_DIR",	500,
	"Y_SET_DIR",	501,
	"Y_SPACE_DIR",	502,
	"Y_STRUCT_DIR",	503,
	"Y_TEXT_DIR",	504,
	"Y_VERSTAMP_DIR",	505,
	"Y_VREG_DIR",	506,
	"Y_WORD_DIR",	507,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"LINE : /* empty */",
	"LINE : LBL_CMD",
	"LBL_CMD : OPT_LBL CMD",
	"LBL_CMD : CMD",
	"OPT_LBL : ID ':'",
	"OPT_LBL : ID '=' Y_INT",
	"CMD : ASM_CODE",
	"CMD : ASM_CODE TERM",
	"CMD : ASM_DIRECTIVE",
	"CMD : ASM_DIRECTIVE TERM",
	"CMD : TERM",
	"TERM : Y_NL",
	"TERM : Y_EOF",
	"ASM_CODE : LOAD_OP DEST_REG ADDRESS",
	"ASM_CODE : LOAD_COP COP_REG ADDRESS",
	"ASM_CODE : LOAD_IMM_OP DEST_REG IMM",
	"ASM_CODE : Y_LA_POP DEST_REG ADDRESS",
	"ASM_CODE : Y_LI_POP DEST_REG IMM",
	"ASM_CODE : Y_LI_D_POP F_DEST Y_FP",
	"ASM_CODE : Y_LI_S_POP F_DEST Y_FP",
	"ASM_CODE : Y_ULW_POP DEST_REG ADDRESS",
	"ASM_CODE : ULOADH_POP DEST_REG ADDRESS",
	"ASM_CODE : LOADF_OP F_DEST ADDRESS",
	"ASM_CODE : STORE_OP SOURCE ADDRESS",
	"ASM_CODE : STORE_COP COP_REG ADDRESS",
	"ASM_CODE : Y_USW_POP SOURCE ADDRESS",
	"ASM_CODE : Y_USH_POP SOURCE ADDRESS",
	"ASM_CODE : STOREF_OP F_SRC1 ADDRESS",
	"ASM_CODE : SYS_OP",
	"ASM_CODE : Y_BREAK_OP Y_INT",
	"ASM_CODE : Y_NOP_POP",
	"ASM_CODE : Y_ABS_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEG_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEGU_POP DEST_REG SRC1",
	"ASM_CODE : Y_NOT_POP DEST_REG SRC1",
	"ASM_CODE : Y_MOVE_POP DEST_REG SRC1",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_I DEST_REG IMM",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 Y_INT",
	"ASM_CODE : BINARY_OPR_I DEST_REG Y_INT",
	"ASM_CODE : BINARY_IMM_OP DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_IMM_OP DEST_REG IMM",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 Y_INT",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_NOI DEST_REG IMM",
	"ASM_CODE : SUB_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : SUB_OP DEST_REG SRC1 IMM",
	"ASM_CODE : SUB_OP DEST_REG IMM",
	"ASM_CODE : DIV_POP DEST_REG SRC1",
	"ASM_CODE : DIV_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : DIV_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MUL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : MUL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MULT_OP SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 IMM",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 IMM",
	"ASM_CODE : NULLARY_BR_OP LABEL",
	"ASM_CODE : UNARY_BR_OP SRC1 LABEL",
	"ASM_CODE : UNARY_BR_POP SRC1 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 SRC2 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : J_OPS LABEL",
	"ASM_CODE : J_OPS SRC1",
	"ASM_CODE : J_OPS DEST SRC1",
	"ASM_CODE : B_OP LABEL",
	"ASM_CODE : MOVE_COP_OP COP_REG COP_REG",
	"ASM_CODE : MOV_FROM_HILO_OP REG",
	"ASM_CODE : MOV_TO_HILO_OP REG",
	"ASM_CODE : MOV_COP_OP REG COP_REG",
	"ASM_CODE : CTL_COP_OP COP_REG COP_REG",
	"ASM_CODE : FP_ABS_OP F_DEST F_SRC1",
	"ASM_CODE : FP_BINARY_OP F_DEST F_SRC1 F_SRC2",
	"ASM_CODE : FP_CONVERT_OP F_DEST F_SRC2",
	"ASM_CODE : FP_NEG_OP F_DEST F_SRC2",
	"ASM_CODE : FP_CMP_OP F_SRC1 F_SRC2",
	"LOAD_OP : Y_LB_OP",
	"LOAD_OP : Y_LBU_OP",
	"LOAD_OP : Y_LH_OP",
	"LOAD_OP : Y_LHU_OP",
	"LOAD_OP : Y_LW_OP",
	"LOAD_OP : Y_LWL_OP",
	"LOAD_OP : Y_LWR_OP",
	"LOAD_OP : Y_LD_POP",
	"LOAD_OP : Y_PFW_OP",
	"LOAD_COP : Y_LWC0_OP",
	"LOAD_COP : Y_LWC2_OP",
	"LOAD_COP : Y_LWC3_OP",
	"LOAD_IMM_OP : Y_LUI_OP",
	"ULOADH_POP : Y_ULH_POP",
	"ULOADH_POP : Y_ULHU_POP",
	"LOADF_OP : Y_LWC1_OP",
	"LOADF_OP : Y_L_S_POP",
	"LOADF_OP : Y_L_D_POP",
	"STORE_OP : Y_SB_OP",
	"STORE_OP : Y_SH_OP",
	"STORE_OP : Y_SW_OP",
	"STORE_OP : Y_SWL_OP",
	"STORE_OP : Y_SWR_OP",
	"STORE_OP : Y_SD_POP",
	"STORE_COP : Y_SWC0_OP",
	"STORE_COP : Y_SWC2_OP",
	"STORE_COP : Y_SWC3_OP",
	"STOREF_OP : Y_SWC1_OP",
	"STOREF_OP : Y_S_S_POP",
	"STOREF_OP : Y_S_D_POP",
	"SYS_OP : Y_RFE_OP",
	"SYS_OP : Y_SYSCALL_OP",
	"BINARY_OP_I : Y_ADD_OP",
	"BINARY_OP_I : Y_ADDU_OP",
	"BINARY_OP_I : Y_AND_OP",
	"BINARY_OP_I : Y_XOR_OP",
	"BINARY_OP_I : Y_OR_OP",
	"BINARY_OP_I : Y_SLT_OP",
	"BINARY_OP_I : Y_SLTU_OP",
	"BINARY_OPR_I : Y_SLLV_OP",
	"BINARY_OPR_I : Y_SRAV_OP",
	"BINARY_OPR_I : Y_SRLV_OP",
	"BINARY_IMM_OP : Y_ADDI_OP",
	"BINARY_IMM_OP : Y_ADDIU_OP",
	"BINARY_IMM_OP : Y_ANDI_OP",
	"BINARY_IMM_OP : Y_ORI_OP",
	"BINARY_IMM_OP : Y_XORI_OP",
	"BINARY_IMM_OP : Y_SLTI_OP",
	"BINARY_IMM_OP : Y_SLTIU_OP",
	"SHIFT_OP : Y_SLL_OP",
	"SHIFT_OP : Y_SRA_OP",
	"SHIFT_OP : Y_SRL_OP",
	"BINARY_OP_NOI : Y_NOR_OP",
	"SUB_OP : Y_SUB_OP",
	"SUB_OP : Y_SUBU_OP",
	"DIV_POP : Y_DIV_OP",
	"DIV_POP : Y_DIVU_OP",
	"DIV_POP : Y_REM_POP",
	"DIV_POP : Y_REMU_POP",
	"MUL_POP : Y_MUL_POP",
	"MUL_POP : Y_MULO_POP",
	"MUL_POP : Y_MULOU_POP",
	"SET_LE_POP : Y_SLE_POP",
	"SET_LE_POP : Y_SLEU_POP",
	"SET_GT_POP : Y_SGT_POP",
	"SET_GT_POP : Y_SGTU_POP",
	"SET_GE_POP : Y_SGE_POP",
	"SET_GE_POP : Y_SGEU_POP",
	"SET_EQ_POP : Y_SEQ_POP",
	"SET_EQ_POP : Y_SNE_POP",
	"MULT_OP : Y_MULT_OP",
	"MULT_OP : Y_MULTU_OP",
	"NULLARY_BR_OP : Y_BC0T_OP",
	"NULLARY_BR_OP : Y_BC1T_OP",
	"NULLARY_BR_OP : Y_BC2T_OP",
	"NULLARY_BR_OP : Y_BC3T_OP",
	"NULLARY_BR_OP : Y_BC0F_OP",
	"NULLARY_BR_OP : Y_BC1F_OP",
	"NULLARY_BR_OP : Y_BC2F_OP",
	"NULLARY_BR_OP : Y_BC3F_OP",
	"UNARY_BR_OP : Y_BGEZ_OP",
	"UNARY_BR_OP : Y_BGEZAL_OP",
	"UNARY_BR_OP : Y_BGTZ_OP",
	"UNARY_BR_OP : Y_BLEZ_OP",
	"UNARY_BR_OP : Y_BLTZ_OP",
	"UNARY_BR_OP : Y_BLTZAL_OP",
	"UNARY_BR_POP : Y_BEQZ_POP",
	"UNARY_BR_POP : Y_BNEZ_POP",
	"BINARY_BR_OP : Y_BEQ_OP",
	"BINARY_BR_OP : Y_BNE_OP",
	"BR_GT_POP : Y_BGT_POP",
	"BR_GT_POP : Y_BGTU_POP",
	"BR_GE_POP : Y_BGE_POP",
	"BR_GE_POP : Y_BGEU_POP",
	"BR_LT_POP : Y_BLT_POP",
	"BR_LT_POP : Y_BLTU_POP",
	"BR_LE_POP : Y_BLE_POP",
	"BR_LE_POP : Y_BLEU_POP",
	"J_OPS : Y_J_OP",
	"J_OPS : Y_JR_OP",
	"J_OPS : Y_JAL_OP",
	"J_OPS : Y_JALR_OP",
	"B_OP : Y_B_POP",
	"B_OP : Y_BAL_POP",
	"MOVE_COP_OP : Y_MOV_S_OP",
	"MOVE_COP_OP : Y_MOV_D_OP",
	"MOV_FROM_HILO_OP : Y_MFHI_OP",
	"MOV_FROM_HILO_OP : Y_MFLO_OP",
	"MOV_TO_HILO_OP : Y_MTHI_OP",
	"MOV_TO_HILO_OP : Y_MTLO_OP",
	"MOV_COP_OP : Y_MFC0_OP",
	"MOV_COP_OP : Y_MFC1_OP",
	"MOV_COP_OP : Y_MFC1_D_POP",
	"MOV_COP_OP : Y_MFC2_OP",
	"MOV_COP_OP : Y_MFC3_OP",
	"MOV_COP_OP : Y_MTC0_OP",
	"MOV_COP_OP : Y_MTC1_OP",
	"MOV_COP_OP : Y_MTC1_D_POP",
	"MOV_COP_OP : Y_MTC2_OP",
	"MOV_COP_OP : Y_MTC3_OP",
	"CTL_COP_OP : Y_CFC0_OP",
	"CTL_COP_OP : Y_CFC1_OP",
	"CTL_COP_OP : Y_CFC2_OP",
	"CTL_COP_OP : Y_CFC3_OP",
	"CTL_COP_OP : Y_CTC0_OP",
	"CTL_COP_OP : Y_CTC1_OP",
	"CTL_COP_OP : Y_CTC2_OP",
	"CTL_COP_OP : Y_CTC3_OP",
	"FP_ABS_OP : Y_ABS_S_OP",
	"FP_ABS_OP : Y_ABS_D_OP",
	"FP_BINARY_OP : Y_ADD_S_OP",
	"FP_BINARY_OP : Y_ADD_D_OP",
	"FP_BINARY_OP : Y_DIV_S_OP",
	"FP_BINARY_OP : Y_DIV_D_OP",
	"FP_BINARY_OP : Y_MUL_S_OP",
	"FP_BINARY_OP : Y_MUL_D_OP",
	"FP_BINARY_OP : Y_SUB_S_OP",
	"FP_BINARY_OP : Y_SUB_D_OP",
	"FP_CONVERT_OP : Y_CVT_D_S_OP",
	"FP_CONVERT_OP : Y_CVT_D_W_OP",
	"FP_CONVERT_OP : Y_CVT_S_D_OP",
	"FP_CONVERT_OP : Y_CVT_S_W_OP",
	"FP_CONVERT_OP : Y_CVT_W_D_OP",
	"FP_CONVERT_OP : Y_CVT_W_S_OP",
	"FP_NEG_OP : Y_NEG_S_OP",
	"FP_NEG_OP : Y_NEG_D_OP",
	"FP_CMP_OP : Y_C_F_S_OP",
	"FP_CMP_OP : Y_C_UN_S_OP",
	"FP_CMP_OP : Y_C_EQ_S_OP",
	"FP_CMP_OP : Y_C_UEQ_S_OP",
	"FP_CMP_OP : Y_C_OLT_S_OP",
	"FP_CMP_OP : Y_C_OLE_S_OP",
	"FP_CMP_OP : Y_C_ULT_S_OP",
	"FP_CMP_OP : Y_C_ULE_S_OP",
	"FP_CMP_OP : Y_C_SF_S_OP",
	"FP_CMP_OP : Y_C_NGLE_S_OP",
	"FP_CMP_OP : Y_C_SEQ_S_OP",
	"FP_CMP_OP : Y_C_NGL_S_OP",
	"FP_CMP_OP : Y_C_LT_S_OP",
	"FP_CMP_OP : Y_C_NGE_S_OP",
	"FP_CMP_OP : Y_C_LE_S_OP",
	"FP_CMP_OP : Y_C_NGT_S_OP",
	"FP_CMP_OP : Y_C_F_D_OP",
	"FP_CMP_OP : Y_C_UN_D_OP",
	"FP_CMP_OP : Y_C_EQ_D_OP",
	"FP_CMP_OP : Y_C_UEQ_D_OP",
	"FP_CMP_OP : Y_C_OLT_D_OP",
	"FP_CMP_OP : Y_C_OLE_D_OP",
	"FP_CMP_OP : Y_C_ULT_D_OP",
	"FP_CMP_OP : Y_C_ULE_D_OP",
	"FP_CMP_OP : Y_C_SF_D_OP",
	"FP_CMP_OP : Y_C_NGLE_D_OP",
	"FP_CMP_OP : Y_C_SEQ_D_OP",
	"FP_CMP_OP : Y_C_NGL_D_OP",
	"FP_CMP_OP : Y_C_LT_D_OP",
	"FP_CMP_OP : Y_C_NGE_D_OP",
	"FP_CMP_OP : Y_C_LE_D_OP",
	"FP_CMP_OP : Y_C_NGT_D_OP",
	"ASM_DIRECTIVE : Y_ALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_ALIGN_DIR EXPR",
	"ASM_DIRECTIVE : Y_ASCII_DIR",
	"ASM_DIRECTIVE : Y_ASCII_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASM0_DIR",
	"ASM_DIRECTIVE : Y_BGNB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_BYTE_DIR",
	"ASM_DIRECTIVE : Y_BYTE_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_COMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_DATA_DIR",
	"ASM_DIRECTIVE : Y_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_DATA_DIR",
	"ASM_DIRECTIVE : Y_K_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_END_DIR OPTIONAL_ID",
	"ASM_DIRECTIVE : Y_ENDB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_ENDR_DIR",
	"ASM_DIRECTIVE : Y_ENT_DIR ID",
	"ASM_DIRECTIVE : Y_ENT_DIR ID Y_INT",
	"ASM_DIRECTIVE : Y_EXTERN_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_ERR_DIR",
	"ASM_DIRECTIVE : Y_FILE_DIR Y_INT Y_STR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_FMASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_FRAME_DIR REGISTER Y_INT REGISTER",
	"ASM_DIRECTIVE : Y_GLOBAL_DIR ID",
	"ASM_DIRECTIVE : Y_HALF_DIR",
	"ASM_DIRECTIVE : Y_HALF_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_LABEL_DIR ID",
	"ASM_DIRECTIVE : Y_LCOMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_LIVEREG_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_LOC_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_MASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_NOALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_OPTIONS_DIR ID",
	"ASM_DIRECTIVE : Y_REPEAT_DIR EXPR",
	"ASM_DIRECTIVE : Y_RDATA_DIR",
	"ASM_DIRECTIVE : Y_RDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SDATA_DIR",
	"ASM_DIRECTIVE : Y_SDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SET_DIR ID",
	"ASM_DIRECTIVE : Y_SPACE_DIR EXPR",
	"ASM_DIRECTIVE : Y_STRUCT_DIR EXPR",
	"ASM_DIRECTIVE : Y_TEXT_DIR",
	"ASM_DIRECTIVE : Y_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_VERSTAMP_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_VREG_DIR REGISTER Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_WORD_DIR",
	"ASM_DIRECTIVE : Y_WORD_DIR EXPR_LST",
	"ADDRESS : /* empty */",
	"ADDRESS : ADDR",
	"ADDR : '(' REGISTER ')'",
	"ADDR : ABS_ADDR",
	"ADDR : ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID",
	"ADDR : Y_ID '(' REGISTER ')'",
	"ADDR : Y_ID '+' ABS_ADDR",
	"ADDR : ABS_ADDR '+' ID",
	"ADDR : Y_ID '-' ABS_ADDR",
	"ADDR : Y_ID '+' ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID '-' ABS_ADDR '(' REGISTER ')'",
	"IMMEDIATE : /* empty */",
	"IMMEDIATE : IMM",
	"IMM : ABS_ADDR",
	"IMM : '(' ABS_ADDR ')' '>' '>' Y_INT",
	"IMM : ID",
	"IMM : Y_ID '+' ABS_ADDR",
	"IMM : Y_ID '-' ABS_ADDR",
	"ABS_ADDR : Y_INT",
	"ABS_ADDR : Y_INT '+' Y_INT",
	"ABS_ADDR : Y_INT Y_INT",
	"DEST_REG : REGISTER",
	"SRC1 : REGISTER",
	"SRC2 : REGISTER",
	"DEST : REGISTER",
	"REG : REGISTER",
	"SOURCE : REGISTER",
	"REGISTER : Y_REG",
	"F_DEST : FP_REGISTER",
	"F_SRC1 : FP_REGISTER",
	"F_SRC2 : FP_REGISTER",
	"FP_REGISTER : Y_FP_REG",
	"COP_REG : Y_REG",
	"COP_REG : Y_FP_REG",
	"LABEL : ID",
	"STR_LST : STR_LST STR",
	"STR_LST : STR",
	"STR : Y_STR",
	"STR : Y_STR ':' Y_INT",
	"EXPRESSION : /* empty */",
	"EXPRESSION : EXPR",
	"EXPR : Y_INT",
	"EXPR : ID",
	"EXPR_LST : EXPR_LST EXPRESSION",
	"EXPR_LST : EXPRESSION",
	"EXPR_LST : EXPRESSION ':' Y_INT",
	"FP_EXPR_LST : FP_EXPR_LST Y_FP",
	"FP_EXPR_LST : Y_FP",
	"OPTIONAL_ID : /* empty */",
	"OPTIONAL_ID : OPT_ID",
	"OPT_ID : ID",
	"OPT_ID : /* empty */",
	"ID : /* empty */",
	"ID : Y_ID",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.14	97/01/16 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 379 "parser.y"
{parse_error_occurred = 0; scanner_start_line (); } break;
case 5:
# line 386 "parser.y"
{
			   this_line_labels =
			     cons_label (record_label ((char*)yypvt[-1].p,
						       text_dir
						       ? current_text_pc ()
						       : current_data_pc (),
						       0),
					 this_line_labels);
				if (yypvt[-1].p) free(yypvt[-1].p);
			 } break;
case 6:
# line 398 "parser.y"
{
		  label *l = record_label ((char*)yypvt[-2].p, (mem_addr)yypvt[-0].i, 1);
		  if (yypvt[-2].p) free(yypvt[-2].p);

		  l->const_flag = 1;
		  clear_labels ();
		} break;
case 7:
# line 409 "parser.y"
{
		  clear_labels ();
		} break;
case 9:
# line 415 "parser.y"
{
		  clear_labels ();
		} break;
case 12:
# line 425 "parser.y"
{
			LINE_PARSE_DONE;
		} break;
case 13:
# line 430 "parser.y"
{
		  clear_labels ();
		  FILE_PARSE_DONE;
		} break;
case 14:
# line 439 "parser.y"
{
		  i_type_inst (yypvt[-2].i == Y_LD_POP ? Y_LW_OP : yypvt[-2].i,
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_LD_POP)
		    i_type_inst_free (Y_LW_OP,
				      yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 15:
# line 455 "parser.y"
{
		  i_type_inst (yypvt[-2].i, yypvt[-1].i, addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 16:
# line 463 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, yypvt[-1].i, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 17:
# line 469 "parser.y"
{
		  if (addr_expr_reg ((addr_expr *)yypvt[-0].p))
		    i_type_inst (Y_ADDI_OP, yypvt[-1].i,
				 addr_expr_reg ((addr_expr *)yypvt[-0].p),
				 addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  else
		    i_type_inst (Y_ORI_OP, yypvt[-1].i, 0,
				 addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 18:
# line 483 "parser.y"
{
		  i_type_inst_free (Y_ORI_OP, yypvt[-1].i, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 19:
# line 489 "parser.y"
{
		  int *x = (int *) yypvt[-0].p;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*x));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i, 0, 1);
		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*(x+1)));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i + 1, 0, 1);
		} break;
case 20:
# line 500 "parser.y"
{
		  float x = (float) *((double *) yypvt[-0].p);
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i, 0, 1);
		} break;
case 21:
# line 510 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_LWL_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_LWR_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
#else
		  i_type_inst_free (Y_LWL_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
		  i_type_inst (Y_LWR_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 22:
# line 534 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst ((yypvt[-2].i == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_LBU_OP, 1,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
#else
		  i_type_inst_free ((yypvt[-2].i == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
				    yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
		  i_type_inst (Y_LBU_OP, 1,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  r_sh_type_inst (Y_SLL_OP, yypvt[-1].i, yypvt[-1].i, 8);
		  r_type_inst (Y_OR_OP, yypvt[-1].i, yypvt[-1].i, 1);
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 23:
# line 562 "parser.y"
{
		  i_type_inst (Y_LWC1_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_L_D_POP)
		    i_type_inst_free (Y_LWC1_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 24:
# line 577 "parser.y"
{
		  i_type_inst (yypvt[-2].i == Y_SD_POP ? Y_SW_OP : yypvt[-2].i,
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_SD_POP)
		    i_type_inst_free (Y_SW_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 25:
# line 593 "parser.y"
{
		  i_type_inst (yypvt[-2].i, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 26:
# line 603 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_SWL_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_SWR_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
#else
		  i_type_inst_free (Y_SWL_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
		  i_type_inst (Y_SWR_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 27:
# line 627 "parser.y"
{
		  i_type_inst (Y_SB_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].i, 8);
		  i_type_inst_free (Y_SB_OP, 1,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 28:
# line 642 "parser.y"
{
		  i_type_inst (Y_SWC1_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_S_D_POP)
		    i_type_inst_free (Y_SWC1_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 29:
# line 657 "parser.y"
{
		  r_type_inst (yypvt[-0].i, 0, 0, 0);
		} break;
case 30:
# line 663 "parser.y"
{
		  if (yypvt[-0].i == 1)
		    yyerror ("Breakpoint 1 is reserved for debugger");
		  r_type_inst (yypvt[-1].i, yypvt[-0].i, 0, 0);
		} break;
case 31:
# line 671 "parser.y"
{
		  nop_inst ();
		} break;
case 32:
# line 677 "parser.y"
{
		  if (yypvt[-1].i != yypvt[-0].i)
		    r_type_inst (Y_ADDU_OP, yypvt[-1].i, 0, yypvt[-0].i);

		  i_type_inst_free (Y_BGEZ_OP, 0, yypvt[-0].i, branch_offset (2));
		  r_type_inst (Y_SUB_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 33:
# line 687 "parser.y"
{
		  r_type_inst (Y_SUB_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 34:
# line 693 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 35:
# line 699 "parser.y"
{
		  r_type_inst (Y_NOR_OP, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 36:
# line 705 "parser.y"
{
		  r_type_inst (Y_ADDU_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 37:
# line 711 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 38:
# line 717 "parser.y"
{
		  i_type_inst_free (op_to_imm_op (yypvt[-3].i), yypvt[-2].i, yypvt[-1].i,
				    (imm_expr *)yypvt[-0].p);
		} break;
case 39:
# line 724 "parser.y"
{
		  i_type_inst_free (op_to_imm_op (yypvt[-2].i), yypvt[-1].i, yypvt[-1].i,
				    (imm_expr *)yypvt[-0].p);
		} break;
case 40:
# line 731 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		} break;
case 41:
# line 737 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-3].i), yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 42:
# line 743 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-2].i), yypvt[-1].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 43:
# line 749 "parser.y"
{
		  i_type_inst_free (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 44:
# line 755 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, yypvt[-1].i, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 45:
# line 761 "parser.y"
{
		  r_sh_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 46:
# line 767 "parser.y"
{
		  r_type_inst (imm_op_to_op (yypvt[-3].i), yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		} break;
case 47:
# line 773 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 48:
# line 779 "parser.y"
{
		  if (bare_machine && !accept_pseudo_insts)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0].p))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      r_type_inst (yypvt[-3].i,
				   yypvt[-2].i,
				   yypvt[-1].i,
				   (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		    }
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 49:
# line 797 "parser.y"
{
		  if (bare_machine && !accept_pseudo_insts)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0].p))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      r_type_inst (yypvt[-2].i,
				   yypvt[-1].i,
				   yypvt[-1].i,
				   (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		    }
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 50:
# line 815 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 51:
# line 821 "parser.y"
{
		  int val = eval_imm_expr ((imm_expr*)yypvt[-0].p);

		  if (bare_machine && !accept_pseudo_insts)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-3].i == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-3].i == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-2].i,
				 yypvt[-1].i,
				 make_imm_expr ( -val, NULL, 0));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 52:
# line 838 "parser.y"
{
		  int val = eval_imm_expr ((imm_expr*)yypvt[-0].p);

		  if (bare_machine && !accept_pseudo_insts)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-2].i == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-2].i == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-1].i,
				 yypvt[-1].i,
				 make_imm_expr (-val, NULL, 0));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 53:
# line 855 "parser.y"
{
		  /* The hardware divide operation (ignore 1st arg) */
		  if (yypvt[-2].i != Y_DIV_OP && yypvt[-2].i != Y_DIVU_OP)
		    yyerror ("Syntax error");
		  r_type_inst (yypvt[-2].i, 0, yypvt[-1].i, yypvt[-0].i);
		} break;
case 54:
# line 863 "parser.y"
{
		  /* Pseudo divide operations */
		  div_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 55:
# line 869 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0].p))
		    yyerror ("Divide by zero");
		  else
		    {
		      /* Use $at */
		      i_type_inst_free (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      div_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, 1, 1);
		    }
		} break;
case 56:
# line 882 "parser.y"
{
		  mult_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 57:
# line 887 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Optimize: n * 0 == 0 */
		    i_type_inst_free (Y_ORI_OP, yypvt[-2].i, 0, (imm_expr *)yypvt[-0].p);
		  else
		    {
		      /* Use $at */
		      i_type_inst_free (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      mult_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, 1);
		    }
		} break;
case 58:
# line 901 "parser.y"
{
		  r_type_inst (yypvt[-2].i, 0, yypvt[-1].i, yypvt[-0].i);
		} break;
case 59:
# line 907 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].i);
		  r_type_inst (Y_SLLV_OP, 1, 1, yypvt[-1].i);
		  r_type_inst (Y_SRLV_OP, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		} break;
case 60:
# line 916 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].i);
		  r_type_inst (Y_SRLV_OP, 1, 1, yypvt[-1].i);
		  r_type_inst (Y_SLLV_OP, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		} break;
case 61:
# line 925 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0].p);

		  r_sh_type_inst (Y_SLL_OP, 1, yypvt[-1].i, -dist);
		  r_sh_type_inst (Y_SRL_OP, yypvt[-2].i, yypvt[-1].i, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 62:
# line 936 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0].p);

		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].i, -dist);
		  r_sh_type_inst (Y_SLL_OP, yypvt[-2].i, yypvt[-1].i, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 63:
# line 948 "parser.y"
{
		  set_le_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 64:
# line 953 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_le_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 65:
# line 964 "parser.y"
{
		  set_gt_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 66:
# line 969 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_gt_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 67:
# line 981 "parser.y"
{
		  set_ge_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 68:
# line 986 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_ge_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 69:
# line 996 "parser.y"
{
		  set_eq_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 70:
# line 1001 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_eq_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 71:
# line 1012 "parser.y"
{
		  i_type_inst_free (yypvt[-1].i, 0, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 72:
# line 1018 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, 0, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 73:
# line 1024 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i == Y_BEQZ_POP ? Y_BEQ_OP : Y_BNE_OP,
			       0, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 74:
# line 1031 "parser.y"
{
		  i_type_inst_free (yypvt[-3].i, yypvt[-1].i, yypvt[-2].i, (imm_expr *)yypvt[-0].p);
		} break;
case 75:
# line 1036 "parser.y"
{
		  if (bare_machine && !accept_pseudo_insts)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (zero_imm ((imm_expr *)yypvt[-1].p))
			i_type_inst (yypvt[-3].i, yypvt[-2].i,
				     (zero_imm ((imm_expr *)yypvt[-1].p) ? 0 : 1),
				     (imm_expr *)yypvt[-0].p);
		      else
			{
			  /* Use $at */
			  i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
			  i_type_inst (yypvt[-3].i, yypvt[-2].i,
				       (zero_imm ((imm_expr *)yypvt[-1].p) ? 0 : 1),
				       (imm_expr *)yypvt[-0].p);
			}
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 76:
# line 1060 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BGT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].i, yypvt[-2].i); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 77:
# line 1067 "parser.y"
{
		  if (yypvt[-3].i == Y_BGT_POP)
		    {
		      /* Use $at */
		      i_type_inst_free (Y_SLTI_OP, 1, yypvt[-2].i,
					incr_expr_offset ((imm_expr *)yypvt[-1].p, 1));
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
		      i_type_inst_free (Y_BEQ_OP, yypvt[-2].i, 1, branch_offset (3));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].i, 1);
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 78:
# line 1090 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BGE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].i, yypvt[-1].i); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 79:
# line 1097 "parser.y"
{
		  i_type_inst (yypvt[-3].i == Y_BGE_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].i, (imm_expr *)yypvt[-1].p); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-1].p);
		} break;
case 80:
# line 1106 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BLT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].i, yypvt[-1].i); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 81:
# line 1113 "parser.y"
{
		  i_type_inst (yypvt[-3].i == Y_BLT_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].i, (imm_expr *)yypvt[-1].p); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-1].p);
		} break;
case 82:
# line 1122 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BLE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].i, yypvt[-2].i); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 83:
# line 1129 "parser.y"
{
		  if (yypvt[-3].i == Y_BLE_POP)
		    {
		      /* Use $at */
		      i_type_inst_free (Y_SLTI_OP, 1, yypvt[-2].i,
					incr_expr_offset ((imm_expr *)yypvt[-1].p, 1));
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
		      i_type_inst (Y_BEQ_OP, yypvt[-2].i, 1, (imm_expr *)yypvt[-0].p);
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].i, 1);
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 84:
# line 1152 "parser.y"
{
		  if ((yypvt[-1].i == Y_J_OP) || (yypvt[-1].i == Y_JR_OP))
		    j_type_inst (Y_J_OP, (imm_expr *)yypvt[-0].p);
		  else if ((yypvt[-1].i == Y_JAL_OP) || (yypvt[-1].i == Y_JALR_OP))
		    j_type_inst (Y_JAL_OP, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 85:
# line 1162 "parser.y"
{
		  if ((yypvt[-1].i == Y_J_OP) || (yypvt[-1].i == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].i, 0);
		  else if ((yypvt[-1].i == Y_JAL_OP) || (yypvt[-1].i == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, 31, yypvt[-0].i, 0);
		} break;
case 86:
# line 1171 "parser.y"
{
		  if ((yypvt[-2].i == Y_J_OP) || (yypvt[-2].i == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].i, 0);
		  else if ((yypvt[-2].i == Y_JAL_OP) || (yypvt[-2].i == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 87:
# line 1180 "parser.y"
{
		  i_type_inst_free ((yypvt[-1].i == Y_BAL_POP ? Y_BGEZAL_OP : Y_BGEZ_OP),
				    0, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 88:
# line 1188 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 89:
# line 1194 "parser.y"
{
		  r_type_inst (yypvt[-1].i, yypvt[-0].i, 0, 0);
		} break;
case 90:
# line 1200 "parser.y"
{
		  r_type_inst (yypvt[-1].i, 0, yypvt[-0].i, 0);
		} break;
case 91:
# line 1206 "parser.y"
{
		  if (yypvt[-2].i == Y_MFC1_D_POP)
		    {
		      r_type_inst (Y_MFC1_OP, yypvt[-0].i, 0, yypvt[-1].i);
		      r_type_inst (Y_MFC1_OP, yypvt[-0].i + 1, 0, yypvt[-1].i + 1);
		    }
		  else if (yypvt[-2].i == Y_MTC1_D_POP)
		    {
		      r_type_inst (Y_MTC1_OP, yypvt[-0].i, 0, yypvt[-1].i);
		      r_type_inst (Y_MTC1_OP, yypvt[-0].i + 1, 0, yypvt[-1].i + 1);
		    }
		  else
		    r_type_inst (yypvt[-2].i, yypvt[-0].i, 0, yypvt[-1].i);
		} break;
case 92:
# line 1223 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-0].i, 0, yypvt[-1].i);
		} break;
case 93:
# line 1229 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 94:
# line 1235 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 95:
# line 1241 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 96:
# line 1247 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 97:
# line 1253 "parser.y"
{
		  r_cond_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 277:
# line 1530 "parser.y"
{
		  align_data (yypvt[-0].i);
		} break;
case 278:
# line 1534 "parser.y"
{null_term = 0;} break;
case 279:
# line 1535 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 280:
# line 1540 "parser.y"
{null_term = 1;} break;
case 281:
# line 1541 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 284:
# line 1553 "parser.y"
{store_op = store_byte;} break;
case 285:
# line 1555 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 286:
# line 1562 "parser.y"
{
		  align_data (2);
		  if (lookup_label ((char*)yypvt[-1].p)->addr == 0)
		  {
		    record_label ((char*)yypvt[-1].p, current_data_pc (), 1);
			if (yypvt[-2].p) free(yypvt[-2].p);
		  }
		  increment_data_pc (yypvt[-0].i);
		} break;
case 287:
# line 1574 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 288:
# line 1581 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 289:
# line 1590 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 290:
# line 1597 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 291:
# line 1606 "parser.y"
{
		  store_op = store_double;
		  if (data_dir) set_data_alignment(3);
		} break;
case 292:
# line 1611 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 298:
# line 1629 "parser.y"
{
		  extern_directive ((char*)yypvt[-1].p, yypvt[-0].i);
		} break;
case 299:
# line 1635 "parser.y"
{
		  fatal_error ("File contains an .err directive\n");
		} break;
case 301:
# line 1644 "parser.y"
{
		  store_op = store_float;
		  if (data_dir) set_data_alignment (2);
		} break;
case 302:
# line 1649 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 305:
# line 1661 "parser.y"
{
		  make_label_global ((char*)yypvt[-0].p);
		  if (yypvt[-0].p) free(yypvt[-0].p);
		} break;
case 306:
# line 1668 "parser.y"
{
		  store_op = store_half;
		  if (data_dir) set_data_alignment (1);
		} break;
case 307:
# line 1673 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 308:
# line 1680 "parser.y"
{
		  record_label ((char*)yypvt[-0].p,
				text_dir
				? current_text_pc ()
				: current_data_pc (),
				1);
		  if (yypvt[-1].p) free(yypvt[-1].p);
		} break;
case 309:
# line 1691 "parser.y"
{
		  lcomm_directive ((char*)yypvt[-1].p, yypvt[-0].i);
		} break;
case 315:
# line 1709 "parser.y"
{
		  yyerror ("Warning: repeat directive ignored");
		} break;
case 316:
# line 1715 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 317:
# line 1722 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 318:
# line 1731 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 319:
# line 1738 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 320:
# line 1747 "parser.y"
{
		  if (streq ((char*)yypvt[-0].p, "noat"))
		    noat_flag = 1;
		  else if (streq ((char*)yypvt[-0].p, "at"))
		    noat_flag = 0;
		} break;
case 321:
# line 1756 "parser.y"
{
		  if (data_dir)
		    increment_data_pc (yypvt[-0].i);
		  else if (text_dir)
		    increment_text_pc (yypvt[-0].i);
		} break;
case 322:
# line 1765 "parser.y"
{
		  yyerror ("Warning: struct directive ignored");
		} break;
case 323:
# line 1771 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 324:
# line 1778 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0].i);
		} break;
case 325:
# line 1787 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 326:
# line 1794 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0].i);
		} break;
case 329:
# line 1808 "parser.y"
{
		  store_op = store_word_data;
		  if (data_dir) set_data_alignment (2);
		} break;
case 331:
# line 1818 "parser.y"
{only_id = 1;} break;
case 332:
# line 1818 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 333:
# line 1821 "parser.y"
{
		  yyval.p = make_addr_expr (0, NULL, yypvt[-1].i);
		} break;
case 334:
# line 1826 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-0].i, NULL, 0);
		} break;
case 335:
# line 1831 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-3].i, NULL, yypvt[-1].i);
		} break;
case 336:
# line 1836 "parser.y"
{
		  yyval.p = make_addr_expr (0, (char*)yypvt[-0].p, 0);
		  if (yypvt[-0].p) free ((char*)yypvt[-0].p);
		} break;
case 337:
# line 1842 "parser.y"
{
		  yyval.p = make_addr_expr (0, (char*)yypvt[-3].p, yypvt[-1].i);
		  if (yypvt[-3].p) free ((char*)yypvt[-3].p);
		} break;
case 338:
# line 1848 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  if (yypvt[-2].p) free ((char*)yypvt[-2].p);
		} break;
case 339:
# line 1854 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-2].i, (char*)yypvt[-0].p, 0);
		} break;
case 340:
# line 1859 "parser.y"
{
		  yyval.p = make_addr_expr (- yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  if (yypvt[-2].p) free ((char*)yypvt[-2].p);
		} break;
case 341:
# line 1865 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-3].i, (char*)yypvt[-5].p, yypvt[-1].i);
		  if (yypvt[-5].p) free ((char*)yypvt[-5].p);
		} break;
case 342:
# line 1871 "parser.y"
{
		  yyval.p = make_addr_expr (- yypvt[-3].i, (char*)yypvt[-5].p, yypvt[-1].i);
		  if (yypvt[-5].p) free ((char*)yypvt[-5].p);
		} break;
case 343:
# line 1878 "parser.y"
{only_id = 1;} break;
case 344:
# line 1878 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 345:
# line 1881 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-0].i, NULL, 0);
		} break;
case 346:
# line 1886 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-4].i >> yypvt[-0].i, NULL, 0);
		} break;
case 347:
# line 1891 "parser.y"
{
		  yyval.p = make_imm_expr (0, (char*)yypvt[-0].p, 0);
		} break;
case 348:
# line 1896 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  free ((char*)yypvt[-2].p);
		} break;
case 349:
# line 1902 "parser.y"
{
		  yyval.p = make_imm_expr (- yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  free ((char*)yypvt[-2].p);
		} break;
case 351:
# line 1912 "parser.y"
{yyval.i = yypvt[-2].i + yypvt[-0].i;} break;
case 352:
# line 1915 "parser.y"
{
		  /* Y_INT '-' Y_INT */
		  if (yypvt[-0].i >= 0)
		    yyerror ("Syntax error");
		  yyval.i = yypvt[-1].i - yypvt[-0].i;
		} break;
case 359:
# line 1936 "parser.y"
{
		  if (yypvt[-0].i < 0 || yypvt[-0].i > 31)
		    yyerror ("Register number out of range");
		  if (yypvt[-0].i == 1 && !bare_machine && !noat_flag)
		    yyerror ("Register 1 is reserved for assembler");
		  yyval = yypvt[-0];
		} break;
case 363:
# line 1951 "parser.y"
{
		  if (yypvt[-0].i < 0 || yypvt[-0].i > 31)
		    yyerror ("FP register number out of range");
		  yyval = yypvt[-0];
		} break;
case 366:
# line 1966 "parser.y"
{
		  yyval.p = make_imm_expr (- current_text_pc (), (char*)yypvt[-0].p, 1);
		} break;
case 369:
# line 1977 "parser.y"
{
		  store_string ((char*)yypvt[-0].p, y_str_length, null_term);
		  free ((char*)yypvt[-0].p);
		} break;
case 370:
# line 1982 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0].i; i ++)
		    store_string ((char*)yypvt[-2].p, y_str_length, null_term);
		  free ((char*)yypvt[-2].p);
		} break;
case 371:
# line 1992 "parser.y"
{only_id = 1;} break;
case 372:
# line 1992 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 374:
# line 1997 "parser.y"
{
		  label *l = lookup_label ((char*)yypvt[-0].p);

		  if (l->addr == 0)
		    {
		      record_data_uses_symbol (current_data_pc (), l);
		      yyval.p = NULL;
		    }
		  else
		    yyval.i = l->addr;
		} break;
case 375:
# line 2011 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 376:
# line 2015 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 377:
# line 2019 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0].i; i ++)
		    store_op (yypvt[-2].p);
		} break;
case 378:
# line 2029 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 379:
# line 2033 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 380:
# line 2039 "parser.y"
{only_id = 1;} break;
case 381:
# line 2039 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 383:
# line 2042 "parser.y"
{yyval.p = (void*)NULL;} break;
case 384:
# line 2046 "parser.y"
{only_id = 1;} break;
case 385:
# line 2046 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

