/*
 * node.c - common node reading functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: node.c,v 1.2 95/03/03 10:04:00 abe Exp $";
#endif


#include "lsof.h"


#if	defined(HASCDRNODE)
/*
 * readcdrnode() - read CD-ROM node
 */

int
readcdrnode(ca, c)
	caddr_t ca;			/* cdrnode kernel address */
	struct cdrnode *c;		/* cdrnode buffer */
{
	if (kread((KA_T)ca, (char *)c, sizeof(struct cdrnode))) {
		(void) sprintf(Namech, "can't read cdrnode at %#x", ca);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASCDRNODE) */


#if	defined(HASFIFONODE)
/*
 * readfifonode() - read fifonode
 */

int
readfifonode(fa, f)
	caddr_t fa;			/* fifonode kernel address */
	struct fifonode *f;		/* fifonode buffer */
{
	if (kread((KA_T)fa, (char *)f, sizeof(struct fifonode))) {
		(void) sprintf(Namech, "can't read fifonode at %#x", fa);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASFIFONODE) */


#if	defined(HASGNODE)
/*
 * readgnode() - read gnode
 */

int
readgnode(ga, g)
	caddr_t ga;			/* gnode kernel address */
	struct gnode *g;		/* gnode buffer */
{
	if (kread((KA_T)ga, g, sizeof(struct gnode))) {
		(void) sprintf(Namech, "can't read gnode at %#x", ga);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASGNODE) */


#if	defined(HASHSNODE)
/*
 * readhsnode() - read High Sierra file system node
 */

int
readhsnode(ha, h)
	caddr_t ha;			/* hsnode kernel address */
	struct hsnode *h;		/* hsnode buffer */
{
	if (kread((KA_T)ha, (char *)h, sizeof(struct hsnode))) {
		(void) sprintf(Namech, "can't read hsnode at %#x", ha);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASHSNODE) */


#if	defined(HASINODE)
/*
 * readinode() - read inode
 */

int
readinode(ia, i)
	struct inode *ia;		/* inode kernel address */
	struct inode *i;		/* inode buffer */
{
	if (kread((KA_T)ia, (char *)i, sizeof(struct inode))) {
		(void) sprintf(Namech, "can't read inode at %#x", ia);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASINODE) */


#if	defined(HASPIPENODE)
/*
 * readpipenode() - read pipe node
 */

int
readpipenode(pa, p)
	caddr_t pa;			/* pipe node kernel address */
	struct pipenode *p;		/* pipe node buffer */
{
	if (kread((KA_T)pa, (char *)p, sizeof(struct pipenode))) {
		(void) sprintf(Namech, "can't read pipenode at %#x", pa);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASPIPENODE) */


#if	defined(HASRNODE)
/*
 * readrnode() - read rnode
 */

int
readrnode(ra, r)
	caddr_t ra;			/* rnode kernel space address */
	struct rnode *r;		/* rnode buffer pointer */
{
	if (kread((KA_T)ra, (char *)r, sizeof(struct rnode))) {
		(void) sprintf(Namech, "can't read rnode at %#x", ra);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASRNODE) */


#if	defined(HASSNODE)
/*
 * readsnode() - read snode
 */

int
readsnode(sa, s)
	caddr_t sa;			/* snode kernel space address */
	struct snode *s;		/* snode buffer pointer */
{
	if (kread((KA_T)sa, (char *)s, sizeof(struct snode))) {
		(void) sprintf(Namech, "can't read snode at %#x", sa);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASSNODE) */


#if	defined(HASTMPNODE)
/*
 * readtnode() - read tmpnode
 */

int
readtnode(ta, t)
	caddr_t ta;			/* tmpnode kernel space address */
	struct tmpnode *t;		/* tmpnode buffer pointer */
{
	if (kread((KA_T)ta, (char *)t, sizeof(struct tmpnode))) {
		(void) sprintf(Namech, "can't read tmpnode at %#x", ta);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASTMPNODE) */


#if	defined(HASVNODE)
/*
 * readvnode() - read vnode
 */

int
readvnode(va, v)
	caddr_t va;			/* vnode kernel space address */
	struct vnode *v;		/* vnode buffer pointer */
{
	if (kread((KA_T)va, (char *)v, sizeof(struct vnode))) {
		(void) sprintf(Namech, "can't read vnode at %#x", va);
		return(1);
	}
	return(0);
}
#endif	/* defined(HASVNODE) */
