/* $Copyright: $
 * Copyright (c) 1995 by Steve Baker (ice@mama.indstate.edu)
 * All Rights reserved
 *
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchant-ability and fitness for a particular purpose.
 */
#include <utmp.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

static char *version = "$Version: $ rawtmp v1.2 (c) 1995 by Steve Baker $";

#define WTMP  "/etc/wtmp"

enum { FALSE=0, TRUE=1 };

struct tacacs_utmp {
  char ut_line[8];
  char ut_user[8];
  char ut_host[16];
  time_t ut_time;
};

char *num();
time_t getdate(), churn_time();

char *start = NULL, *end = NULL, *back = NULL;
time_t sd = 0, ed = 0, backtime = 0, curtime= 0;
int fd;

/*
 * rawtmp [-w wtmp] [-t] [-s start] [-e end] [-b hours:minutes:seconds]
 */
main(argc,argv)
int argc;
char **argv;
{
  char *file = WTMP, tacacs = FALSE;
  int i, j, n;

  for(n=i=1;i<argc;i=n) {
    n++;
    if (argv[i][0] == '-') {
      for(j=1;argv[i][j];j++) {
	switch (argv[i][j]) {
	  case 'w':
	    file = argv[n++];
	    break;
	  case 't':
	    tacacs = TRUE;
	    break;
	  case 'b':
	    back = argv[n++];
	    break;
	  case 's':
	    start = argv[n++];
	    break;
	  case 'e':
	    end = argv[n++];
	    break;
	  case '-':
	    if (j == 1) {
	      if (!strcmp("--help",argv[i])) usage(4);
	    }
	  default:
	    usage(1);
	}
      }
    } else {
    }
  }

  if (start) {
    if (isdigit(start[0])) {
      sd = getdate(start);
    } else usage(2);
  }
  if (end) {
    if (isdigit(end[0])) {
      ed = getdate(end) + 86399;
    } else usage(2);
  }
  if (back) backtime = (curtime=time(0)) - churn_time(back);

  fd = open(file,O_RDONLY);
  if (tacacs) doit_tacacs();
  else doit();
  close(fd);
}

doit()
{
  static char *ltype[] = {
    "UNKNOWN (0)", "Run Level", "Boot Time", "New Time", "Old Time",
    "INIT Process", "LOGIN Process", "User Process", "Dead Process", NULL
  };
  struct utmp u;
  unsigned char c;

  printf("  Time        User    ID  Line         Host               PID   Type\n");
  
  while (read(fd,&u,sizeof(struct utmp)) == sizeof(struct utmp)) {
    if (back && u.ut_time < backtime) continue;
    if (start && u.ut_time < sd) continue;
    if (end && u.ut_time > ed) continue;
    c = u.ut_id[0] & 0x7F;
    u.ut_id[0] = (c && (c > '~' || c < ' '))? '?' : c;
    c = u.ut_id[1] & 0x7F;
    u.ut_id[1] = (c && (c > '~' || c < ' '))? '?' : c;
/*
    printf("%-10ld: %-8.8s [%-2.2s] %-12.12s %-16.16s [%5d] %s\n",
	   u.ut_time,u.ut_user,u.ut_id,u.ut_line,u.ut_host,u.ut_pid & 0xFFFF,
	   (u.ut_type>0 && u.ut_type<9?ltype[u.ut_type]:num(u.ut_type)));
*/
    printf("%-10ld: %-8.8s [%-2.2s] %-12.12s %d.%d.%d.%d [%5d] %s\n",
	   u.ut_time,u.ut_user,u.ut_id,u.ut_line,
	   u.ut_addr&0xFF,(u.ut_addr>>8)&0xFF,(u.ut_addr>>16)&0xFF,(u.ut_addr>>24)&0xFF,
	   u.ut_pid & 0xFFFF,(u.ut_type>0 && u.ut_type<9?ltype[u.ut_type]:num(u.ut_type)));
			  
  }
}

doit_tacacs()
{
  struct tacacs_utmp u;
  unsigned char c;

  printf("  Time        User         Line            Host\n");

  while (read(fd,&u,sizeof(struct tacacs_utmp)) == sizeof(struct tacacs_utmp)) {
    if (back && u.ut_time < backtime) continue;
    if (start && u.ut_time < sd) continue;
    if (end && u.ut_time > ed) continue;

    printf("%-10ld: %-8.8s  [%-12.12s]  %-16.16s\n",
	   u.ut_time,u.ut_user,u.ut_line,u.ut_host);
  }
}


char *num(n)
unsigned short n;
{
  static char nbuf[30];

  sprintf(nbuf,"UNKNOWN (%d)",n);
  return nbuf;
}

/*
 * Turn "mm/dd/yy" into time in seconds.
 */
time_t getdate(s)
char *s;
{
  struct tm tm;
  int y;
  time_t t;

/*
 * <puke>
 * Need a real date parser that can handle different formats and separators
 */
  if (!isdigit(s[0]) || !isdigit(s[1]) || isdigit(s[2])) usage(2);
  if (!isdigit(s[3]) || !isdigit(s[4]) || isdigit(s[5])) usage(2);
  if (!isdigit(s[6]) || !isdigit(s[7]) || s[8]) usage(2);

  tm.tm_mon = atoi(s) -1;
  tm.tm_mday = atoi(s+3);
  y = atoi(s+6);
  tm.tm_year = (y < 70? 100 + y : y);
  tm.tm_isdst = tm.tm_hour = tm.tm_min = tm.tm_sec = 0;

  t = mktime(&tm);
  if (t == (time_t)(-1)) usage(2);
  return t;
}

time_t churn_time(s)
char *s;
{
  time_t t = 0, mult=3600;
  char nbuf[20], p;

  for(p=0;*s;s++) {
    if (*s == ':') {
      nbuf[p] = 0;
      t += atoi(nbuf) * mult;
      p = 0;
      if (mult > 1) mult /= 60;
      else usage(3);
    } else if (isdigit(*s)) {
      if (p < 15) nbuf[p++] = *s;
      else usage(3);
    } else usage(3);
  }
  nbuf[p] = 0;
  t += atoi(nbuf) * mult;

  return t;
}

usage(n)
int n;
{
  switch (n) {
    case 1:
      fprintf(stderr,"usage: rawtmp [-w wtmp] [-t] [-s start] [-e end] [-b H[:M[:S]]]\n");
      break;
    case 2:
      fprintf(stderr,"sac: Invalid date.  Format: mm/dd/yy\n");
      break;
    case 3:
      fprintf(stderr,"sac: Invalid time.  Format: hours[:minutes[:seconds]]\n");
      break;
    case 4:
      fprintf(stderr,"usage: rawtmp [-w wtmp] [-t] [-s start] [-e end] [-b H[:M[:S]]]\n");
      fprintf(stderr,"    -w wtmp     Read alternate wtmp file.\n");
      fprintf(stderr,"    -t          Read old decrepit wtmp format.\n");
      fprintf(stderr,"    -s start    Display accounting info from `start'.\n");
      fprintf(stderr,"    -e end      Display accounting info up to `end'.\n");
      fprintf(stderr,"    -b H:M:S    Show accounting info from the last few hours/minutes/seconds.\n");
      break;
  }
  exit(1);
}
