/*
 * write.c
 *
 * Write a line to the voice modem device.
 *
 */

#include "../include/voice.h"

char *libvoice_write_c = "$Id: write.c,v 1.5 1996/08/06 19:50:27 marc Exp $";

#if !defined(NeXT) || defined(NEXTSGTTY)
# include <varargs.h>
#else
# include "../include/NeXT.h"
#endif

int voice_write(format, va_alist)
     const char *format;
     va_dcl

     {
     va_list arguments;
     TIO tio;
     TIO save_tio;
     char command[VOICE_BUF_LEN];

     va_start(arguments);
     vsprintf(command, format, arguments);
     va_end(arguments);
     lprintf(L_JUNK, "%s: %s", program_name, command);

     delay(50);
     tio_get(voice_fd, &tio);
     save_tio = tio;
     tio.c_cc[VMIN] = 0;
     tio.c_cc[VTIME] = cvd.port_timeout.d.i;
     tio_set(voice_fd, &tio);

     if ((write(voice_fd, command, strlen(command)) != strlen(command)) ||
      (write(voice_fd, "\r", 1) != 1))
          {
          lprintf(L_ERROR, "could not write to voice modem device");
          tio_set(voice_fd, &save_tio);
          return(FAIL);
          };

     tio_set(voice_fd, &save_tio);
     return(OK);
     };
