


(defun proc-scheme-name (str)
  (save-match-data
    (let* ((answer (substring str 0))
	   (pos 0)
	   (len (length answer)))

      ;; "_" -> "-"
      ;;
      (while (< pos len)
	(cond
	 ((eq ?_ (aref answer pos)) (aset answer pos ?-)))
	(setq pos (+ 1 pos)))

      ;; "-equal-" -> "="
      ;;
      (if (string-match "-equal-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       "=-"
			       (substring answer (match-end 0)))))

      ;;
      (if (string-match "eq-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       "=-"
			       (substring answer (match-end 0)))))

      ;; "-less-" -> "<"
      ;;
      (if (string-match "-?less-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       "<-"
			       (substring answer (match-end 0)))))

      ;; "-leq-" -> "<="
      ;;
      (if (string-match "-?leq-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       "<=-"
			       (substring answer (match-end 0)))))
      ;; "-gr-" -> ">"
      ;;
      (if (string-match "-?gr-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       ">-"
			       (substring answer (match-end 0)))))

      ;; "-geq-" -> ">="
      ;;
      (if (string-match "-?geq-" answer)
	  (setq answer (concat (substring answer 0 (match-beginning 0))
			       ">=-"
			       (substring answer (match-end 0)))))
      ;; "-p" -> "?"
      ;;
      (if (string-match "-p$" answer)
	  (setq answer (concat (substring answer 0 (- (length answer) 2))
			       "?")))

      ;; "-x" -> "!"
      ;;
      (if (string-match "-x$" answer)
	  (setq answer (concat (substring answer 0 (- (length answer) 2))
			       "!")))

      ;; "-uve-" -> "->"
      ;;
      (while (string-match "^.*\\(-uve\\).*" answer)
	(setq answer (concat (substring answer 0 (match-beginning 1))
			     "-uniform-vector"
			     (substring answer (match-end 1)))))


      ;; "sys-" -> "%"
      ;;
      (while (string-match "^sys-" answer)
	(setq answer (concat "%" (substring answer 4))))

      ;; "-to-" -> "->"
      ;;
      (while (string-match "^.*\\(-to-\\).*" answer)
	(setq answer (concat (substring answer 0 (match-beginning 1))
			     "->"
			     (substring answer (match-end 1)))))

      ;; "-=" -> "="
      ;;
      (while (string-match "-=" answer)
	(setq answer (concat (substring answer 0 (match-beginning 0))
			     "="
			     (substring answer (match-end 0)))))

      

      answer)))

(defun no-of-matches (str from to)
  (save-match-data
    (save-excursion
      (goto-char from)
      (let ((n 0))
	(while (re-search-forward str to t)
	  (setq n (+ 1 n)))
	n))))

(defun procify ()
  (interactive)
  (re-search-forward "#ifdef __STDC__[ \t]*\nSCM[ \t]*\n\\(g?\\)scm_\\([^ (\n\t]*\\)\\(.*\\)")
  (goto-char (match-beginning 0))
  (let ((stub (buffer-substring (match-beginning 2) (match-end 2)))
	(prefix (buffer-substring (match-beginning 1) (match-end 1))))
    (insert "PROC (s_" stub ", \"" (proc-scheme-name stub) "\", " 
	    (number-to-string (no-of-matches "SCM" (match-beginning 3) (match-end 3)))
	    ", 0, 0, " prefix "scm_" stub ");\n")))



(global-set-key [f12] 'procify)
