/**
 *
 * $Id: CascadeB.c,v 1.33 1996/04/22 22:54:22 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: CascadeB.c,v 1.33 1996/04/22 22:54:22 miers Exp $";

/*
 * For CascadeButtonWidget, this should work now...
 *
 * Danny 17/4/96.
 */
#define	DO_GRABS

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/CascadeBP.h>
#include <Xm/CascadeBGP.h>
#include <Xm/DebugUtil.h>
#include <Xm/RowColumnP.h>
#include <Xm/TransltnsP.h>
#include <Xm/MenuShell.h>
#include <Xm/MenuUtilP.h>
#include <Xm/ScreenP.h>
#include <stdio.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void realize(Widget w, XtValueMask *value_mask, XSetWindowAttributes *attributes);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

/*
 * Resources for the cascade button class
 */
#define Offset(field) XtOffsetOf(XmCascadeButtonRec, cascade_button.field)
static XtResource resources[] = {
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNcascadingCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(cascade_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNsubMenuId, XmCMenuWidget, XmRMenuWidget,
	sizeof(Widget), Offset(submenu),
	XmRMenuWidget, (XtPointer)NULL
    },
    {
	XmNcascadePixmap, XmCPixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(cascade_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNmappingDelay, XmCMappingDelay, XmRInt,
	sizeof(int), Offset(map_delay),
	XmRImmediate, (XtPointer)180
    },
    /* resources we override from XmLabel/XmPrimitive */
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmCascadeButtonRec, primitive.shadow_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmCascadeButtonRec, primitive.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmCascadeButtonRec, primitive.highlight_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmCascadeButtonRec, label.margin_width),
	XmRImmediate, (XtPointer)0x0000FFFF
    }
};

void CleanupMenuBar(Widget w, XEvent *event, String *params, Cardinal *num_params);

static void StartDrag(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void DoSelect(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Help(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void KeySelect(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuBarSelect(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuBarEnter(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void DelayedArm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void CheckDisarm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuFocusIn(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuFocusOut(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmCascadeB_menubar_events[] = 
   "<EnterWindow>Normal:     MenuBarEnter()\n\
    <LeaveWindow>Normal:     MenuBarLeave()\n\
    <BtnDown>:               MenuBarSelect()\n\
    <BtnUp>:                 DoSelect()\n\
    <Key>osfSelect:          KeySelect()\n\
    <Key>osfActivate:        KeySelect()\n\
    <Key>osfHelp:            Help()\n\
    <Key>osfCancel:          CleanupMenuBar()\n\
    ~s <Key>Return:          KeySelect()\n\
    ~s <Key>space:           KeySelect()";

char _XmCascadeB_p_events[] =
   "<EnterWindow>:           DelayedArm()\n\
    <LeaveWindow>:           CheckDisarm()\n\
    <BtnDown>:               StartDrag()\n\
    <BtnUp>:                 DoSelect()\n\
    <Key>osfSelect:          KeySelect()\n\
    <Key>osfActivate:        KeySelect()\n\
    <Key>osfHelp:            Help()\n\
    <Key>osfCancel:          CleanupMenuBar()\n\
    ~s <Key>Return:          KeySelect()\n\
    ~s <Key>space:           KeySelect()";

static XtActionsRec actions[] = {
    {"MenuBarSelect", MenuBarSelect},
    {"MenuBarEnter", MenuBarEnter},
    {"StartDrag", StartDrag},
    {"DoSelect", DoSelect},
    {"KeySelect", KeySelect},
    {"Help", Help},
    {"CleanupMenuBar", CleanupMenuBar},
    {"EnterWindow", EnterWindow},
    {"LeaveWindow", LeaveWindow},
    {"DelayedArm", DelayedArm},
    {"CheckDisarm", CheckDisarm},
    {"MenuFocusIn", MenuFocusIn},
    {"MenuFocusOut", MenuFocusOut},
};

static XmBaseClassExtRec _XmCascadeBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

XmPrimitiveClassExtRec _XmCascadeBPrimClassExtRec = {
    /* next_extension      */ NULL,
    /* record_type         */ NULLQUARK,
    /* version             */ XmPrimitiveClassExtVersion,
    /* record_size         */ sizeof(XmPrimitiveClassExtRec),
    /* widget_baseline     */ NULL, /* FIX ME */
    /* widget_display_rect */ NULL, /* FIX ME */
    /* widget_margins      */ NULL  /* FIX ME */
};

XmCascadeButtonClassRec xmCascadeButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelClassRec,
        /* class_name            */ "XmCascadeButton",
	/* widget_size           */ sizeof(XmCascadeButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ realize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmCascadeBCoreClassExtRec
    },
    /* Primitive Class part */
    {
	/* border_highlight      */ XmInheritBorderHighlight,
        /* border_unhighlight    */ XmInheritBorderUnhighlight,
        /* translations          */ XtInheritTranslations,
        /* arm_and_activate_proc */ XmInheritArmAndActivate,
        /* synthetic resources   */ NULL,
	/* num syn res           */ 0,
        /* extension             */ (XtPointer)&_XmCascadeBPrimClassExtRec,
    },
    /* Label Class part */
    {
        /* setOverrideCallback */ XmInheritSetOverrideCallback,
        /* menuProcs           */ XmInheritMenuProc,
        /* translations        */ XtInheritTranslations,
	/* extension           */ NULL
    },
    /* CascadeButton Class part */
    {
	/* extension */ NULL
    }
};

WidgetClass xmCascadeButtonWidgetClass = (WidgetClass)&xmCascadeButtonClassRec;

static void
class_initialize()
{
    _XmCascadeBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmCASCADE_BUTTON_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    CB_SetArmed(new, False);

    if (!XtIsSubclass(XtParent(new), xmRowColumnWidgetClass))
	_XmError(new, "Cascade parent must be a RowColumn.");

    if (Lab_MenuType(new) != XmMENU_BAR &&
        Lab_MenuType(new) != XmMENU_POPUP &&
	Lab_MenuType(new) != XmMENU_PULLDOWN &&
	Lab_MenuType(new) != XmMENU_OPTION)
	_XmError(new, "Cascade parent is incorrect type.");
    else
    {
	Lab_Highlight(new) = 0;
    }

    if (Lab_MenuType(new) == XmMENU_BAR)
	XtOverrideTranslations(new, XtParseTranslationTable(_XmCascadeB_menubar_events));
    else if (Lab_MenuType(new) == XmMENU_POPUP || Lab_MenuType(new) == XmMENU_PULLDOWN)
    {
	XtOverrideTranslations(new, XtParseTranslationTable(_XmCascadeB_p_events));
    }

    if (Lab_MarginWidth(new) == 0x0000FFFF)
    {
	/* do something funky for the pixmap, but for now do nothing -- FIX ME! */
	Lab_MarginWidth(new) = 0;
    }

    _XmLabelRecomputeSize(new);
    CB_Timer(new) = 0;
}

static void
destroy(Widget w)
{
    _XmFreeScratchPixmap((XmScreen)XmGetXmScreen(XtScreen(w)), CB_ArmedPixmap(w));
    _XmFreeScratchPixmap((XmScreen)XmGetXmScreen(XtScreen(w)), CB_CascadePixmap(w));
}

static void 
realize(Widget w, 
	XtValueMask *value_mask, 
	XSetWindowAttributes *attributes)
{
#define superclass (&xmLabelClassRec)
    (*superclass->core_class.realize)(w, value_mask, attributes);
#undef superclass
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = False;

    if (CB_CascadePixmap(old) != CB_CascadePixmap(new))
    {
#if 0
	XFreePixmap(XtDisplay(old), CB_CascadePixmap(old));
	XFreePixmap(XtDisplay(new), CB_ArmedPixmap(new));
#endif
	refresh_needed = True;
    }

    return refresh_needed;
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
#define superclass (&xmLabelClassRec)
    (*superclass->core_class.expose)(w, event, region);
#undef superclass
    XdbDebug(__FILE__, w, "expose() Armed(%d)\n", CB_IsArmed(w));

    if (CB_IsArmed(w) || Lab_MenuType(w) == XmMENU_OPTION)
	XmCascadeButtonHighlight(w, True);
    else
	XmCascadeButtonHighlight(w, False);
}

/* Not static : we need to call this for TearOff */
void
CleanupMenuBar(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Widget top_menu;

    XdbDebug(__FILE__, w, "CleanupMenuBar()\n");

    if (w == NULL)
	return;		/* Try not to crash */

    /* Locate the top-level menu associated with this cascade button */
    top_menu = RC_LastSelectToplevel(XtParent(w));

    if (!top_menu)
	top_menu = XtParent(w);

    /* Make sure a valid menu was found */
    if (top_menu && XmIsRowColumn(top_menu) &&
	(RC_Type(top_menu) != XmWORK_AREA) &&
	(RC_Type(top_menu) != XmMENU_OPTION))
    {
	Widget menu_shell;

	/* Get the menu shell associated with the currently posted menu */
	menu_shell = RC_PopupPosted(top_menu);

	/* Popdown the menu cascade if it is popped up */
	if (menu_shell && XmIsMenuShell(menu_shell))
        {
	    /* Release the keyboard and pointer grabs */
	    XUngrabKeyboard(XtDisplay(w), CurrentTime);
	    XUngrabPointer(XtDisplay(w), CurrentTime);

	    XdbDebug(__FILE__, w, "   Doing MenuShellPopdownDone(%s)\n",
		     XtName(menu_shell));
	    
	    XtCallActionProc(menu_shell, "MenuShellPopdownDone",
			     event, NULL, 0);

	    /* Release any grab associated with the top level menu widget */
	    XdbDebug(__FILE__, w, "   Doing XtRemoveGrab(%s)\n",
		     XtName(top_menu));

	    XtRemoveGrab(top_menu);
	}
    }
    else 
    {
	_XmWarning(w, "CascadeButton's parent is not a valid menu widget");
    }
}

static void
KeySelect(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "KeySelect\n");
    /* If we're in keyboard traversal mode, and if we have a submenu 
       attached, call the cascading callback, post the submenu and 
       allow keyboard traversal of it. */

    /* else call the activate callback, and unpost all active menus
       in the cascade */
}

static void 
Help(Widget w,
     XEvent *event,
     String *params,
     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "Help\n");
}

static void
EnterWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "EnterWindow\n");
}

static void
MenuBarEnter(Widget w,
	     XEvent *event,
	     String *params,
	     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuBarEnter\n");

    XtCallActionProc(w, "PrimitiveEnter", event, params, *num_params);    

    /* If the BSelect button is down, treat this like a select event */
    if ((event->xcrossing.type == EnterNotify) &&
	(event->xcrossing.state & Button1Mask) && (!CB_IsArmed(w)))
    {
	XtCallActionProc(w, "MenuBarSelect", event, params, *num_params);

        /* 'MenuBarSelect' will have release next pointer event already */
    }
    else
    {
        /* Release the next pointer event */
        XdbDebug(__FILE__, w, "    Doing XAllowEvents(SyncPointer)\n");
        XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
    }

}

static void
LeaveWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "LeaveWindow\n");

    XtCallActionProc(w, "PrimitiveLeave", event, params, *num_params);    

    if (CB_IsArmed(w))
	XmCascadeButtonHighlight(w, False);
}

static void
DoSelect(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "DoSelect()\n");

    XdbDebug(__FILE__, w, "    Doing XAllowEvents(SyncPointer)\n");
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    /* if we have a submenu attached, call the cascading callback, 
       post the submenu and allow keyboard traversal of it. */

    if (CB_Submenu(w)) {
	/* Turn on keyboard traversal */
	_XmSetInDragMode(w, False);


	RC_CascadeBtn(CB_Submenu(w)) = w;
	RC_PopupPosted(XtParent(w)) = XtParent(CB_Submenu(w));
    }
}

static void
MenuBarSelect(Widget w,
	      XEvent *event,
	      String *params,
	      Cardinal *num_params)
{
    Window	window_return;
    int		revert_to_return;
    Widget	menu, shell, mb;
/*
 * We're triggered by a CB or CBG, child of the menu bar
 */

    mb = XtParent(w);
    menu = CB_Submenu(w);
    shell = menu ? XtParent(menu) : NULL;

/*
 * If this button is already armed, remove only any cascaded sub-menus and then
 * simply enable drag mode.
 */

/*
 * Check if our menu is already up
 */
    if (((ShellWidget)shell)->shell.popped_up || CB_IsArmed(w)) {
	XdbDebug(__FILE__, w, "MenuBarSelect: Menu is already up (Shell %s, Menu Pane %s)\n",
		shell ? XtName(shell) : "(null)",
		menu ? XtName(menu) : "(null)");

/* Popdown any sub menu levels */

	_XmUngrabKeyboard(mb, CurrentTime);
	XtRemoveGrab(mb);
	_XmUngrabPointer(w, CurrentTime);

	XtCallActionProc(shell, "MenuShellPopdownDone", event, NULL, 0);

/* Set drag mode */
	_XmSetInDragMode(w, True);
    }
    else 
    {
	XdbDebug(__FILE__, w, "MenuBarSelect : need to pop up a menu (Shell %s, Menu Pane %s)\n",
		shell ? XtName(shell) : "(null)",
		menu ? XtName(menu) : "(null)");

/*
 * Pop up a menu
 */
	CleanupMenuBar(w, event, params, num_params);
#ifdef	DO_GRABS
	/* grab the keyboard and freeze everything so that we can be sure that
	   the next keyboard event goes to the right place. */
	XdbDebug(__FILE__, w, "    Doing XmGrabKeyboard\n");

	_XmGrabKeyboard(mb, True,
			GrabModeSync,
			GrabModeSync,
			CurrentTime);
#endif

	/* get the window that previously had the focus
	   before popping up the menu so we can revert 
	   to it after we're done. */
	XdbDebug(__FILE__, w, "    Doing XGetInputFocus\n");
	XGetInputFocus(XtDisplay(w),
		       &window_return,
		       &revert_to_return);
    
	/* Now we set the focus to us, so that we'll arm ourselves and
	   drop down our menu immediately. FIX ME -- this may take place
	   in the RowColumn so that it can handle it for gadgets. */
	XdbDebug(__FILE__, w, "    Doing XSetInputFocus\n");
	XSetInputFocus(XtDisplay(w),
		       XtWindow(w),
		       RevertToParent,
		       CurrentTime);
#ifdef	DO_GRABS
	/* We can unfreeze the keyboard events, 
	   since the input focus has been set */
	XdbDebug(__FILE__, w, "    Doing XAllowEvents(AsyncKeyboard)\n");
	XAllowEvents(XtDisplay(w), 
		     AsyncKeyboard,
		     CurrentTime);
#endif

	XmCascadeButtonHighlight(w, True);

	CB_SetArmed(w, True);

	if (menu && XmIsMenuShell(shell))
        {
	    Widget sub_menu_pane;
	    Position my_x, my_y;

	/* Register inside the RC that this cascadebutton is the one that triggered the menu */
	    XmRowColumnWidget	rc = (XmRowColumnWidget)menu;

	    rc->row_column.cascadeBtn = w;

	    /* make sure the menu is popped down */
	    XtUnmapWidget(shell);
	    
	    /* position the row column inside the menushell*/
	    XtMoveWidget(menu, 0,0);
	    
	    /* now move the menushell */
	    XtTranslateCoords(w, 0, 0, &my_x, &my_y);
	    XtMoveWidget(shell,
			 my_x,
			 my_y + XtHeight(w));
	    
	    XtCallCallbackList(w,
			       CB_CascadeCall(w),
			       NULL);

	    sub_menu_pane = menu;
	    RC_CascadeBtn(menu) = w;
	    RC_PopupPosted(mb) = shell;
	    
	    /* the menu bar is the top of the cascade */
	    RC_LastSelectToplevel(sub_menu_pane) = mb;

/*
 * Add the menu bar to the TOP of the modal cascade, as an exclusive grab.
 * This causes all pointer events which occur outside the menu
 * cascade to be delivered to the menu bar widget.  It is 
 * essential to have at least one widget in the cascade own an 
 * exclusive grab, because otherwise external events would be
 * suppressed by the Intrinsics.  This would prevent us from
 * releaseing the next pointer event in the server, and hence the
 * system would lock.
 */
	    XdbDebug(__FILE__, w, "    Doing XtAddGrab(menu-bar)\n");
	    XtAddGrab(mb, True, False);

	    if (! XtIsRealized(menu)) {
		XdbDebug2(__FILE__, w, menu, "XtMapWidget(child) - managing first\n");
		XtManageChild(menu);
	    } else
		XdbDebug2(__FILE__, w, menu, "XtMapWidget(child)\n");

/*
 * Popup the menu shell, and append it to the modal cascade.
 * Must be done after adding grab for menu bar, so that the menu
 * bar is the first widget in the modal cascade.
 */
	    XtPopup(shell, XtGrabNonexclusive);

	    XtMapWidget(menu);

#ifdef	DO_GRABS
/* Initiate a new pointer grab for the menu bar */
#ifdef	notdef
/* This doesn't seem all that bad */
	    _XmGrabPointer(XtParent(w), True,
			   ButtonPressMask | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask,
			   GrabModeSync,
			   GrabModeAsync,
			   None,
			   XmGetMenuCursor(XtDisplay(w)),
			   CurrentTime);
#else
/* Experiment Danny 28/3 */
	    _XmGrabPointer(menu, True,
			   ButtonPressMask | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask,
			   GrabModeSync,
			   GrabModeAsync,
			   None,
			   XmGetMenuCursor(XtDisplay(w)),
			   CurrentTime);
#endif
#endif
	    
	    _XmSetInDragMode(w, True);
	    
	    XSetInputFocus(XtDisplay(menu), XtWindow(menu), RevertToParent, CurrentTime);
	} else if (CB_Submenu(w)) {
	    _XmWarning(w, "CascadeButton's popup must be a subclass of XmMenuShell\n");
	}
    }
#ifdef	DO_GRABS
/* Signal server to release next pointer event */
    XdbDebug(__FILE__, w, "    Doing XAllowEvents(SyncPointer)\n");
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
#endif
}

static void
StartDrag(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    Boolean validButton;

    XdbDebug(__FILE__, w, "StartDrag()\n");

    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    if (event && (event->type == ButtonPress))
    {
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON, XtParent(w), NULL, event, &validButton);
	if (!validButton)
	    return;
    }

    /* Arm the cascade button, post the submenu, and enable mouse
       traversal on it. */

    XmCascadeButtonHighlight(w, True);

    CB_SetArmed(w, True);

    /* If the submenu is already active, disable keyboard traversal
       and set it to mouse traversal */

    if (CB_Submenu(w) && XmIsMenuShell(XtParent(CB_Submenu(w))))
    {
	Widget sub_menu_pane = CB_Submenu(w);
	Widget parent_top_level;
	Position my_x, my_y;

/* This seems to have problems */	
/*	XtUnmapWidget(CB_Submenu(w));*/
	
	/* position the row column inside the menushell*/
	XtMoveWidget(sub_menu_pane, 0,0);

	XtTranslateCoords(w, 0, 0, &my_x, &my_y);

	XtMoveWidget(XtParent(sub_menu_pane),
                     my_x + XtWidth(w) - Lab_Shadow(w),
                     my_y);

	XtCallCallbackList(w,
			   CB_CascadeCall(w),
			   NULL);

	RC_CascadeBtn(sub_menu_pane) = w;
	RC_PopupPosted(XtParent(w)) = XtParent(sub_menu_pane);

	/* This is a cascade button is a menu pane, so the top level widget
	   is the button's parent's top level widget */
	parent_top_level = RC_LastSelectToplevel(XtParent(w));

	/* If the parent has no top level widget set, then it must be the
	   first menu in the hierarchy */
	if (parent_top_level)
	    RC_LastSelectToplevel(sub_menu_pane) = parent_top_level;
	else
	    RC_LastSelectToplevel(sub_menu_pane) = XtParent(w);

	XdbDebug(__FILE__, w, "    Top level menu is %s\n",
		 XtName(RC_LastSelectToplevel(sub_menu_pane)));

	XtPopup(XtParent(CB_Submenu(w)), XtGrabNonexclusive);

	XtMapWidget(CB_Submenu(w));
    }
    else if (CB_Submenu(w))
    {
        _XmWarning(w,
                   "CascadeButton's popup must be a subclass of XmMenuShell\n");
        return;
    }

    _XmSetInDragMode(w, True);
}

static void 
CascadePopupHandler(XtPointer clientData, XtIntervalId *id)
{
    Widget w = (Widget)clientData;

    XdbDebug(__FILE__, w, "CascadePopupHandler\n");

    CB_Timer(w) = 0;

    if (CB_Submenu(w) && XmIsMenuShell(XtParent(CB_Submenu(w))))
    {
	Widget sub_menu_pane = CB_Submenu(w);
	Widget parent_top_level;
	Position my_x, my_y;
	
	/* make sure the menu is popped down */

/* This seems to have problems */	
/*	XtUnmapWidget(CB_Submenu(w));*/
	
	/* position the row column inside the menushell*/
	XtMoveWidget(sub_menu_pane, 0,0);

	/* now move the menushell */
	XtTranslateCoords(w, 0, 0, &my_x, &my_y);
	XtMoveWidget(XtParent(sub_menu_pane),
                     my_x + XtWidth(w) - Lab_Shadow(w),
                     my_y);

	XtCallCallbackList(w,
			   CB_CascadeCall(w),
			   NULL);

	RC_CascadeBtn(sub_menu_pane) = w;
	RC_PopupPosted(XtParent(w)) = XtParent(sub_menu_pane);

	/* This is a cascade button is a menu pane, so the top level widget
	   is the button's parent's top level widget */
	parent_top_level = RC_LastSelectToplevel(XtParent(w));

	/* If the parent has no top level widget set, then it must be the
	   first menu in the hierarchy */
	if (parent_top_level)
	    RC_LastSelectToplevel(sub_menu_pane) = parent_top_level;
	else
	    RC_LastSelectToplevel(sub_menu_pane) = XtParent(w);

	XdbDebug(__FILE__, w, "    Top level menu is %s\n",
		 XtName(RC_LastSelectToplevel(sub_menu_pane)));

	XtPopup(XtParent(sub_menu_pane), XtGrabNonexclusive);

	XtMapWidget(sub_menu_pane);
    }
    else if (CB_Submenu(w))
    {
	_XmWarning(w,
                   "CascadeButton's popup must be a subclass of XmMenuShell\n");
        return;
    }
}

static void 
DelayedArm(Widget w, 
           XEvent *event, 
           String *params, 
           Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "DelayedArm()\n");

    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    if (_XmGetInDragMode(w)) 
    {
	CB_Timer(w) = XtAppAddTimeOut(XtWidgetToApplicationContext(w),
				      CB_MapDelay(w),
				      CascadePopupHandler,
				      (XtPointer)w);

	XmCascadeButtonHighlight(w, True);
	
	CB_SetArmed(w, True);
    }
}

static void 
CheckDisarm(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "CheckDisarm()\n");

    if (_XmGetInDragMode(w)) 
    {
	if (CB_Timer(w))
	{
	    XtRemoveTimeOut(CB_Timer(w));
	    CB_Timer(w) = 0;
	}

	XmCascadeButtonHighlight(w, False);
	
	CB_SetArmed(w, False);
    }
}

static void 
MenuFocusIn(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuFocusIn()\n");
}

static void 
MenuFocusOut(Widget w, 
	     XEvent *event, 
	     String *params, 
	     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuFocusOut()\n");
}

void
_XmCBHelp(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
}

void
_XmCascadingPopup(Widget cb, XEvent *event, Boolean doCascade)
{
}

void
XmCascadeButtonHighlight(Widget cascadeButton, 
			 Boolean highlight)
{
    if (XmIsPrimitive(cascadeButton))
    {
	_XmDrawShadows(XtDisplayOfObject(cascadeButton),
		       XtWindowOfObject(cascadeButton),
		       Prim_TopShadowGC(cascadeButton),
		       Prim_BottomShadowGC(cascadeButton),
		       0,0,
		       XtWidth(cascadeButton),
		       XtHeight(cascadeButton),
		       Lab_Shadow(cascadeButton),
		       highlight ? XmSHADOW_OUT : XmNO_LINE);

	/* now draw the pixmap */
    }
    else if (XmIsGadget(cascadeButton))
    {    
	_XmDrawShadows(XtDisplayOfObject(cascadeButton),
		       XtWindowOfObject(cascadeButton),
		       XmParentTopShadowGC(cascadeButton),
		       XmParentBottomShadowGC(cascadeButton),
		       XtX(cascadeButton),
		       XtY(cascadeButton),
		       XtWidth(cascadeButton),
		       XtHeight(cascadeButton),
		       LabG_Shadow(cascadeButton),
		       highlight ? XmSHADOW_OUT : XmNO_LINE);

	/* now draw the pixmap */
    }
    else
	_XmError(cascadeButton, "XmCascadeButtonHighlight called with non-cascade button widget");
}

Widget
XmCreateCascadeButton(Widget parent,
		      char *name,
		      Arg *arglist,
		      Cardinal argcount)
{
    return XtCreateWidget(name, 
			  xmCascadeButtonWidgetClass,
			  parent,
			  arglist, argcount);
}
