/**
 *
 * $Id: LabelG.c,v 1.28 1996/04/25 03:24:25 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: LabelG.c,v 1.28 1996/04/25 03:24:25 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/DebugUtil.h>
#include <Xm/LabelGP.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuShell.h>
#include <Xm/CacheP.h>
#include <stdio.h>
#include <Xm/XmosP.h>
#include <X11/Xfuncs.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void resize(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static void get_values_hook(Widget w, ArgList args, Cardinal *num_args);

static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void labelg_menu_procs(int function, Widget menushell_parent, ...);

static void secondary_object_create(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_prehook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_prehook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_posthook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_prehook(Widget new, ArgList args, Cardinal *num_args);
static void get_values_posthook(Widget new, ArgList args, Cardinal *num_args);
static Cardinal get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data);


/*
 * resources
 */
#define Offset(field) XtOffsetOf(XmLabelGCacheObjRec, label_cache.field)
static XtResource cache_resources[] = {
    {
	XmNlabelType, XmCLabelType, XmRLabelType,
	sizeof(unsigned char), Offset(label_type),
	XmRImmediate, (XtPointer)XmSTRING
    },
    {
	XmNalignment, XmCAlignment, XmRAlignment,
	sizeof(unsigned char), Offset(alignment),
	XmRImmediate, (XtPointer)XmALIGNMENT_CENTER
    },
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_width),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_height),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNmarginLeft, XmCMarginLeft, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_left),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginRight, XmCMarginRight, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_right),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginTop, XmCMarginTop, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_top),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginBottom, XmCMarginBottom, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_bottom),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNrecomputeSize, XmCRecomputeSize, XmRBoolean,
	sizeof(Boolean), Offset(recompute_size),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNstringDirection, XmCStringDirection, XmRStringDirection,
	sizeof(XmStringDirection), Offset(string_direction),
	XmRImmediate, (XtPointer)((XmStringDirection)XmUNSPECIFIED)
    }
};

static XmSyntheticResource cache_syn_resources[] = {
    {
	XmNmarginWidth,
	sizeof(Dimension), Offset(margin_width),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginHeight,
	sizeof(Dimension), Offset(margin_height),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNmarginLeft,
	sizeof(Dimension), Offset(margin_left),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginRight,
	sizeof(Dimension), Offset(margin_right),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginTop,
	sizeof(Dimension), Offset(margin_top),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNmarginBottom,
	sizeof(Dimension), Offset(margin_bottom),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
};

XmLabelGCacheObjClassRec xmLabelGCacheObjClassRec = {
    /* Object class part */
    {
	/* superclass            */ (WidgetClass) &xmExtClassRec,
        /* class_name            */ "XmLabelGCacheObjClass",
	/* widget_size           */ sizeof(XmLabelGCacheObjRec),
	/* class_initialize      */ NULL,
	/* class_part_initialize */ NULL,
	/* class_inited          */ FALSE,
	/* initialize            */ NULL,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ cache_resources,
	/* num_resources         */ XtNumber(cache_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ NULL,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ cache_syn_resources,
        /* num_syn_resources  */ XtNumber(cache_syn_resources),
        /* extension          */ NULL
    },
    /* LabelGCacheObj part */
    {
	/* foo                */ 0
    }
};

#undef Offset
#define Offset(field) XtOffsetOf(XmLabelGadgetRec, label.field)

/* Resources for the label class */
static XtResource resources[] = {
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmLabelGadgetRec, gadget.shadow_thickness),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNlabelPixmap, XmCLabelPixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNlabelInsensitivePixmap, XmCLabelInsensitivePixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(pixmap_insen),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNlabelString, XmCXmString, XmRXmString,
	sizeof(XmString), Offset(_label),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNfontList, XmCFontList, XmRFontList,
	sizeof(XmFontList), Offset(font),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNmnemonic, XmCMnemonic, XmRKeySym,
	sizeof(KeySym), Offset(mnemonic),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNmnemonicCharSet, XmCMnemonicCharSet, XmRString,
	sizeof(String), Offset(mnemonicCharSet),
	XmRImmediate, (XtPointer)XmFONTLIST_DEFAULT_TAG
    },
    {
	XmNaccelerator, XmCAccelerator, XmRString,
	sizeof(String), Offset(accelerator),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNacceleratorText, XmCAcceleratorText, XmRXmString,
	sizeof(XmString), Offset(_acc_text),
	XmRImmediate, (XtPointer)NULL
    },
    /* Things we override from Gadget */
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmLabelGadgetRec,gadget.traversal_on),
	XmRImmediate, (XtPointer)False
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmLabelGadgetRec,gadget.highlight_thickness),
	XmRImmediate, (XtPointer)0
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNlabelString,
	sizeof(XmString), Offset(_label),
	NULL /* FIXME */, NULL
    },
    {
	XmNaccelerator,
	sizeof(XmString), Offset(_acc_text),
	NULL /* FIXME */, NULL
    },
    {
	XmNacceleratorText,
	sizeof(String), Offset(accelerator),
	NULL /* FIXME */, NULL
    },
    {
	XmNmnemonicCharSet,
	sizeof(String), Offset(mnemonicCharSet),
	NULL /* FIXME */, NULL
    }
};

static XmBaseClassExtRec _XmLabelGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ initialize_prehook,
    /* set_values_prehook        */ set_values_prehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ set_values_posthook,
    /* secondary_object_class    */ (WidgetClass)&xmLabelGCacheObjClassRec,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ get_sec_res_data,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ get_values_prehook,
    /* get_values_posthook       */ get_values_posthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmCacheClassPart cache_part = {
    /* cache head part */
    {
	/* next		*/ NULL,
	/* prev		*/ NULL,
	/* ref_count	*/ 0
    },
    _XmCacheCopy,
    _XmCacheDelete,
    _XmLabelCacheCompare
};

static XmGadgetClassExtRec _XmLabelGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

XmLabelGadgetClassRec xmLabelGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmGadgetClassRec,
	/* class_name            */ "XmLabelGadget",
	/* widget_size           */ sizeof(XmLabelGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeNoCompress,
	/* compress_enterleave   */ FALSE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ get_values_hook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmLabelGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight, /* fix me */
	/* arm_and_activate   */ NULL, /* fix me */
	/* input_dispatch     */ input_dispatch,
	/* visual_change      */ XmInheritVisualChange, /* fix me */
	/* syn_resources      */ syn_resources,
	/* num_syn_resources  */ XtNumber(syn_resources),
	/* cache_part         */ &cache_part,
	/* extension          */ (XtPointer)&_XmLabelGadgetClassExtRec
    },
    /* XmLabelGadget part */
    {
        /* setOverrideCallback */ NULL, /* fix me */
        /* menuProcs           */ labelg_menu_procs, 
	/* extension           */ NULL
    },
};

WidgetClass xmLabelGadgetClass = (WidgetClass)&xmLabelGadgetClassRec;

extern XmFontList _XmFontListCreateDefault(Display *);

/******************************** CACHE PART *********************************/
static void
secondary_object_create(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XtPointer nsec, rsec;
    XmWidgetExtData ed;
    int size;

    XdbDebug(__FILE__, new, "LabelGCacheRec %s being initialized.\n", XtName(new));

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);

    size = (*bce)->secondaryObjectClass->core_class.widget_size;
    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    XtGetSubresources(new, nsec, NULL, NULL,
                      (*bce)->secondaryObjectClass->core_class.resources,
                      (*bce)->secondaryObjectClass->core_class.num_resources,
                      args, *num_args);

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    LabG_Cache(new) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);
}

int
_XmLabelCacheCompare(XtPointer A, XtPointer B)
{
    return !memcmp(((XmLabelGCacheObjPart *)A),
		   ((XmLabelGCacheObjPart *)B),
		   sizeof(XmLabelGCacheObjPart));
}

void
_XmCalcLabelGDimensions(Widget wid)
{
}

void
_XmReCacheLabG(Widget w)
{
}

void
_XmAssignLabG_MarginHeight(XmLabelGadget lw, Dimension value)
{
}

void
_XmAssignLabG_MarginWidth(XmLabelGadget lw, Dimension value)
{
}

void
_XmAssignLabG_MarginLeft(XmLabelGadget lw, Dimension value)
{
}

void
_XmAssignLabG_MarginRight(XmLabelGadget lw, Dimension value)
{
}

void
_XmAssignLabG_MarginTop(XmLabelGadget lw, Dimension value)
{
}

void
_XmAssignLabG_MarginBottom(XmLabelGadget lw, Dimension value)
{
}

void
_XmProcessDrag(Widget w, XEvent *event,
	       String *params, Cardinal *num_params)
{
}

/******************************* GADGET PART *********************************/
static void
class_initialize()
{
    /* don't let the nulls fool you.  look at the header file -- the arg
     * isn't used. */
    ClassCacheHead(LabG_ClassCachePart(NULL)).prev =
	&ClassCacheHead(LabG_ClassCachePart(NULL));
    ClassCacheHead(LabG_ClassCachePart(NULL)).next =
	&ClassCacheHead(LabG_ClassCachePart(NULL));

    _XmLabelGRectClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    XmLabelGadgetClass lwc = (XmLabelGadgetClass)widget_class;

    if (lwc->label_class.menuProcs == XmInheritMenuProc)
	lwc->label_class.menuProcs = labelg_menu_procs;

    _XmFastSubclassInit(widget_class, XmLABEL_GADGET_BIT);
}

static void
CreateNormalGC(XmLabelGadget lw)
{
    XGCValues values;

    values.foreground = XmParentForeground(lw);
    values.background = XmParentBackground(lw);

    LabG_NormalGC(lw) = XtGetGC((Widget)lw, GCForeground | GCBackground, &values);
}

static void 
CreateInsensitiveGC(XmLabelGadget lw)
{
    XGCValues values;

    values.foreground = XmParentForeground(lw);
    values.background = XmParentBackground(lw);
    values.fill_style = FillStippled;

    LabG_InsensitiveGC(lw) = XtGetGC((Widget)lw, GCForeground | GCBackground | GCFillStyle, &values);
}

static void
initialize_prehook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "LabelG InitializePrehook\n");
}

static void
initialize_posthook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XmWidgetExtData ext;

    XdbDebug(__FILE__, new, "LabelG InitializePosthook\n");

    /* don't let the null fool you */
    LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
                                   (XtPointer)LabG_Cache(new),
                                   sizeof(XmLabelGCacheObjPart));

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);
    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);
    XtFree((char *)ext);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmLabelGadget lg = (XmLabelGadget) new;

    XdbDebug(__FILE__, new, "LabelGadget initialize w,h before: %d %d\n",
	 XtWidth(new), XtHeight(new));

    /* If the label was not initialized with the resource labelString set,
       use its name -- the follow _XmString code comes from MegaButton */
    if (LabG_Label(lg) == (XmString)XmUNSPECIFIED
	|| LabG_Label(lg) == (XmString)0) { /* Shouldn't be necessary but is */
	_XmString xmstring;

	xmstring = _XmOSGetLocalizedString((char *) NULL,
					   (Widget)new,
					   XmNlabelString,
					   XtName(new));

	LabG_Label(lg) = _XmStringCreate(xmstring);
    }

    /* get the default fontlist if the label was created without one. */
    if (LabG_Font(lg) == (XmFontList)XmUNSPECIFIED || LabG_Font(lg) == NULL)
	LabG_Font(lg) = _XmGetDefaultFontList(new, XmLABEL_FONTLIST);

    /* have to check request since new may have been polluted by a
     * superclass 
     */
    if (XtWidth(request) == (Dimension)0 || XtHeight(request) == (Dimension)0) {
	/* call this to determine the real dimensions of the label 
	 * since we don't want to use 0
	 */
	_XmLabelRecalcDimensions(request, new);
    }

    /* compute the internal sizes */
    _XmLabelRecomputeSize(new);

    CreateNormalGC(lg);
    CreateInsensitiveGC(lg);

    /* if the parent is a row column, set the menu_type to
       it's type.  Otherwise, XmNONE  (Is this right?) FIX ME */

    if (XmIsRowColumn(XtParent(new)))
	LabG_MenuType(lg) = RC_Type(XtParent(new));
    else
	LabG_MenuType(lg) = XmNONE;

    /* Force the traversal and highlight on enter resources if
       in an popup, pulldown, and option menus */

    if (LabG_MenuType(lg) == XmMENU_POPUP 
	|| LabG_MenuType(lg) == XmMENU_PULLDOWN
	|| LabG_MenuType(lg) == XmMENU_OPTION)
    {
	G_TraversalOn(lg) = False;
	G_HighlightOnEnter(lg) = False;
    }

    if (! XtIsSubclass(XtParent(new), xmManagerWidgetClass))
        _XmError(new, "parent should be manager.");
}

static void
destroy(Widget w)
{
    XtReleaseGC(w,((XmLabelGadget)w)->label.normal_GC);
    XtReleaseGC(w,((XmLabelGadget)w)->label.insensitive_GC);

    _XmCacheDelete(LabG_Cache(w));
}

static void
resize(Widget w)
{
    _XmCalcLabelDimensions(w);

    if (XtIsRealized(w))
	expose(w, NULL, NULL);
}

/* NB. This should mirror the Label Widget set_values.
JRA
*/

static Boolean
set_values_prehook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec, rsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache(new),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    _XmGadgetImportSecondaryArgs(new, args, num_args);

    XtSetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    LabG_Cache(new) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);

    _XmExtImportArgs((Widget)nsec, args, num_args);

    return FALSE;
}

static Boolean
set_values_posthook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmWidgetExtData ext;

    if (!_XmLabelCacheCompare(LabG_Cache(new), LabG_Cache(old))) {

	_XmCacheDelete((XtPointer)LabG_Cache(old));

	LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
				       (XtPointer)LabG_Cache(new),
				       sizeof(XmLabelGCacheObjPart));
    }
    else
	LabG_Cache(new) = LabG_Cache(old);

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);

    XtFree( (char *) ext);

    return FALSE;
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = False;

    XdbDebug(__FILE__, new, "setting values in a label gadget: %s\n", XtName(new));

    if (LabG_IsText(new))
    {
	if (LabG_AcceleratorText(new) != LabG_AcceleratorText(old)
	    || LabG_Font(new) != LabG_Font(old)
	    || LabG_Mnemonic(new) != LabG_Mnemonic(old)
	    || LabG_MnemonicCharset(new) != LabG_MnemonicCharset(old))

	    refresh_needed = True;
    }

    /* check for change in insensitive pixmap */
    if ((LabG_PixmapInsensitive(new) != LabG_PixmapInsensitive(old)) 
	&& !XtSensitive(new) && LabG_IsPixmap(new))
    {
	if (LabG_RecomputeSize(new))
	{
	    XtWidth(new) = 0;
	    XtHeight(new) = 0;
	}
	refresh_needed = True;
    }

    /* check for change in pixmap */
    if (LabG_Pixmap(new) != LabG_Pixmap(old)) 
    {
	/* if changed pixmap to UNSPECIFIED, automatically configure to a
	 * string
	 */
	if (LabG_IsPixmap(new)
	    && LabG_Pixmap(new) == (Pixmap)XmUNSPECIFIED_PIXMAP)
	{
	    LabG_LabelType(new) = XmSTRING;
	}

	if (LabG_RecomputeSize(new))
	{
	    XtWidth(new) = 0;
	    XtHeight(new) = 0;
 	}
	refresh_needed = True;
    }

    /* if strings changed, free old string, set new string, and
     * ask for refresh 
     */
    if (! XmStringByteCompare(LabG_Label(new), LabG_Label(old)))
    {
	XmStringFree(LabG_Label(old));
	if (LabG_Label(new))
	    LabG_Label(new) = XmStringCopy(LabG_Label(new));
	else
	    LabG_Label(new) = XmStringCreateSimple(XtName(new));
	
	if (LabG_RecomputeSize(new)) 
	{
	    XtWidth(new) = 0;
	    XtHeight(new) = 0;
	}

	refresh_needed = True;
    }

    /* did the label change types? */
    if (LabG_LabelType(new) != LabG_LabelType(old))
    {
	if (LabG_RecomputeSize(new)) 
	{
	    XtWidth(new) = 0;
	    XtHeight(new) = 0;
	}
	refresh_needed = True;
    }

    /* if labelString is still NULL, it was set that way by the
     * user: NULL labelStrings get the widget name
     */
    if (LabG_Label(new) == NULL) {
	LabG_Label(new) = XmStringCreateSimple(XtName(new));
    }

    /* are we supposed to resize? */
    if (XtWidth(new) == 0 || XtHeight(new) == 0) {
	_XmLabelRecalcDimensions(new, new);
	/* don't recompute the size of the internals, this is done
	 * in resize IF the new width/height are ACCEPTED by the parent
	 */
    }

    return refresh_needed;
}

static void
get_values_prehook(Widget new, ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    bcopy(LabG_Cache(new),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    /*
     * don't do this and ResInd will blow up.
     */
    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    XtGetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    _XmExtGetValuesHook((Widget)nsec, args, num_args);
}

static void
get_values_posthook(Widget new, ArgList args, Cardinal *num_args)
{
     XmWidgetExtData ext;

     _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

     _XmExtObjFree((XtPointer)ext->widget);

     XtFree( (char *) ext);
}

static void
get_values_hook(Widget w, ArgList args, Cardinal *num_args)
{
    XdbDebug(__FILE__, w, "LabelG: GetValuesHook\n");
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    XmLabelGadget lg = (XmLabelGadget) w;
    XRectangle cliprect;
    int width, height;
    GC myGC;

    /* if the internals of the widget haven't been recomputed yet,
     * recompute them now (happens if resize isn't called after set_values)
     */
    _XmCalcLabelDimensions(w);

    /* use the right GC */
    if (XtSensitive(XtParent(w)))
        myGC = LabG_NormalGC(lg);
    else
        myGC = LabG_InsensitiveGC(lg);

    /* Set a clip rectangle for the GC - ensure we don't overwrite shadows */
    cliprect.x = XtX(lg) + LabG_TextRect_x(lg);
    cliprect.y = XtY(lg) + LabG_TextRect_y(lg);

    width = LabG_TextRect_width(lg);
    height = LabG_TextRect_height(lg);

    if(width <= 0)
	width = 1;
    if(height <= 0)
	height = 1;
    cliprect.width = width;
    cliprect.height = height;
    XSetClipRectangles(XtDisplayOfObject(w),myGC,0,0,&cliprect,1,Unsorted);
    
#if 0
    /* MLM -- This appears to be right, but it does override the select/arm
     * color for toggle and push button */
    XSetForeground(XtDisplayOfObject(w), myGC,
		   XmParentBackground(w));

    XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w),
		   myGC, 
		   XtX(lg), XtY(lg),
		   XtWidth(lg), XtHeight(lg));

    XSetForeground(XtDisplayOfObject(w), myGC,
		   XmParentForeground(w));
#endif

    if(LabG_IsText(lg) || LabG_Pixmap(lg) == (Pixmap)XmUNSPECIFIED_PIXMAP)
    {
	XmStringDraw(XtDisplayOfObject(w),
		     XtWindowOfObject(w),
		     LabG_Font(lg),
		     LabG_Label(lg),
		     myGC,
		     XtX(lg) + XtBorderWidth(lg) + LabG_TextRect_x(lg),
   		     XtY(lg) + XtBorderWidth(lg) + LabG_TextRect_y(lg),
		     LabG_TextRect_width(lg),
		     LabG_Alignment(lg),
		     0,
		     NULL);
    } 
    else /* XmPIXMAP */
    {
	XdbDebug(__FILE__, w, "XmLabelGadget %s XCopyArea Pixmap 0x%X on win 0x%X\n",
		XtName(lg), LabG_Pixmap(lg), XtWindowOfObject(w));
	XCopyArea(XtDisplayOfObject(w),LabG_Pixmap(lg),XtWindowOfObject(w),
		  myGC,
		  0,
		  0,
		  LabG_TextRect_width(lg),
		  LabG_TextRect_height(lg), 
		  XtX(lg) + XtBorderWidth(lg) + LabG_TextRect_x(lg), 
		  XtY(lg) + XtBorderWidth(lg) + LabG_TextRect_y(lg));
    }
    /* Clear the clip rect */
    XSetClipMask(XtDisplayOfObject(w), myGC, None);
}


static XtGeometryResult 
query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
    XtWidgetGeometry	a;	/* Standin for answer if NULL parameter */

#define	Wants(x)	(proposed->request_mode & x)

    if (proposed->request_mode != 0) {	/* NULL case should not yet end here ! */
	if ((! (Wants(CWWidth))) && (! Wants(CWHeight))) {
		/* If they don't ask width/height, let them have whatever they like */
	    if (answer)
		*answer = *proposed;
	    return XtGeometryYes;
	}
    }

#if 0
    if (LabG_RecomputeSize(w))
	_XmLabelDimensions(w, &a.width, &a.height);
    else
#endif
    {
	a.width = XtWidth(w);
	a.height = XtHeight(w);
    }

    a.request_mode = CWWidth | CWHeight;

    if (answer)
	*answer = a;

    if (proposed->request_mode == 0)	/* NULL proposed -> return Width+Height */
	return XtGeometryAlmost;

    if (proposed->width >= answer->width && proposed->height >= answer->height) 
	return XtGeometryYes;
    else if (answer->width == XtWidth(w) && answer->height == XtHeight(w)) {
	if (answer)
	    answer->request_mode = 0;
	return XtGeometryNo;
    } else 
	return XtGeometryAlmost;
}

static Cardinal
get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data)
{
    /* FIXME */

    return _XmSecondaryResourceData(&_XmLabelGRectClassExtRec,
                                    data, NULL, NULL, NULL, NULL);
}

static void
input_dispatch(Widget gadget, 
	       XEvent *event, 
	       Mask event_mask) 
{
    switch (event_mask)
    {
    case XmHELP_EVENT:
	XdbDebug(__FILE__, gadget, "LabelGadget got help event\n");
	break;
    case XmBDRAG_EVENT:
	XdbDebug(__FILE__, gadget, "LabelGadget got bdrag event\n");
	break;
    }
}

static void 
#ifdef __STDC__
labelg_menu_procs(int function, Widget widget, ...)
{
    va_list arg_list;
    XtPointer foo;
    XEvent *event; 
    XtPointer returnData;

    va_start(arg_list, widget);

#else
labelg_menu_procs(function, widget, va_alist)
    int function;
    Widget widget;
    va_dcl
{
    va_list arglist;
    XtPointer foo;
    XEvent *event; 
    XtPointer returnData;

    va_start(arg_list);

#endif

    foo = va_arg(arg_list, XtPointer);
    event = va_arg(arg_list, XEvent *);
    returnData = va_arg(arg_list, XtPointer);

    switch (function)
    {
    case XmMENU_BUTTON: 
	{
	    /* There was a button press in the menu.  
	       Check to see if it was the valid button
	       for that type of menu */
	    XButtonEvent *xbe = (XButtonEvent*)event;

	    if (!XmIsRowColumn(widget)) {
		va_end(arg_list);
		return;
	    }

	    switch (RC_Type(widget))
	    {
	    case XmMENU_BAR:
	    case XmMENU_PULLDOWN:
	    case XmMENU_OPTION:
		*(Boolean*)returnData = (xbe->button == 1);
		break;
	    case XmMENU_POPUP:
		/* the third mouse button also works in popups */
		*(Boolean*)returnData = ((xbe->button == 1) || (xbe->button == 3));		
		break;
	    default:
		*(Boolean*)returnData = False; /* ? */
		break;
	    }
	    break;
	}
    case XmMENU_POPDOWN:
	break;
    case XmMENU_BUTTON_POPDOWN:
	{
	    Widget shell = XtParent(widget);

	    while (!XtIsShell(shell))
		shell = XtParent(shell);

	    if (LabG_MenuType(widget) == XmMENU_POPUP)
		*(Boolean*)returnData = True;
	    else
		*(Boolean*)returnData = False;

	    XUngrabKeyboard(XtDisplay(widget), CurrentTime);

	    XtCallActionProc(shell, "MenuShellPopdownDone", event, NULL, 0);

	    XUngrabPointer(XtDisplay(widget), CurrentTime);

	    break;
	}
    case XmMENU_SHELL_POPDOWN:
	{
	    XtCallActionProc(widget, "MenuShellPopdownOne", event, NULL, 0);
	    
	    break;
	}
    }
    va_end(arg_list);
}

Widget
XmCreateLabelGadget(Widget parent,
		    char *name,
		    Arg *arglist,
		    Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmLabelGadgetClass,
			  parent,
			  arglist,
			  argcount);
}
