/**
 *
 * $Id: ScrolledW.c,v 1.25 1996/04/22 22:55:47 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: ScrolledW.c,v 1.25 1996/04/22 22:55:47 miers Exp $";

#include <LTconfig.h>
#include <X11/Xfuncs.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/ScrolledWP.h>
#include <Xm/ScrollBarP.h>
#include <Xm/DrawingA.h>
#include <stdio.h>
#include <Xm/XmI.h>
#include <Xm/RowColumnP.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void resize(Widget w);
static void realize(Widget w, Mask *value_mask, XSetWindowAttributes *attributes);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void change_managed(Widget w);
static void insert_child(Widget w);
static XtGeometryResult geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *intended, XtWidgetGeometry *preferred);

static void RepositionScrolledWindow(Widget w, XtPointer client, XtPointer call);


/*
 * Resources for the ScrolledWindow class
 */
#define Offset(field) XtOffsetOf(XmScrolledWindowRec, swindow.field)
#define MGR_Offset(field) XtOffsetOf(XmScrolledWindowRec, manager.field)
static XtResource resources[] = {
    {
	XmNhorizontalScrollBar, XmCHorizontalScrollBar, XmRWidget,
	sizeof(Widget), Offset(hScrollBar),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNverticalScrollBar, XmCVerticalScrollBar, XmRWidget,
	sizeof(Widget), Offset(vScrollBar),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNworkWindow, XmCWorkWindow, XmRWidget,
	sizeof(Widget), Offset(WorkWindow),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNclipWindow, XmCClipWindow, XmRWidget,
	sizeof(Widget), Offset(ClipWindow),
	XtRImmediate, (XtPointer)NULL
    },
    {
	XmNscrollingPolicy, XmCScrollingPolicy, XmRScrollingPolicy,
	sizeof(unsigned char), Offset(ScrollPolicy),
	XmRImmediate, (XtPointer)XmAPPLICATION_DEFINED
    },
    {
	XmNvisualPolicy, XmCVisualPolicy, XmRVisualPolicy,
	sizeof(unsigned char), Offset(VisualPolicy),
	XmRImmediate, (XtPointer)XmVARIABLE
    },
    {
	XmNscrollBarDisplayPolicy, XmCScrollBarDisplayPolicy, XmRScrollBarDisplayPolicy,
	sizeof(unsigned char), Offset(ScrollBarPolicy),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNscrollBarPlacement, XmCScrollBarPlacement, XmRScrollBarPlacement,
	sizeof(unsigned char), Offset(Placement),
	XtRImmediate, (XtPointer)XmBOTTOM_RIGHT
    },
    {
	XmNscrolledWindowMarginWidth, XmCScrolledWindowMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), Offset(WidthPad),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNscrolledWindowMarginHeight, XmCScrolledWindowMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), Offset(HeightPad),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNspacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(pad),
	XtRImmediate, (XtPointer)XmINVALID_DIMENSION
    },
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), MGR_Offset(shadow_thickness),
	XmRImmediate, (XtPointer)XmINVALID_DIMENSION
    },
    {
	XmNtraverseObscuredCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(traverseObscuredCallback),
	XmRImmediate, NULL
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNscrolledWindowMarginWidth,
	sizeof(Dimension), Offset(WidthPad),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNscrolledWindowMarginHeight,
	sizeof(Dimension), Offset(HeightPad),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNspacing,
	sizeof(Dimension), Offset(pad),
	_XmFromVerticalPixels, NULL
    }
};

static void PageUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PageDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PageLeft(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PageRight(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void BeginLine(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EndLine(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void BeginData(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EndData(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmScrolledW_ScrolledWindowXlations[] =
   "<EnterWindow>:            ManagerEnter()\n\
    <FocusOut>:               ManagerFocusOut()\n\
    <FocusIn>:                ManagerFocusIn()\n\
    <Btn2Down>:               ManagerGadgetDrag()\n\
    <Key>osfActivate:         ManagerParentActivate()\n\
    <Key>osfCancel:           ManagerParentCancel()\n\
    c <Key>osfBeginLine:      SWTopLine()\n\
    <Key>osfBeginLine:        SWBeginLine()\n\
    c <Key>osfEndLine:        SWBottomLine()\n\
    <Key>osfEndLine:          SWEndLine()\n\
    <Key>osfPageLeft:         SWLeftPage()\n\
    c <Key>osfPageUp:         SWLeftPage()\n\
    <Key>osfPageUp:           SWUpPage()\n\
    <Key>osfPageRight:        SWRightPage()\n\
    c <Key>osfPageDown:       SWRightPage()\n\
    <Key>osfPageDown:         SWDownPage()\n\
    <Key>osfHelp:             ManagerGadgetHelp()\n\
    <Key>osfUp:               ManagerGadgetTraverseUp()\n\
    <Key>osfDown:             ManagerGadgetTraverseDown()\n\
    <Key>osfLeft:             ManagerGadgetTraverseLeft()\n\
    <Key>osfRight:            ManagerGadgetTraverseRight()\n\
    ~s ~m ~a <Key>Return:     ManagerParentActivate()\n\
    s ~m ~a <Key>Tab:         ManagerGadgetPrevTabGroup()\n\
    ~m ~a <Key>Tab:           ManagerGadgetNextTabGroup()";

/*
 * MLM: FIXME -- the following two translation tables need to be installed.
 * Without them, misc/test1.c doesn't compile.
 */
char _XmScrolledW_ClipWindowTranslationTable[] =
    "<MapNotify>:           SWNoop() \n\
     :c <Key>osfBeginLine:  SWTopLineGrab() \n\
     :<Key>osfBeginLine:    SWBeginLineGrab() \n\
     :c <Key>osfEndLine:    SWBottomLineGrab() \n\
     :<Key>osfEndLine:      SWEndLineGrab() \n\
     :<Key>osfPageLeft:     SWLeftPageGrab() \n\
     :c <Key>osfPageUp:     SWLeftPageGrab() \n\
     :<Key>osfPageUp:       SWUpPageGrab() \n\
     :<Key>osfPageRight:    SWRightPageGrab() \n\
     :c <Key>osfPageDown:   SWRightPageGrab() \n\
     :<Key>osfPageDown:     SWDownPageGrab()";

char _XmScrolledW_WorkWindowTranslationTable[] =
    ":c <Key>osfBeginLine:  SWTopLineWork() \n\
     :<Key>osfBeginLine:    SWBeginLineWork() \n\
     :c <Key>osfEndLine:    SWBottomLineWork() \n\
     :<Key>osfEndLine:      SWEndLineWork()"; 

static XtActionsRec actions[] = {
    {"SWUpPage", PageUp},
    {"SWDownPage", PageDown},
    {"SWLeftPage", PageLeft},
    {"SWRightPage", PageRight},
    {"SWBeginLine", BeginLine},
    {"SWEndLine", EndLine},
    {"SWTopLine", BeginData},
    {"SWBottomLine", EndData}
};

static XmBaseClassExtRec _XmScrolledWCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

static XmManagerClassExtRec _XmScrolledWMClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmManagerClassExtVersion,
    /* record_size               */ sizeof(XmManagerClassExtRec),
    /* traversal_children        */ NULL /* FIXME */
};

XmScrolledWindowClassRec xmScrolledWindowClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmManagerClassRec,
        /* class_name            */ "XmScrolledWindow",
	/* widget_size           */ sizeof(XmScrolledWindowRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ realize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ _XmScrolledW_ScrolledWindowXlations,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmScrolledWCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */ geometry_manager, 
        /* change_managed   */ change_managed, 
        /* insert_child     */ insert_child,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ NULL,
    },
    /* Constraint class part */
    {
	/* subresources      */ NULL,  /* FIX ME */
        /* subresource_count */ 0,     /* FIX ME */
        /* constraint_size   */ 0,     /* FIX ME */
        /* initialize        */ NULL,  /* FIX ME */
        /* destroy           */ NULL,  /* FIX ME */
        /* set_values        */ NULL,  /* FIX ME */
        /* extension         */ NULL,   /* FIX ME */
    },
    /* XmManager class part */
    {
        /* translations                 */ XmInheritTranslations,
        /* syn_resources                */ syn_resources,
        /* num_syn_resources            */ XtNumber(syn_resources),
        /* syn_constraint_resources     */ NULL,
        /* num_syn_constraint_resources */ 0,
        /* parent_process               */ XmInheritParentProcess,
        /* extension                    */ (XtPointer)&_XmScrolledWMClassExtRec
    },
    /* XmScrolledWindow part */
    {
	/* extension */ NULL,
    },
};

WidgetClass xmScrolledWindowWidgetClass = (WidgetClass)&xmScrolledWindowClassRec;

static void 
class_initialize()
{
    _XmScrolledWCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    XmScrolledWindowWidgetClass swclass = (XmScrolledWindowWidgetClass) widget_class;
    CompositeClassExtension ext, *extptr;

    extptr = (CompositeClassExtension*)_XmGetClassExtensionPtr((XmGenericClassExt*)&(swclass->composite_class.extension),
							       NULLQUARK);

    if (extptr == NULL || *extptr == NULL)
    {
	ext = (CompositeClassExtension) XtNew(CompositeClassExtensionRec);
	if (ext != NULL)
	{
	    ext->next_extension = swclass->composite_class.extension;
	    ext->record_type = NULLQUARK;
	    ext->version = XtCompositeExtensionVersion;
	    ext->record_size = sizeof(CompositeClassExtensionRec);
	    ext->accepts_objects = True;
#if XtSpecificationRelease >= 6
	    ext->allows_change_managed_set = True;
#endif
	    swclass->composite_class.extension = (XtPointer) ext;
	}
    }    
    _XmFastSubclassInit(widget_class, XmSCROLLED_WINDOW_BIT);
}

/*
 * Note
 * The OSF/Motif manual page for XmScrolledWindow describes a "clip" widget
 * and a "work" widget. The Clip widget is really the area that the user sees,
 * whereas the Work widget is the one that is put in the ScrolledWindow.
 * I.e. if you display a large label widget, then that label is the work widget,
 * and the clip widget is something magic that is private to scrolledwindow.
 */
static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    if (SW_ScrollBarPolicy(new) == (unsigned char)XmUNSPECIFIED) {
	if (SW_ScrollPolicy(new) == XmAUTOMATIC)
	    SW_ScrollBarPolicy(new) = XmAS_NEEDED;
	else
	    SW_ScrollBarPolicy(new) = XmSTATIC;
    }

    if (SW_ScrollPolicy(new) == XmAUTOMATIC)
	SW_VisualPolicy(new) = XmCONSTANT;
    else
	SW_VisualPolicy(new) = XmVARIABLE;

    if (SW_Spacing(new) == XmINVALID_DIMENSION)
	SW_Spacing(new) = 4;

    if (MGR_ShadowThickness(new) == XmINVALID_DIMENSION)
	MGR_ShadowThickness(new) = 2;

    if (SW_ScrollPolicy(new) == XmAUTOMATIC) {
	SW_VSB(new) = XtVaCreateManagedWidget("VertScrollBar",
		xmScrollBarWidgetClass, new,
		XmNorientation, XmVERTICAL,
		NULL);
	SW_HasVSB(new) = True;

	XtAddCallback(SW_VSB(new),
		      XmNincrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_VSB(new),
		      XmNdecrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_VSB(new),
		      XmNpageIncrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_VSB(new),
		      XmNpageDecrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_VSB(new),
		      XmNdragCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_VSB(new),
		      XmNvalueChangedCallback,
		      RepositionScrolledWindow,
		      NULL);

	SW_HSB(new) = XtVaCreateManagedWidget("HorScrollBar",
		xmScrollBarWidgetClass, new,
		XmNorientation, XmHORIZONTAL,
		NULL);
	SW_HasHSB(new) = True;

	XtAddCallback(SW_HSB(new),
		      XmNincrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_HSB(new),
		      XmNdecrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_HSB(new),
		      XmNpageIncrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_HSB(new),
		      XmNpageDecrementCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_HSB(new),
		      XmNdragCallback,
		      RepositionScrolledWindow,
		      NULL);
	XtAddCallback(SW_HSB(new),
		      XmNvalueChangedCallback,
		      RepositionScrolledWindow,
		      NULL);
    }
    else {
	SW_VSBMinimum(new) = 0;
	SW_VSBMaximum(new) = 0;
	SW_VSBValue(new) = 0;
	SW_VSBSliderSize(new) = 0;

	SW_HSBMinimum(new) = 0;
	SW_HSBMaximum(new) = 0;
	SW_HSBValue(new) = 0;
	SW_HSBSliderSize(new) = 0;

	SW_HSBX(new) = 0;
	SW_HSBY(new) = 0;
	SW_HSBWidth(new) = 0;
	SW_HSBHeight(new) = 0;

	SW_VSBX(new) = 0;
	SW_VSBY(new) = 0;
	SW_VSBWidth(new) = 0;
	SW_VSBHeight(new) = 0;

	SW_WorkWidth(new) = 0;
	SW_WorkHeight(new) = 0;

	SW_ClipWidth(new) = 0;
	SW_ClipHeight(new) = 0;
	SW_ClipX(new) = 0;
	SW_ClipY(new) = 0;

	SW_HasHSB(new) = False;
	SW_HasVSB(new) = False;
	SW_WorkWindow(new) = NULL;
	SW_ClipWindow(new) = NULL;
	SW_HSB(new) = NULL;
	SW_VSB(new) = NULL;

    }

    if (SW_VisualPolicy(new) == XmCONSTANT) {
	SW_ClipWindow(new) = XtCreateManagedWidget("clipWindow",
		xmDrawingAreaWidgetClass, new, NULL, 0);
    }
    else if (SW_VisualPolicy(new) != XmVARIABLE)
	SW_VisualPolicy(new) = XmVARIABLE;

    if (SW_VisualPolicy(new) == XmVARIABLE && SW_ScrollBarPolicy(new) != XmSTATIC)
	SW_ScrollBarPolicy(new) = XmSTATIC;

    SW_FromResize(new) = False;
    SW_InInit(new) = True;
    /* init chained from super to sub order */
    _XmScrolledWindowLayout(new, True, NULL, False, NULL,
			    0, 0, XtWidth(new), XtHeight(new));
    SW_InInit(new) = False;
}

static void
destroy(Widget w)
{
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean			r = False;	/* Must I be redisplayed ? */

    XdbDebug(__FILE__, new, "SetValues\n");

#define	NE(x)	(x(new) != x(old))

    if (NE(SW_ClipWindow)) {
	SW_ClipWindow(new) = SW_ClipWindow(old);
	_XmWarning(new,
		   "Attempted to change the clipWindow in scrolled window %s",
		   XtName(new));
    }
    if (NE(SW_VisualPolicy)) {
	SW_VisualPolicy(new) = SW_VisualPolicy(old);
	_XmWarning(new,
		   "Attempted to change the visualPolicy in scrolled window %s",
		   XtName(new));
    }
    if (NE(SW_ScrollPolicy)) {
	SW_ScrollPolicy(new) = SW_ScrollPolicy(old);
	_XmWarning(new,
		   "Attempted to change the scrollingPolicy in scrolled window %s",
		   XtName(new));
    }

    if (NE(SW_HSB)) {
	if (SW_HSB(new) && XtIsManaged(SW_HSB(new)))
	    SW_HasHSB(new) = True;
	else
	    SW_HasHSB(new) = False;
	r = True;
    }
    if (NE(SW_VSB)) {
	if (SW_VSB(new) && XtIsManaged(SW_VSB(new)))
	    SW_HasVSB(new) = True;
	else
	    SW_HasVSB(new) = False;
	r = True;
    }

    if (NE(SW_ScrollBarPolicy)
     || NE(SW_Placement)
     || NE(SW_MarginHeight)
     || NE(SW_MarginWidth)
     || NE(SW_Spacing)
     || NE(SW_TraverseObscuredCallback)
     || NE(SW_WorkWindow) ) {
	r = True;
    }

    SW_FromResize(new) = True;
    /* set values chained in super to sub order */
    _XmScrolledWindowLayout(new, True, NULL, FALSE, NULL,
			    0, 0, XtWidth(new), XtHeight(new));
    SW_FromResize(new) = False;

    return r;
}

static void
resize(Widget w)
{
    XdbDebug(__FILE__, w, "Resize: x %d y %d w %d h %d\n",
	     XtX(w), XtY(w), XtWidth(w), XtHeight(w));

    SW_FromResize(w) = True;
    /* resize not chained */
    _XmScrolledWindowLayout(w, False, NULL, False, NULL,
			    0, 0, XtWidth(w), XtHeight(w));
    SW_FromResize(w) = False;
}

static void
expose(Widget w, XEvent *event, Region region) 
{
    if (SW_ClipWindow(w)) {
       _XmDrawShadows(XtDisplay(w), XtWindow(w),
                      MGR_TopShadowGC(w), MGR_BottomShadowGC(w),
                      SW_ClipX(w) - MGR_ShadowThickness(w),
		      SW_ClipY(w) - MGR_ShadowThickness(w),
                      SW_ClipWidth(w) + 2 * MGR_ShadowThickness(w),
		      SW_ClipHeight(w) + 2 * MGR_ShadowThickness(w),
                      MGR_ShadowThickness(w), XmSHADOW_IN);
    }

    _XmRedisplayGadgets(w, event, region);
}
      
static void 
realize(Widget w, Mask *value_mask, XSetWindowAttributes *attributes)
{

    XdbDebug(__FILE__, w, "Realize\n");

#define superclass (&xmManagerClassRec)
    (*superclass->core_class.realize)(w, value_mask, attributes);
#undef superclass

    SW_FromResize(w) = True;
    /* not chained */
    _XmScrolledWindowLayout(w, True, NULL, False, NULL,
			    0, 0, XtWidth(w), XtHeight(w));
    SW_FromResize(w) = False;
} 

static XtGeometryResult
query_geometry(Widget w, XtWidgetGeometry *intended, XtWidgetGeometry *preferred)
{
    XdbDebug(__FILE__, w, "QueryGeometry(W %d H %d)\n", intended->width, intended->height);

    /* not chained */
    _XmScrolledWindowLayout(w, False, w, False, preferred,
			    0, 0, XtWidth(w), XtHeight(w));

    if (intended == NULL) { /* This never happens */
	if (XtWidth(w) != preferred->width || XtHeight(w) != preferred->height)
	    return XtGeometryAlmost;		/* Something's different */
	return XtGeometryNo;			/* Everything is ok */
    }
    if ((intended->request_mode & CWWidth) && preferred->width != intended->width) {
	XdbDebug(__FILE__, w, "QueryGeometry => ALMOST (w %d)\n", preferred->width);
	return XtGeometryAlmost;		/* Something's different */
    }
    if ((intended->request_mode & CWHeight) && preferred->height != intended->height) {
	XdbDebug(__FILE__, w, "QueryGeometry => ALMOST (h %d)\n", preferred->height);
	return XtGeometryAlmost;		/* Something's different */
    }
    XdbDebug(__FILE__, w, "QueryGeometry => YES\n");
    return XtGeometryYes;			/* I'm happy */
}

static XtGeometryResult
geometry_manager(Widget w, XtWidgetGeometry *desired, XtWidgetGeometry *allowed)
{
    XtWidgetGeometry wants;
    Widget sw = XtParent(w);

    XdbDebug2(__FILE__, sw, w, "GeometryManager\n");

#define	Wants(flag)	(desired->request_mode & flag)

    if (desired != NULL && allowed != NULL && desired != allowed)
	wants = *desired;
    else
	bzero((void *)&wants, sizeof(XtWidgetGeometry));
    /*
     * We control the XY of all children.  Width/Height is all I care about */
    wants.request_mode = CWWidth | CWHeight;

    /* not chained */
    _XmScrolledWindowLayout(XtParent(w), False, w, True, &wants,
			    0, 0, XtWidth(w), XtHeight(w));

    if (allowed)
	*allowed = wants;

    if (Wants(XtCWQueryOnly)) {
	XdbDebug2(__FILE__, sw, w, "GeometryManager QueryOnly not implemented ! (=> YES)\n");
	return XtGeometryYes;
    }

    if (Wants(CWX) && Wants(CWY) && !(Wants(CWWidth) && Wants(CWHeight)))
	return XtGeometryNo;

    if (Wants(CWWidth) && wants.width == desired->width &&
	Wants(CWHeight) && wants.height == desired->height)
	return XtGeometryYes;

    else if ((Wants(CWWidth) && wants.width < desired->width) ||
	     (Wants(CWHeight) && wants.height < desired->height))
	return XtGeometryAlmost;

    return XtGeometryNo;
}

static void
change_managed(Widget w)
{
    if (SW_HSB(w) && XtIsManaged(SW_HSB(w)))
	SW_HasHSB(w) = True;
    else
	SW_HasHSB(w) = False;
    if (SW_VSB(w) && XtIsManaged(SW_VSB(w)))
	SW_HasVSB(w) = True;
    else
	SW_HasVSB(w) = False;

    /* not chained */
    _XmScrolledWindowLayout(w, True, NULL, False, NULL,
			    0, 0, XtWidth(w), XtHeight(w));
}

/*
 * In here we probably need some trickery to make things work.
 * One sensible thing to do is to make the work widget the
 * child of the clip widget. This is ugly, though. That's probably the
 * reason why the X Consortium never wanted to add XtReparentWidget().
 *
 * The advantage of reparenting the work widget is, all you have to do
 * to scroll is tell the work widget where it is. Through the magic of
 * the X window system having window hierarchies, things should work.
 */
static void
insert_child(Widget w)
{
    XmScrolledWindowWidget sw = (XmScrolledWindowWidget)XtParent(w);

#define superclass (&xmManagerClassRec)

/* Special first case : these are not the work window */
/* Note this is especially here for our subclass XmMainWindow */
    if (XmIsSeparator(w) || XmIsSeparatorGadget(w)
	|| (XmIsRowColumn(w) && RC_Type(w) == XmMENU_BAR))
	(*superclass->composite_class.insert_child)(w);
    else if (XmIsScrollBar(w)) {
	(*superclass->composite_class.insert_child)(w);

	switch (SCB_Orientation(w)) {
	case XmHORIZONTAL:
	    SW_HSB(sw) = w;
	    if (XtIsManaged(w))
		SW_HasHSB(w) = True;
	    else
		SW_HasHSB(w) = False;
	    break;
	case XmVERTICAL:
	    SW_VSB(sw) = w;
	    if (XtIsManaged(w))
		SW_HasVSB(w) = True;
	    else
		SW_HasVSB(w) = False;
	    break;
	default:
	    _XmWarning((Widget)sw,
		      "Can't determine ScrollBar orientation in ScrolledWindow %s: Not adding",
		      XtName(sw));
	    break;
	}
    }
    /*
     * only we can add a clip window, and we know it's id
     */
    else if (SW_VisualPolicy(sw) == XmCONSTANT && SW_ClipWindow(sw) == NULL) {
	(*superclass->composite_class.insert_child)(w);
    }
    /*
     * THIS IS SOO UGLY
     *
     * if we're not XmCONSTANT, don't reparent
     *
     */
    else if (SW_VisualPolicy(sw) == XmCONSTANT) {
	XdbDebug2(__FILE__, w, (Widget)sw, "Reparented to %s\n", XtName(SW_ClipWindow(sw)));
	
	XtParent(w) = SW_ClipWindow(sw);

	/*
	 * Now we're reparented. Go on inserting the child as if
	 * nothing happened
	 */
	(*superclass->composite_class.insert_child)(w);

        SW_WorkWindow(sw) = w;
    }
    else {
	XdbDebug2(__FILE__, w, (Widget)sw, "Child is Work Window\n");
	(*superclass->composite_class.insert_child)(w);

        SW_WorkWindow(sw) = w;
    }
#undef superclass
}

static void
RepositionScrolledWindow(Widget w, XtPointer client, XtPointer call)
{
    int h, v;
    Widget sw = XtParent(w);

    XtVaGetValues(SW_VSB(sw),
		  XmNvalue, &v,
		  NULL);
    SW_VSBValue(sw) = v;

    XtVaGetValues(SW_HSB(sw),
		  XmNvalue, &h,
		  NULL);
    SW_HSBValue(sw) = h;

    XdbDebug2(__FILE__, sw, w, "Hor %d Vert %d\n", h, v);

    /*
     * Position the work window
     */
    if (SW_WorkWindow(sw))
	XtMoveWidget(SW_WorkWindow(sw), -h, -v);
}

/*
 * to get here, we have to have gone through the layout function.  All our
 * instance variable should have reasonable values.
 */
static void
FixupScrollBars(Widget w) {
    int max, min, percent;

    if (!SW_ClipWindow(w)) {
	_XmWarning(w,
		   "Requested to do scrolling without a clip window: %s",
		   XtName(w));
	return;
    }

    /*
     * see if we have a work window.  If not, pick some reasonable defaults
     */
    if (!SW_WorkWindow(w)) {
	if (SW_HasHSB(w)) {
	    XtVaGetValues(SW_HSB(w),
			  XmNmaximum, &max,
			  XmNminimum, &min,
			  NULL);
	    XtVaSetValues(SW_HSB(w),
			  XmNsliderSize, max - min,
			  XmNvalue, 0,
			  NULL);
	}
	if (SW_HasVSB(w)) {
	    XtVaGetValues(SW_VSB(w),
			  XmNmaximum, &max,
			  XmNminimum, &min,
			  NULL);
	    XtVaSetValues(SW_VSB(w),
			  XmNsliderSize, max - min,
			  XmNvalue, 0,
			  NULL);
	}
	return;
    }

    /*
     * otherwise, fixup the scrollbars.
     */
    if (SW_HasHSB(w)) {
	if (SW_WorkWidth(w) <= SW_ClipWidth(w) || SW_WorkWidth(w) == 0) {
	    percent = 100;
	    max = 100;
	    min = 0;
	}
	else {
	    max = SW_WorkWidth(w);
	    min = 0;
	    percent = (int)(((float)SW_ClipWidth(w) /
			     (float)SW_WorkWidth(w)) *
			    (float)SW_WorkWidth(w));
	}
	XtVaSetValues(SW_HSB(w),
		      XmNminimum, min,
		      XmNmaximum, max,
		      XmNsliderSize, percent,
		      XmNpageIncrement, SW_ClipWidth(w),
		      NULL);
	SW_HSBMinimum(w) = min;
	SW_HSBMaximum(w) = max;
	SW_HSBSliderSize(w) = percent;
    }
    if (SW_HasVSB(w)) {
	if (SW_WorkHeight(w) <= SW_ClipHeight(w) || SW_WorkHeight(w) == 0) {
	    percent = 100;
	    max = 100;
	    min = 0;
	}
	else {
	    max = SW_WorkHeight(w);
	    min = 0;
	    percent = (int)(((float)SW_ClipHeight(w) /
			     (float)SW_WorkHeight(w)) *
			    (float)SW_WorkHeight(w));
	}
	XtVaSetValues(SW_VSB(w),
		      XmNminimum, min,
		      XmNmaximum, max,
		      XmNsliderSize, percent,
		      XmNpageIncrement, SW_ClipHeight(w),
		      NULL);
	SW_VSBMinimum(w) = min;
	SW_VSBMaximum(w) = max;
	SW_VSBSliderSize(w) = percent;
    }
}

void
_XmScrolledWindowLayout(Widget w, Boolean ParentResize,
			Widget child, Boolean TestMode,
			XtWidgetGeometry *childgeom,
			Position x, Position y,
			Dimension fw, Dimension fh)
{
    XtWidgetGeometry	geo;
    Dimension		curw, curh;
    Dimension		wantw, wanth;
    XtGeometryResult	result;

    XdbDebug(__FILE__, w, "XmScrolledWindowLayout (%s) [my size %d %d]\n",
	     (SW_ScrollPolicy(w) == XmAPPLICATION_DEFINED)
	     ? "XmAPPLICATION_DEFINED" : "XmAUTOMATIC",
	     XtWidth(w), XtHeight(w));
    
    curw = 2 * SW_MarginWidth(w);
    curh = 2 * SW_MarginHeight(w);

    /*
     * First ask our child how big it wants to be; we'll try to be larger than
     * this
     */
    if (SW_WorkWindow(w)) {
	(void) XtQueryGeometry(SW_WorkWindow(w), NULL, &geo);
	if (geo.request_mode & CWWidth)
	    curw += geo.width;
	if (geo.request_mode & CWHeight)
	    curh += geo.height;

        SW_WorkWidth(w) = geo.width;
	SW_WorkHeight(w) = geo.height;
    }
    else {
	SW_WorkWidth(w) = 0;
	SW_WorkHeight(w) = 0;
    }

    /*
     * add in the scrollbars if they're managed.
     * we have to adjust this if AS_NEEDED
     */
    if (SW_ScrollBarPolicy(w) != XmAS_NEEDED) {

	if (SW_HasHSB(w)) {
	    curh += SW_Spacing(w);

	    if (SW_WorkHeight(w) != 0)
		curh += XtHeight(SW_HSB(w));
	    else if (XtHeight(SW_HSB(w)) >
		     (curh - 2 * SW_MarginHeight(w) - SW_Spacing(w)))
		curh = XtHeight(SW_HSB(w)) + 2 * SW_MarginHeight(w) + SW_Spacing(w);

	    if (SW_WorkWidth(w) == 0 &&
		XtWidth(SW_HSB(w)) > (curw - 2 * SW_MarginWidth(w)))
		curw = XtWidth(SW_HSB(w)) + 2 * SW_MarginWidth(w);
	}

	if (SW_HasVSB(w)) {
	    curw += SW_Spacing(w);

	    if (SW_WorkWidth(w) != 0)
		curw += XtWidth(SW_VSB(w));
	    else if (XtWidth(SW_VSB(w)) >
		     (curw - 2 * SW_MarginWidth(w) - SW_Spacing(w)))
		curw = XtWidth(SW_VSB(w)) + 2 * SW_MarginWidth(w) + SW_Spacing(w);

	    if (SW_WorkHeight(w) == 0 &&
		XtHeight(SW_VSB(w)) > (curh - 2 * SW_MarginHeight(w)))
		curh += XtHeight(SW_VSB(w)) + 2 * SW_MarginHeight(w);
	}
    }

    /*
     * see if we came here via query_geometry()
     */
    if (child && w == child) {
	childgeom->request_mode = CWWidth | CWHeight;
	childgeom->width = curw;
	childgeom->height = curh;
	return;
    }

    /*
     * if we can, change our size to match
     */
    wantw = curw;
    wanth = curh;
    if (ParentResize && SW_VisualPolicy(w) != XmCONSTANT) {
        do {
	    result = XtMakeResizeRequest(w, curw, curh, &curw, &curh);
        } while (result == XtGeometryAlmost);

	if (result == XtGeometryNo) {
	    curw = fw;
	    curh = fh;
	}
	if (result == XtGeometryYes) {
	    XtWidth(w) = curw;
	    XtHeight(w) = curh;
	}
	XdbDebug(__FILE__, w, "_XmScrolledWindowLayout (%d %d) => %s\n",
                 curw, curh, XdbGeometryResult2String(result));
    }
    else {
	curw = fw;
	curh = fh;
    }

    /*
     * see if we need to manage/unmanage a scrollbar 'cause we've gotten too
     * small or too large
     */
    if (SW_ScrollBarPolicy(w) == XmAS_NEEDED) {
	if (SW_HSB(w)) {
	    if (curw < wantw && !XtIsManaged(SW_HSB(w))) {
		XtManageChild(SW_HSB(w));
		SW_HasHSB(w) = True;
	    }
	    else if (curw >= wantw && XtIsManaged(SW_HSB(w))) {
		XtUnmanageChild(SW_HSB(w));
		SW_HasHSB(w) = False;
	    }
	}
	if (SW_VSB(w)) {
	    if (curh < wanth && !XtIsManaged(SW_VSB(w))) {
		XtManageChild(SW_VSB(w));
		SW_HasVSB(w) = True;
	    }
	    else if (curh >= wanth && XtIsManaged(SW_VSB(w))) {
		XtUnmanageChild(SW_VSB(w));
		SW_HasVSB(w) = False;
	    }
	}
    }

    /*
     * figure out the layout, based on placement policy.
     */
    switch(SW_Placement(w)) {
    case XmTOP_RIGHT:
	SW_ClipWidth(w) = curw - 2 * SW_MarginWidth(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipHeight(w) = curh - 2 * SW_MarginHeight(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipX(w) = SW_MarginWidth(w) + MGR_ShadowThickness(w);
	SW_ClipY(w) = SW_MarginHeight(w) + MGR_ShadowThickness(w);

	if (SW_HasHSB(w)) {
	    SW_HSBX(w) = SW_MarginWidth(w);
	    SW_HSBY(w) = SW_MarginHeight(w);
	    SW_HSBWidth(w) = XtWidth(w) - 2 * SW_MarginWidth(w);
	    SW_HSBHeight(w) = XtHeight(SW_HSB(w));
	    if (SW_HasVSB(w))
		SW_HSBWidth(w) -= XtWidth(SW_VSB(w)) + SW_Spacing(w);
	    if (TestMode && child && child == SW_HSB(w)) {
		childgeom->x = SW_HSBX(w) + x;
		childgeom->y = SW_HSBY(w) + y;
		childgeom->width = SW_HSBWidth(w);
		childgeom->height = SW_HSBHeight(w);
		return;
	    }
	    SW_ClipHeight(w) -= SW_Spacing(w) + SW_HSBHeight(w);
	    SW_ClipY(w) += SW_Spacing(w) + SW_HSBHeight(w);
	}

	if (SW_HasVSB(w)) {
	    SW_VSBY(w) = SW_MarginHeight(w);
	    SW_VSBX(w) = curw - SW_MarginWidth(w) - XtWidth(SW_VSB(w));
	    SW_VSBWidth(w) = XtWidth(SW_VSB(w));
	    SW_VSBHeight(w) = XtHeight(w) - 2 * SW_MarginHeight(w);
	    if (SW_HasHSB(w)) {
		SW_VSBY(w) += XtHeight(SW_HSB(w)) + SW_Spacing(w);
		SW_VSBHeight(w) -= XtHeight(SW_HSB(w)) + SW_Spacing(w);
	    }
	    if (TestMode && child && child == SW_VSB(w)) {
		childgeom->x = SW_VSBX(w) + x;
		childgeom->y = SW_VSBY(w) + y;
		childgeom->width = SW_VSBWidth(w);
		childgeom->height = SW_VSBHeight(w);
		return;
	    }
	    SW_ClipWidth(w) -= SW_Spacing(w) + SW_VSBWidth(w);
	}
	break;

    case XmBOTTOM_LEFT:
	SW_ClipWidth(w) = curw - 2 * SW_MarginWidth(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipHeight(w) = curh - 2 * SW_MarginHeight(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipX(w) = SW_MarginWidth(w) + MGR_ShadowThickness(w);
	SW_ClipY(w) = SW_MarginHeight(w) + MGR_ShadowThickness(w);

	if (SW_HasHSB(w)) {
	    SW_HSBX(w) = SW_MarginWidth(w);
	    SW_HSBY(w) = curh - SW_MarginHeight(w) - XtHeight(SW_HSB(w));
	    SW_HSBWidth(w) = XtWidth(w) - 2 * SW_MarginWidth(w);
	    SW_HSBHeight(w) = XtHeight(SW_HSB(w));
	    if (SW_HasVSB(w)) {
		SW_HSBWidth(w) -= XtWidth(SW_VSB(w)) + SW_Spacing(w);
		SW_HSBX(w) += XtWidth(SW_VSB(w)) + SW_Spacing(w);
	    }
	    if (TestMode && child && child == SW_HSB(w)) {
		childgeom->x = SW_HSBX(w) + x;
		childgeom->y = SW_HSBY(w) + y;
		childgeom->width = SW_HSBWidth(w);
		childgeom->height = SW_HSBHeight(w);
		return;
	    }
	    SW_ClipHeight(w) -= SW_Spacing(w) + SW_HSBHeight(w);
	}

	if (SW_HasVSB(w)) {
	    SW_VSBY(w) = SW_MarginHeight(w);
	    SW_VSBX(w) = SW_MarginWidth(w);
	    SW_VSBWidth(w) = XtWidth(SW_VSB(w));
	    SW_VSBHeight(w) = XtHeight(w) - 2 * SW_MarginHeight(w);
	    if (SW_HasHSB(w))
		SW_VSBHeight(w) -= XtHeight(SW_HSB(w)) + SW_Spacing(w);
	    if (TestMode && child && child == SW_VSB(w)) {
		childgeom->x = SW_VSBX(w) + x;
		childgeom->y = SW_VSBY(w) + y;
		childgeom->width = SW_VSBWidth(w);
		childgeom->height = SW_VSBHeight(w);
		return;
	    }
	    SW_ClipWidth(w) -= SW_Spacing(w) + SW_VSBWidth(w);
	    SW_ClipX(w) += SW_Spacing(w) + SW_VSBWidth(w);
	}
	break;

    case XmTOP_LEFT:
	SW_ClipWidth(w) = curw - 2 * SW_MarginWidth(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipHeight(w) = curh - 2 * SW_MarginHeight(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipX(w) = SW_MarginWidth(w) + MGR_ShadowThickness(w);
	SW_ClipY(w) = SW_MarginHeight(w) + MGR_ShadowThickness(w);

	if (SW_HasHSB(w)) {
	    SW_HSBX(w) = SW_MarginWidth(w);
	    SW_HSBY(w) = SW_MarginHeight(w);
	    SW_HSBWidth(w) = XtWidth(w) - 2 * SW_MarginWidth(w);
	    SW_HSBHeight(w) = XtHeight(SW_HSB(w));
	    if (SW_HasVSB(w)) {
		SW_HSBX(w) += XtWidth(SW_VSB(w)) + SW_Spacing(w);
		SW_HSBWidth(w) -= XtWidth(SW_VSB(w)) + SW_Spacing(w);
	    }
	    if (TestMode && child && child == SW_HSB(w)) {
		childgeom->x = SW_HSBX(w) + x;
		childgeom->y = SW_HSBY(w) + y;
		childgeom->width = SW_HSBWidth(w);
		childgeom->height = SW_HSBHeight(w);
		return;
	    }
	    SW_ClipHeight(w) -= SW_Spacing(w) + SW_HSBHeight(w);
	    SW_ClipY(w) += SW_Spacing(w) + SW_HSBHeight(w);
	}

	if (SW_HasVSB(w)) {
	    SW_VSBY(w) = SW_MarginHeight(w);
	    SW_VSBX(w) = SW_MarginWidth(w);
	    SW_VSBWidth(w) = XtWidth(SW_VSB(w));
	    SW_VSBHeight(w) = XtHeight(w) - 2 * SW_MarginHeight(w);
	    if (SW_HasHSB(w)) {
		SW_VSBHeight(w) -= XtHeight(SW_HSB(w)) + SW_Spacing(w);
		SW_VSBY(w) += XtHeight(SW_HSB(w)) + SW_Spacing(w);
	    }
	    if (TestMode && child && child == SW_VSB(w)) {
		childgeom->x = SW_VSBX(w) + x;
		childgeom->y = SW_VSBY(w) + y;
		childgeom->width = SW_VSBWidth(w);
		childgeom->height = SW_VSBHeight(w);
		return;
	    }
	    SW_ClipWidth(w) -= SW_Spacing(w) + SW_VSBWidth(w);
	    SW_ClipX(w) += SW_Spacing(w) + SW_VSBWidth(w);
	}
	break;

    case XmBOTTOM_RIGHT:
    default:
	SW_ClipWidth(w) = curw - 2 * SW_MarginWidth(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipHeight(w) = curh - 2 * SW_MarginHeight(w) - 2 * MGR_ShadowThickness(w);
	SW_ClipX(w) = SW_MarginWidth(w) + MGR_ShadowThickness(w);
	SW_ClipY(w) = SW_MarginHeight(w) + MGR_ShadowThickness(w);

	if (SW_HasHSB(w)) {
	    SW_HSBX(w) = SW_MarginWidth(w);
	    SW_HSBY(w) = curh - SW_MarginHeight(w) - XtHeight(SW_HSB(w));
	    SW_HSBWidth(w) = XtWidth(w) - 2 * SW_MarginWidth(w);
	    SW_HSBHeight(w) = XtHeight(SW_HSB(w));
	    if (SW_HasVSB(w))
		SW_HSBWidth(w) -= XtWidth(SW_VSB(w)) + SW_Spacing(w);
	    if (TestMode && child && child == SW_HSB(w)) {
		childgeom->x = SW_HSBX(w) + x;
		childgeom->y = SW_HSBY(w) + y;
		childgeom->width = SW_HSBWidth(w);
		childgeom->height = SW_HSBHeight(w);
		return;
	    }
	    SW_ClipHeight(w) -= SW_Spacing(w) + SW_HSBHeight(w);
	}

	if (SW_HasVSB(w)) {
	    SW_VSBY(w) = SW_MarginHeight(w);
	    SW_VSBX(w) = curw - SW_MarginWidth(w) - XtWidth(SW_VSB(w));
	    SW_VSBWidth(w) = XtWidth(SW_VSB(w));
	    SW_VSBHeight(w) = XtHeight(w) - 2 * SW_MarginHeight(w);
	    if (SW_HasHSB(w))
		SW_VSBHeight(w) -= XtHeight(SW_HSB(w)) + SW_Spacing(w);
	    if (TestMode && child && child == SW_VSB(w)) {
		childgeom->x = SW_VSBX(w) + x;
		childgeom->y = SW_VSBY(w) + y;
		childgeom->width = SW_VSBWidth(w);
		childgeom->height = SW_VSBHeight(w);
		return;
	    }
	    SW_ClipWidth(w) -= SW_Spacing(w) + SW_VSBWidth(w);
	}
	break;
    }

    /*
     * see if it was the clip window that wanted to change.
     */
    if (child && child == SW_ClipWindow(w)) {
	childgeom->x = SW_ClipX(w) + x;
	childgeom->y = SW_ClipY(w) + y;
	childgeom->width = SW_ClipWidth(w);
	childgeom->height = SW_ClipHeight(w);
	return;
    }

    /*
     * now configure everybody
     */
    if (SW_HasHSB(w)) {
	_XmConfigureObject(SW_HSB(w),
			   SW_HSBX(w) + x, SW_HSBY(w) + y,
			   SW_HSBWidth(w), SW_HSBHeight(w),
			   XtBorderWidth(SW_HSB(w)));
    }
    if (SW_HasVSB(w)) {
	_XmConfigureObject(SW_VSB(w),
			   SW_VSBX(w) + x, SW_VSBY(w) + y,
			   SW_VSBWidth(w), SW_VSBHeight(w),
			   XtBorderWidth(SW_VSB(w)));
    }
    if (SW_ClipWindow(w)) {
	_XmConfigureObject(SW_ClipWindow(w),
			   SW_ClipX(w) + x,
			   SW_ClipY(w) + y,
			   SW_ClipWidth(w),
			   SW_ClipHeight(w),
			   XtBorderWidth(SW_ClipWindow(w)));
    }

    if (SW_ScrollPolicy(w) == XmAPPLICATION_DEFINED && SW_FromResize(w) &&
	SW_WorkWindow(w) != NULL) {
	_XmConfigureObject(SW_WorkWindow(w),			/* This kills GIMP */
			   SW_ClipX(w) + x, SW_ClipY(w) + y,
			   SW_ClipWidth(w), SW_ClipHeight(w),
			   XtBorderWidth(SW_WorkWindow(w)));
    }

    if (SW_ScrollPolicy(w) == XmAUTOMATIC)
	FixupScrollBars(w);
}

/*
 * FIXME - MLM -- I don't know if direct value passing is ok.  Does someone?
 */
static String moves[2] = {
    "0",
    "1"
};
#define PAGE_UP		&moves[0]
#define PAGE_DOWN	&moves[0]
#define PAGE_LEFT	&moves[1]
#define PAGE_RIGHT	&moves[1]

static void
PageUp(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasVSB(w))
	XtCallActionProc(SW_VSB(w), "PageUpOrLeft", event, PAGE_UP, 1);
}

static void
PageDown(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasVSB(w))
	XtCallActionProc(SW_VSB(w), "PageDownOrRight", event, PAGE_DOWN, 1);
}

static void
PageLeft(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasHSB(w))
	XtCallActionProc(SW_HSB(w), "PageUpOrLeft", event, PAGE_LEFT, 1);
}

static void
PageRight(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasHSB(w))
	XtCallActionProc(SW_HSB(w), "PageDownOrRight", event, PAGE_RIGHT, 1);
}

static void
BeginLine(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasHSB(w))
	XtCallActionProc(SW_HSB(w), "TopOrBottom", event, params, *num_params);
}

static void
EndLine(Widget w,
	XEvent *event,
	String *params,
	Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasHSB(w))
	XtCallActionProc(SW_HSB(w), "TopOrBottom", event, params, *num_params);
}

static void
BeginData(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasVSB(w))
	XtCallActionProc(SW_VSB(w), "TopOrBottom", event, params, *num_params);
}

static void
EndData(Widget w,
	XEvent *event,
	String *params,
	Cardinal *num_params)
{
    if (SW_ScrollPolicy(w) == XmAUTOMATIC && SW_HasVSB(w))
	XtCallActionProc(SW_VSB(w), "TopOrBottom", event, params, *num_params);
}

Widget
XmCreateScrolledWindow(Widget parent, 
		       char *name,
		       Arg *argList,
		       Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmScrolledWindowWidgetClass,
			  parent,
			  argList, argcount);
}

void 
XmScrollVisible(Widget scrollw_widget,
		Widget widget,
		Dimension left_right_margin,
		Dimension top_bottom_margin)
{
}

void 
XmScrolledWindowSetAreas(Widget widget,
			 Widget h_scrollbar,
			 Widget v_scrollbar,
			 Widget work_region)
{
    XtVaSetValues(widget,
		  XmNhorizontalScrollBar, h_scrollbar,
		  XmNverticalScrollBar, v_scrollbar,
		  XmNworkWindow, work_region,
		  NULL);
}

