/**
 *
 * $Id: TearOff.c,v 1.8 1996/04/22 22:56:00 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: TearOff.c,v 1.8 1996/04/22 22:56:00 miers Exp $";

#include <LTconfig.h>
#include <Xm/AtomMgr.h>
#include <Xm/Protocols.h>
#include <Xm/DebugUtil.h>
#include <Xm/TearOffP.h>
#include <Xm/RowColumnP.h>
#include <Xm/PushB.h>
#include <Xm/XmI.h>

XmExcludedParentPaneRec _XmExcludedParentPane = { 0 };

void CleanupMenuBar(Widget w, XEvent *event, String *params, Cardinal *num_params);

void 
_XmTearOffBtnDownEventHandler(Widget reportingWidget,
			      XtPointer data,
			      XEvent *event,
			      Boolean *cont)
{
    XdbDebug(__FILE__, reportingWidget, "_XmTearOffBtnDownEventHandler()\n");
}

void 
_XmTearOffBtnUpEventHandler(Widget reportingWidget,
			    XtPointer data,
			    XEvent *event,
			    Boolean *cont)
{
    XdbDebug(__FILE__, reportingWidget, "_XmTearOffBtnUpEventHandler()\n");
}

void 
_XmDestroyTearOffShell(Widget w)
{
    XdbDebug(__FILE__, w, "_XmDestroyTearOffShell()\n");
}
   
void 
_XmDismissTearOff(Widget shell,
		  XtPointer closure,
		  XtPointer call_data)
{
	Widget		menu;
	ShellWidget	sw = (ShellWidget) shell;

	XdbDebug(__FILE__, shell, "_XmDismissTearOff()\n");

	menu = sw->composite.children[1];	/* FIX ME - 0 is the vendor ext */
	XtUnmanageChild(menu);

	(*((TransientShellWidgetClass)transientShellWidgetClass)
		->composite_class.delete_child)((Widget)menu);
	XtParent(menu) = RC_ParentShell(menu);
	XtDestroyWidget(shell);
}

void 
_XmTearOffInitiate(Widget w,
		   XEvent *event)
{
	Widget	mb, s, menu;
	int	nargs, i;
	Arg	args[8];
	Atom	delete_atom;

	XdbDebug(__FILE__, w, "_XmTearOffInitiate()\n");

/* Use the Menu Bar as a parent for our transient Shell. */
	for (mb=w; XtParent(mb) && !(XmIsRowColumn(mb) && RC_Type(mb) == XmMENU_BAR); )
		mb = XtParent(mb);

/* Cleanup Menu stuff */
	menu = XtParent(w);
	if (((XmRowColumnWidget)menu)->row_column.cascadeBtn)
	    CleanupMenuBar(((XmRowColumnWidget)menu)->row_column.cascadeBtn, event, NULL, 0);

/* Make the buttons behave like outside a menu system */
	for (i=0; i<MGR_NumChildren(menu); i++)
		if (XtIsSubclass(MGR_Children(menu)[i], xmPushButtonWidgetClass)) {
			XdbDebug2(__FILE__, menu, MGR_Children(menu)[i],
				"_XmTearOffInitiate: set normal translations on button\n");
			_XmPushButtonSetTranslation(MGR_Children(menu)[i], 0);
		}

/* Pop down the menu */
	if (! XmIsRowColumn(menu)) {
		XdbDebug2(__FILE__, menu, w, "Parent is not a menu\n");
		return;
	}

/* This is a simple case : works only if one level of menu .. FIX ME */
	XtUnmanageChild(menu);
	XtUngrabPointer(menu, CurrentTime);

/*
 * Now make a transient shell.
 * Dirty trickery will be used now... we'll reparent the menu
 *	so it'll be in the new shell.
 */
	nargs = 0;
	XtSetArg(args[nargs], XmNdeleteResponse, XmDO_NOTHING); nargs++;
	XtSetArg(args[nargs], XmNallowShellResize, True); nargs++;

	s = XtCreatePopupShell("tearOffShell", transientShellWidgetClass,
		mb, args, nargs);

	menu->core.mapped_when_managed = True;

	RC_ParentShell(menu) = XtParent(menu);	/* Preserve the value somewhere */
	XtParent(menu) = s;
	XtManageChild(menu);

	(*((TransientShellWidgetClass)transientShellWidgetClass)
		->composite_class.insert_child)((Widget)menu);

	_XmMoveObject(s, event->xbutton.x_root, event->xbutton.y_root);

	(*((TransientShellWidgetClass)transientShellWidgetClass)
		->composite_class.change_managed) (s);

	XtRealizeWidget(s);

	XReparentWindow(XtDisplay(s), XtWindow(menu), XtWindow(s), 0, 0);
	XtPopup(s, XtGrabNone);

/*
 * The call below seems to be necessary, I must confess I don't know why...
 * Maybe Xt doesn't want us to reparent widgets after all :-)
 */
	XMapWindow(XtDisplay(menu), XtWindow(menu));
/*
 * Get a popdown handler too
 */
	delete_atom = XmInternAtom(XtDisplay(s), "WM_DELETE_WINDOW", FALSE);
	XmAddWMProtocolCallback(s, delete_atom, _XmDismissTearOff, NULL);
}

void 
_XmAddTearOffEventHandlers(Widget w)
{
    XdbDebug(__FILE__, w, "_XmAddTearOffEventHandlers()\n");
}

Boolean 
_XmIsTearOffShellDescendant(Widget w)
{
    XdbDebug(__FILE__, w, "_XmIsTearOffShellDescendant()\n");

    return False;
}

void 
_XmLowerTearOffObscuringPoppingDownPanes(Widget ancestor,
					 Widget tearOff)
{
    XdbDebug2(__FILE__, ancestor, tearOff, "_XmLowerTearOffObscuringPoppingDownPanes()\n");
}

void
_XmRestoreExcludedTearOffToToplevelShell(Widget w,
					 XEvent *event)
{
    XdbDebug(__FILE__, w, "_XmRestoreExcludedTearOffToToplevelShell()\n");
}

void 
_XmRestoreTearOffToToplevelShell(Widget w,
				 XEvent *event)
{
    XdbDebug(__FILE__, w, "_XmRestoreTearOffToToplevelShell()\n");
}

void 
_XmRestoreTearOffToMenuShell(Widget w,
			     XEvent *event)
{
    XdbDebug(__FILE__, w, "_XmRestoreTearOffToMenuShell()\n");
}
