.lf 1 sql/create_view.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/devel/pglite/cvs/src/doc/ref/sql/create_view.cmdsrc,v 1.1 1996/02/24 01:16:59 jolly Exp $
.TH "CREATE VIEW" COMMANDS 11/05/95
.XA 2 "Create View"
.SH NAME
create view \(em construct a virtual class
.SH SYNOPSIS
.(l M
\fBcreate view\fR view_name \fBas\fR
	\fBselect\fR expression1 [\fBas\fR attr_name1]
	{, expression_i [\fBas\fR attr_namei]}
	[\fBfrom\fR from.last]
	[\fBwhere\fR qual]
.)l
.SH DESCRIPTION
.BR "create view"
will define a view of a class.  This view is not physically
materialized; instead the rule system is used to support view
processing as in [STON90].  Specifically, a query rewrite retrieve
rule is automatically generated to support retrieve operations on
views.  Then, the user can add as many update rules as desired to
specify the processing of update operations to views.  See [STON90]
for a detailed discussion of this point.
.SH EXAMPLE
.(C
--
--create a view consisting of toy department employees
--
create view toyemp as
  	select e.name
	from emp e
	where e.dept = 'toy'
.)C
.(C
--
--Specify deletion semantics for toyemp
--
create rule example1 as
	on delete to toyemp
	do instead delete emp
	where emp.oid = current.oid
.)C
.SH "SEE ALSO"
create table(commands), 
create rule(commands),
