'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'----------------------------------------------------------------------
.HS tixGrid tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixGrid \- Create and manipulate Tix Grid widgets
'
.PP
\fIThis manual page is not complete. It will be completed in the next
release of Tix.
\fR
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixGrid\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
None.
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBforeground\fR
\fBfont\fR	\fBheight\fR	\fBhighlightColor \fBhighlightThickness	
\fBrelief\fR	\fBselectBackground\fR	\fBselectForeground\fR
\fBxScrollCommand\fR	\fByScrollCommand\fR	\fBwidth\fR
.ta 4c 
.fi
.LP
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBformatCmd\fR
Class:		\fBformatCmd\fR
Switch:		\fB\-formatcmd\fR
.fi
.IP
If non-empty, gives a Tcl command to be executed when the grid cells
need to be formatted on the screen. Normally, this command calls
the \fBformat\fR widget command (see below). When this command is
called, it is passed with five additional parameters: \fItype x1 y1 x2
y2\fR. \fIx1 y1 x2 y2\fR gives the extent of the region that needs
formatting. \fItype\fR gives the logical type of the region in the
grid. It may be one of the following. \fBx-region\fR: the horizontal
margin; \fBy-region\fR: the vertical margin; \fIs-region\fR, the area
where the the horizontal and vertical margins are joined; \fBmain\fR:
all the cells that do not fall into the above three types.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBleftMargin\fR
Class:		\fBLeftMargin\fR
Switch:		\fB\-leftmargin\fR
.fi
.IP
In the number of cells, gives the width of vertical margin. A zero
indicates that no vertical should be drawn.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtopMargin\fR
Class:		\fBTopMargin\fR
Switch:		\fB\-topmargin\fR
.fi
.IP
In the number of cells, gives the height of horizontal margin. A zero
indicates that no horizontal should be drawn.
'----------END
'
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixGrid\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a Grid widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
Grid widget such as its cursor and relief.
.PP
A Grid widget displays its contents in a two dimensional grid of
cells. Each cell may contain one Tix\fB display item\fR, which may be
in text, graphics or other formats. See the \fBtixItemType(n)\fR for
more information about Tix display items. Individual cells, or groups
of cells, can be formatted with a wide range of attributes, such as
its color, relief and border.
.PP
This version of Grid does not support dynamic editing of the contents
of the cells. This feature is expected to be added in the near future.
'----------------------------------------------------------------------
.SH "WIDGET COMMAND"
.PP
'
The \fBtixGrid\fR command creates a new Tcl command whose name is the
same as the path name of the Grid widget's window.  This command
may be used to invoke various operations on the widget.  It has the
following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as
the Grid widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for Grid widgets:
'
.TP
\fIpathName \fBanchor get \fIx y\fR
'
Returns a list of two elements. The first element is the row number of
the anchor cell and the second element is the column number. The
anchor cell is the end of the selection that is fixed while the user is
dragging out a selection with the mouse.
'
.TP
\fIpathName \fBanchor clear\fR
'
Removes the anchor, if any, from this Grid widget. This only removes
the surrounding highlights of the anchor cell and does not affect its
selection status.
'
.TP
\fIpathName \fBanchor set \fIx y\fR
'
Sets the anchor to be at cell (\fIx\fR,\fI).
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixGrid\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list). If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixGrid\fR command.
'
'.TP
'\fIpathName \fBdelete \fIx y\fR
'
'Deletes the display item in the cell at location (\fIx\fR,\fIy\fR). 
'
.TP
\fIpathName \fBformat \fItype x1 y1 x2 y2 \fR?\fIoption value ...\fR?
'
Formats the border and background colors of the cells in the range
(\fIx1\fR,\fIy1\fR) to (\fIx2\fR,\fIy2\fR). This command draws
rectangles in these cells to achieve various formatting effects.  The
size and location of the rectangles are controlled by the \fB-xon\fR,
\fB-xoff\fR, \fB-yon\fR and \fB-yoff\fR options (see below.)
\fItype\fR may be \fBborder\fR or \fBgrid\fR. The \fBborder\fR formats
the region with 3D borders. The \fBgrid\fR formats the region into a
set of grids that do not display 3D borders. The following options may
be passed in \fIoption-value\fR pairs to configure the properties of
the formatting of the cells within the range.
'
.RS
.TP
\fB\-background\fR \fIcolor\fR
'
Gives the background color of the cells and the 3D borders.
'
.TP
\fB\-borderwidth\fR \fIpixels\fR
'
Gives the with of the 3D borders or the grid borders.
'
.TP
\fB\-filled\fR \fIboolean\fR
'
Specifies whether the background of the cells should be affected by
the \fB\-background\fR option. When set the false (the default), the 
\fB\-background\fR option affects only the 3D border of the cells.
'
.TP
\fB\-xon\fR \fIint\fR \fB\-xoff\fR \fIint\fR
'
These two options controls the size and location of the rectangles in
the horizontal dimension. If \fB\-xon\fR is set to 0, the width of the
rectangles will span the whole region. Specifically, if both
\fB\-xon\fR and \fB\-yon\fR are set to 0, the \fBformat\fR command
draws a single rectangle that surrounds the whole region given by
(\fIx1\fR,\fIy1\fR) and (\fIx2\fR,\fIy2\fR). If \fB\-xon\fR is
non-zero, the \fBformat\fR command starts at cell (\fIx1\fR,\fIy1\fR),
draws a rectangle that spans the the width of the number of cells
given by \fB\-xon\fR, skips the number of cells given by \fB\-xoff\fR,
and it repeats the process until it reaches (\fIx2\fR,\fIy2\fR).
'
.TP
\fB\-yon\fR \fIint\fR \fB\-yoff\fR \fIint\fR
'
These two options controls the size and location of the rectangles in
the vertical dimension. See \fB\-xon\fR and \fB\-xoff\fR above.
'
.RE
The \fBformat\fR command may be called only inside the Tcl procedure
specified in the \fB\-formatcmd\fR option.
'
.TP
\fIpathName \fBset \fIx y -itemtype type \fR?\fIoption value ...\fR?
'
Creates a display item of \fItype\fR in the cell at location
(\fIx\fR,\fIy\fR). Extra options may be passed in \fIoption-value\fR
pairs to configure the properties of the display item. See
\fBDItem(n)\fR for a description on display items.
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n), Grid Widget, Display Items

