#include "wily.h"
#include "view.h"

static void		view_cursor(View *v, Rune r);

static void
addrune(View*v, Rune r)
{
	Rstring	s;

	if ( r == '\n' && v->autoindent) {
		s = text_autoindent(v->t, v->sel.p0);
	} else {
		s.r0 = &r;
		s.r1 = &r +1;
	}
	if(RLEN(v->sel)){
		snarf(v->t, v->sel);
	}
	text_replace(v->t, v->sel, s);
	view_show(v, v->sel);
}

static void
exec_selection(View *v)
{
	char*cmd;
	cmd = text_duputf(v->t, v->sel);
	if (!data_sendexec(view_data(v),cmd, 0))
		run(v, cmd, 0);
	free(cmd);
}

void
dokeyboard(View *v, Rune r)
{
	Range	del = v->sel;
	
	switch(r) {
	case DownArrow:
	case UpArrow:
	case Home:
	case End:
	case LeftArrow:
	case RightArrow:	view_cursor(v, r); 	break;
	
	case PageDown:	
	case PageUp:		view_pagedown(v,r==PageDown); break;
	
	case Ctrlh:
	case Backspace:	/* delete selection and rune before */	
		if(del.p0)
			del.p0--;
		view_cut(v, del);
		break;
	case Ctrlu:		/* delete selection and back to start of line */
		del.p0 = text_nl(v->t, del.p0, 0);
		view_cut(v, del);
		break;
	case Ctrlw:		/* delete back to start of word */
		del.p0 = text_startofword(v->t, del.p0);
		view_cut(v, del);
		break;
		
	case Esc:
		if ((RLEN(del))) {
			/* delete selected text */
			view_cut(v, del);	
		} else {
			/* Select from v->anchor to v->sel.p0 */
			view_select(v, range(v->anchor, v->sel.p0));
			view_setlastselection(v);
		}
		break;
	case '\n':			if (!v->scroll) {
						view_select(v, range(v->anchor, v->sel.p0));
						exec_selection(v);
						break;
					}
					/* otherwise fall through */
					
	default:			addrune(v,r);
	}
}

/*
 * We've hit a cursor key.
 * 
 * Set the selection to something relative to previous sel.p0, and
 * make sure the new selection is visible.
 */
static void
view_cursor(View *v, Rune r)
{
	ulong	p;
	Point	pt;

	p = v->sel.p0;
	switch(r) {
	case LeftArrow:
		if(p)
			p--;
		break;
	case RightArrow:
		if (p < text_length(v->t))
			p++;
		break;
	case DownArrow:
	case UpArrow:
		pt = frptofchar(&v->f, p - v->visible.p0);
		if (r==DownArrow)
			pt.y += v->f.font->height;
		else
			pt.y -= v->f.font->height;
		p = frcharofpt(&v->f, pt) + v->visible.p0;
		break;
	case Home:
		p = 0;
		break;
	case End:
		p = text_length(v->t);
		break;
	}
	view_select(v, range(p,p));
	view_show(v, v->sel);
}

void
view_linesdown(View *v, int n, Bool down)
{
	Mouse	m;
	Rectangle	r;

	if(! (v = tile_body(view_win(v))) )
		return;

	r = v->r;
	m.xy.x = r.min.x;
	m.xy.y = r.min.y + v->f.font->height * n;
	m.buttons = down? RIGHT : LEFT;
	view_scroll(v, &m);
}

void
view_pagedown(View *v, Bool down)
{
	Mouse	m;
	Rectangle	r;

	if(! (v = tile_body(view_win(v))) )
		return;

	r = v->r;
	m.xy.x = r.min.x;
	m.xy.y = (r.min.y + r.max.y) /2;
	m.buttons = down? RIGHT : LEFT;
	view_scroll(v, &m);
}

